/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventField;
import com.intellij.internal.statistic.eventLog.EventFields;
import com.intellij.internal.statistic.eventLog.EventId3;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

public class FileTypeUsagesCollector
extends ProjectUsagesCollector {
    private static final String DEFAULT_ID = "third.party";
    private final EventLogGroup GROUP = new EventLogGroup("file.types", 3);
    private final EventId3<Object, String, Integer> FILE_IN_PROJECT = this.GROUP.registerEvent("file.in.project", EventFields.PluginInfoFromInstance, (EventField)EventFields.String((String)"file_type").withCustomRule("file_type"), (EventField)EventFields.Int((String)"count"));

    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    public CancellablePromise<Set<MetricEvent>> getMetrics(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(1);
        }
        HashSet events = new HashSet();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager == null) {
            CancellablePromise cancellablePromise = Promises.resolvedCancellablePromise(Collections.emptySet());
            if (cancellablePromise == null) {
                FileTypeUsagesCollector.$$$reportNull$$$0(2);
            }
            return cancellablePromise;
        }
        FileType[] registeredFileTypes = fileTypeManager.getRegisteredFileTypes();
        ArrayList<CancellablePromise> promises = new ArrayList<CancellablePromise>(registeredFileTypes.length);
        for (FileType fileType : registeredFileTypes) {
            if (project.isDisposed()) {
                CancellablePromise cancellablePromise = Promises.resolvedCancellablePromise(Collections.emptySet());
                if (cancellablePromise == null) {
                    FileTypeUsagesCollector.$$$reportNull$$$0(3);
                }
                return cancellablePromise;
            }
            promises.add(ReadAction.nonBlocking(() -> {
                IProjectStore stateStore = ProjectKt.getStateStore(project);
                Ref counter = new Ref((Object)0);
                FileTypeIndex.processFiles((FileType)fileType, file2 -> {
                    ProgressManager.checkCanceled();
                    if (!stateStore.isProjectFile((VirtualFile)file2)) {
                        counter.set((Object)((Integer)counter.get() + 1));
                    }
                    return true;
                }, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
                Integer count = (Integer)counter.get();
                if (count != 0) {
                    events.add(this.FILE_IN_PROJECT.metric((Object)fileType, (Object)FileTypeUsagesCollector.getSafeFileTypeName(fileType), (Object)StatisticsUtil.getNextPowerOfTwo((int)count)));
                }
            }).wrapProgress(indicator).expireWith((Disposable)project).submit((Executor)NonUrgentExecutor.getInstance()));
        }
        CancellablePromise cancellablePromise = (CancellablePromise)Promises.all(promises).then(o -> events);
        if (cancellablePromise == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(4);
        }
        return cancellablePromise;
    }

    @NotNull
    public static FeatureUsageData newFeatureUsageData(@NotNull FileType type) {
        if (type == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(5);
        }
        FeatureUsageData data2 = new FeatureUsageData();
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(type.getClass());
        data2.addPluginInfo(info);
        data2.addData("file_type", FileTypeUsagesCollector.getSafeFileTypeName(type));
        FeatureUsageData featureUsageData = data2;
        if (featureUsageData == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(6);
        }
        return featureUsageData;
    }

    public static String getSafeFileTypeName(@NotNull FileType fileType) {
        PluginInfo info;
        if (fileType == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(7);
        }
        return (info = PluginInfoDetectorKt.getPluginInfo(fileType.getClass())).isDevelopedByJetBrains() ? fileType.getName() : DEFAULT_ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newFeatureUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newFeatureUsageData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSafeFileTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ValidationRule
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "file_type".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                ValidationRule.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ValidationRule.$$$reportNull$$$0(1);
            }
            if (ValidationRule.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    ValidationRule.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            FileType fileType = FileTypeManager.getInstance().findFileTypeByName(data2);
            if (fileType == null || !StringUtil.equals((CharSequence)fileType.getName(), (CharSequence)data2)) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    ValidationRule.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            boolean isDevelopedByJB = PluginInfoDetectorKt.getPluginInfo(fileType.getClass()).isDevelopedByJetBrains();
            ValidationResultType validationResultType = isDevelopedByJB ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                ValidationRule.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector$ValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector$ValidationRule";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

