/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ui.HighlightableCellRenderer;
import com.intellij.ui.HighlightedRegion;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class MultiLineTodoRenderer
extends JPanel
implements TreeCellRenderer {
    private static final int MAX_DISPLAYED_LINES = 10;
    private final HighlightableCellRenderer myPrefixRenderer;
    private final HighlightableCellRenderer[] myLineRenderers = new HighlightableCellRenderer[10];
    private final JLabel myMoreLabel;

    public MultiLineTodoRenderer() {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.myPrefixRenderer = new HighlightableCellRenderer();
        this.add((Component)this.myPrefixRenderer, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        for (int i2 = 0; i2 < 10; ++i2) {
            c.gridy = i2;
            this.myLineRenderers[i2] = new HighlightableCellRenderer();
            this.add((Component)this.myLineRenderers[i2], c);
        }
        ++c.gridy;
        this.myMoreLabel = new JLabel(IdeBundle.message((String)"node.todo.more.items", (Object[])new Object[0]));
        this.add((Component)this.myMoreLabel, c);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TodoItemNode node = (TodoItemNode)((DefaultMutableTreeNode)value2).getUserObject();
        String text = value2.toString();
        int parenPos = text.indexOf(41);
        int contentStartPos = parenPos >= 0 && parenPos < text.length() - 1 ? parenPos + 2 : 0;
        this.myPrefixRenderer.getTreeCellRendererComponent(tree, (Object)text.substring(0, contentStartPos), selected2, expanded, leaf, row, hasFocus);
        this.myPrefixRenderer.setIcon(node.getIcon());
        List<HighlightedRegionProvider> additionalLines = node.getAdditionalLines();
        for (int i2 = 0; i2 < 10; ++i2) {
            if (i2 > additionalLines.size()) {
                this.myLineRenderers[i2].setVisible(false);
                continue;
            }
            this.myLineRenderers[i2].setVisible(true);
            this.myLineRenderers[i2].getTreeCellRendererComponent(tree, i2 == 0 ? text.substring(contentStartPos) : additionalLines.get(i2 - 1), selected2, expanded, leaf, row, hasFocus);
            TodoItemNode provider = i2 == 0 ? node : additionalLines.get(i2 - 1);
            for (HighlightedRegion region : provider.getHighlightedRegions()) {
                this.myLineRenderers[i2].addHighlighter(region.startOffset - (i2 == 0 ? contentStartPos : 0), region.endOffset - (i2 == 0 ? contentStartPos : 0), region.textAttributes);
            }
        }
        this.myMoreLabel.setVisible(additionalLines.size() >= 10);
        return this;
    }
}

