/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class InstalledPluginsState {
    private final Object myLock = new Object();
    private final Map<PluginId, IdeaPluginDescriptor> myInstalledPlugins = new IdentityHashMap<PluginId, IdeaPluginDescriptor>();
    private final Set<PluginId> myInstalledWithoutRestartPlugins = new HashSet<PluginId>();
    private final Set<PluginId> myUpdatedPlugins = new HashSet<PluginId>();
    private final Set<PluginId> myUninstalledWithoutRestartPlugins = new HashSet<PluginId>();
    private final Set<String> myOutdatedPlugins = new SmartHashSet();
    private boolean myInstallationInProgress = false;
    private boolean myRestartRequired = false;
    private Runnable myShutdownCallback;
    private static List<IdeaPluginDescriptor> myPreInstalledPlugins;

    @Nullable
    public static InstalledPluginsState getInstanceIfLoaded() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() ? InstalledPluginsState.getInstance() : null;
    }

    public static InstalledPluginsState getInstance() {
        return (InstalledPluginsState)ServiceManager.getService(InstalledPluginsState.class);
    }

    public static void addPreInstalledPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(0);
        }
        if (myPreInstalledPlugins == null) {
            myPreInstalledPlugins = new ArrayList<IdeaPluginDescriptor>();
        }
        myPreInstalledPlugins.add(descriptor2);
    }

    public InstalledPluginsState() {
        if (myPreInstalledPlugins != null) {
            for (IdeaPluginDescriptor plugin : myPreInstalledPlugins) {
                if (PluginManagerCore.isPluginInstalled(plugin.getPluginId())) continue;
                this.onPluginInstall(plugin, false, false);
            }
            myPreInstalledPlugins = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<IdeaPluginDescriptor> getInstalledPlugins() {
        Object object = this.myLock;
        // MONITORENTER : object
        Collection<IdeaPluginDescriptor> collection = Collections.unmodifiableCollection(this.myInstalledPlugins.values());
        // MONITOREXIT : object
        if (collection != null) return collection;
        InstalledPluginsState.$$$reportNull$$$0(1);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<PluginId> getUpdatedPlugins() {
        Object object = this.myLock;
        // MONITORENTER : object
        Collection<PluginId> collection = Collections.unmodifiableCollection(this.myUpdatedPlugins);
        // MONITOREXIT : object
        if (collection != null) return collection;
        InstalledPluginsState.$$$reportNull$$$0(2);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewerVersion(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            return !this.wasUpdated(id2) && this.myOutdatedPlugins.contains(id2.getIdString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasInstalled(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myInstalledPlugins.containsKey(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasInstalledWithoutRestart(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myInstalledWithoutRestartPlugins.contains(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasUninstalledWithoutRestart(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myUninstalledWithoutRestartPlugins.contains(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasUpdated(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myUpdatedPlugins.contains(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDescriptorDownload(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId id2;
        IdeaPluginDescriptor existing;
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(8);
        }
        if ((existing = PluginManagerCore.getPlugin(id2 = descriptor2.getPluginId())) == null || existing.isBundled() && !existing.allowBundledUpdate() || this.wasUpdated(id2)) {
            return;
        }
        boolean supersedes = PluginManagerCore.isCompatible(descriptor2) && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor2.getVersion(), existing) > 0;
        String idString = id2.getIdString();
        Object object = this.myLock;
        synchronized (object) {
            if (supersedes) {
                this.myOutdatedPlugins.add(idString);
            } else {
                this.myOutdatedPlugins.remove(idString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginInstall(@NotNull IdeaPluginDescriptor descriptor2, boolean isUpdate, boolean restartNeeded) {
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(9);
        }
        PluginId id2 = descriptor2.getPluginId();
        Object object = this.myLock;
        synchronized (object) {
            this.myOutdatedPlugins.remove(id2.getIdString());
            if (isUpdate) {
                this.myUpdatedPlugins.add(id2);
            } else if (restartNeeded) {
                this.myInstalledPlugins.put(id2, descriptor2);
            } else {
                this.myInstalledWithoutRestartPlugins.add(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginUninstall(@NotNull IdeaPluginDescriptor descriptor2, boolean restartNeeded) {
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(10);
        }
        PluginId id2 = descriptor2.getPluginId();
        Object object = this.myLock;
        synchronized (object) {
            if (!restartNeeded) {
                this.myUninstalledWithoutRestartPlugins.add(id2);
            }
        }
    }

    public void resetChangesAppliedWithoutRestart() {
        if (!this.myInstallationInProgress) {
            this.myInstalledWithoutRestartPlugins.clear();
            this.myUninstalledWithoutRestartPlugins.clear();
        }
    }

    public void trackPluginInstallation(Runnable runnable2) {
        this.myInstallationInProgress = true;
        try {
            runnable2.run();
        }
        finally {
            this.myInstallationInProgress = false;
        }
    }

    public void setShutdownCallback(Runnable runnable2) {
        if (this.myShutdownCallback == null) {
            this.myShutdownCallback = runnable2;
        }
    }

    public void clearShutdownCallback() {
        this.myShutdownCallback = null;
    }

    public void runShutdownCallback() {
        if (this.myShutdownCallback != null) {
            this.myShutdownCallback.run();
            this.myShutdownCallback = null;
        }
    }

    public boolean isRestartRequired() {
        return this.myRestartRequired;
    }

    public void setRestartRequired(boolean restartRequired) {
        this.myRestartRequired = restartRequired;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/InstalledPluginsState";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPlugins";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPreInstalledPlugin";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasNewerVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wasInstalled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wasInstalledWithoutRestart";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wasUninstalledWithoutRestart";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wasUpdated";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onDescriptorDownload";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onPluginInstall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onPluginUninstall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

