/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunDashboardActionUtils;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ExecutorAction
extends DumbAwareAction {
    protected ExecutorAction() {
    }

    protected ExecutorAction(String text, String description, Icon icon2) {
        super(text, description, icon2);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            this.update(e, false);
            return;
        }
        JBIterable<RunDashboardRunConfigurationNode> targetNodes = RunDashboardActionUtils.getLeafTargets(e);
        boolean running = targetNodes.filter(node -> {
            Content content2 = node.getContent();
            return content2 != null && !RunContentManagerImpl.isTerminated(content2);
        }).isNotEmpty();
        this.update(e, running);
        e.getPresentation().setEnabled(targetNodes.filter(this::canRun).isNotEmpty());
    }

    private boolean canRun(@NotNull RunDashboardRunConfigurationNode node) {
        if (node == null) {
            ExecutorAction.$$$reportNull$$$0(1);
        }
        Project project = node.getProject();
        return this.canRun(node.getConfigurationSettings(), ExecutionTargetManager.getActiveTarget((Project)project), DumbService.isDumb((Project)project));
    }

    private boolean canRun(RunnerAndConfigurationSettings settings, ExecutionTarget target2, boolean isDumb) {
        if (isDumb && !settings.getType().isDumbAware()) {
            return false;
        }
        String executorId = this.getExecutor().getId();
        RunConfiguration configuration = settings.getConfiguration();
        Project project = configuration.getProject();
        if (configuration instanceof CompoundRunConfiguration) {
            if (ExecutionTargetManager.getInstance((Project)project).getTargetsFor(configuration).isEmpty()) {
                return false;
            }
            List<SettingsAndEffectiveTarget> subConfigurations = ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets();
            if (subConfigurations.isEmpty()) {
                return false;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            for (SettingsAndEffectiveTarget subConfiguration : subConfigurations) {
                RunnerAndConfigurationSettings subSettings = runManager.findSettings(subConfiguration.getConfiguration());
                if (subSettings != null && this.canRun(subSettings, subConfiguration.getTarget(), isDumb)) continue;
                return false;
            }
            return true;
        }
        if (!ExecutorAction.isValid(settings)) {
            return false;
        }
        ProgramRunner runner = ProgramRunner.getRunner((String)executorId, (RunProfile)configuration);
        return runner != null && ExecutionTargetManager.canRun((RunConfiguration)configuration, (ExecutionTarget)target2) && !ExecutionManager.getInstance((Project)project).isStarting(executorId, runner.getRunnerId());
    }

    private static boolean isValid(RunnerAndConfigurationSettings settings) {
        try {
            settings.checkSettings(null);
            return true;
        }
        catch (IndexNotReadyException ex) {
            return true;
        }
        catch (RuntimeConfigurationError ex) {
            return false;
        }
        catch (RuntimeConfigurationException ex) {
            return true;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        for (RunDashboardRunConfigurationNode node : RunDashboardActionUtils.getLeafTargets(e)) {
            this.doActionPerformed(node);
        }
    }

    private void doActionPerformed(RunDashboardRunConfigurationNode node) {
        if (!this.canRun(node)) {
            return;
        }
        this.run(node.getConfigurationSettings(), ExecutionTargetManager.getActiveTarget((Project)node.getProject()), node.getDescriptor());
    }

    private void run(RunnerAndConfigurationSettings settings, ExecutionTarget target2, RunContentDescriptor descriptor2) {
        RunConfiguration configuration = settings.getConfiguration();
        Project project = configuration.getProject();
        if (configuration instanceof CompoundRunConfiguration) {
            RunManager runManager = RunManager.getInstance((Project)project);
            List<SettingsAndEffectiveTarget> subConfigurations = ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets();
            for (SettingsAndEffectiveTarget subConfiguration : subConfigurations) {
                RunnerAndConfigurationSettings subSettings = runManager.findSettings(subConfiguration.getConfiguration());
                if (subSettings == null) continue;
                this.run(subSettings, subConfiguration.getTarget(), null);
            }
        } else {
            ProcessHandler processHandler2 = descriptor2 == null ? null : descriptor2.getProcessHandler();
            ExecutionManager.getInstance((Project)project).restartRunProfile(project, this.getExecutor(), target2, settings, processHandler2);
        }
    }

    protected abstract Executor getExecutor();

    protected abstract void update(@NotNull AnActionEvent var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/dashboard/actions/ExecutorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

