/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDiffTool
implements FrameDiffTool {
    public static final ErrorDiffTool INSTANCE = new ErrorDiffTool();
    private static final Logger LOG = Logger.getInstance(ErrorDiffTool.class);

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        if (context == null) {
            ErrorDiffTool.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            ErrorDiffTool.$$$reportNull$$$0(1);
        }
        return new MyViewer(context, request2);
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        if (context == null) {
            ErrorDiffTool.$$$reportNull$$$0(2);
        }
        if (request2 == null) {
            ErrorDiffTool.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    public String getName() {
        String string = DiffBundle.message((String)"error.viewer", (Object[])new Object[0]);
        if (string == null) {
            ErrorDiffTool.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static JComponent createReloadMessagePanel(@Nullable DiffContext context, @NotNull String message, @NotNull String reloadMessage, @Nullable Runnable beforeReload) {
        if (message == null) {
            ErrorDiffTool.$$$reportNull$$$0(5);
        }
        if (reloadMessage == null) {
            ErrorDiffTool.$$$reportNull$$$0(6);
        }
        if (context instanceof DiffContextEx) {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color linkColor = (Color)ObjectUtils.chooseNotNull((Object)scheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor(), (Object)JBUI.CurrentTheme.Link.linkColor());
            SimpleColoredComponent textLabel = new SimpleColoredComponent();
            textLabel.setTextAlign(0);
            textLabel.setOpaque(false);
            textLabel.append(message);
            SimpleColoredComponent reloadLabel = new SimpleColoredComponent();
            reloadLabel.setTextAlign(0);
            reloadLabel.setOpaque(false);
            reloadLabel.append(reloadMessage, new SimpleTextAttributes(0, linkColor), () -> {
                if (beforeReload != null) {
                    beforeReload.run();
                }
                ((DiffContextEx)context).reloadDiffRequest();
            });
            LinkMouseListenerBase.installSingleTagOn(reloadLabel);
            JPanel jPanel2 = DiffUtil.createMessagePanel((JComponent)JBUI.Panels.simplePanel((Component)textLabel).addToBottom((Component)reloadLabel).andTransparent());
            if (jPanel2 == null) {
                ErrorDiffTool.$$$reportNull$$$0(7);
            }
            return jPanel2;
        }
        JPanel jPanel3 = DiffUtil.createMessagePanel(message);
        if (jPanel3 == null) {
            ErrorDiffTool.$$$reportNull$$$0(8);
        }
        return jPanel3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/ErrorDiffTool";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/ErrorDiffTool";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createReloadMessagePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canShow";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createReloadMessagePanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyViewer
    implements FrameDiffTool.DiffViewer {
        @NotNull
        private final DiffContext myContext;
        @NotNull
        private final DiffRequest myRequest;
        @NotNull
        private final JComponent myPanel;

        MyViewer(@NotNull DiffContext context, @NotNull DiffRequest request2) {
            if (context == null) {
                MyViewer.$$$reportNull$$$0(0);
            }
            if (request2 == null) {
                MyViewer.$$$reportNull$$$0(1);
            }
            this.myContext = context;
            this.myRequest = request2;
            JComponent component2 = this.createComponent(request2);
            this.myPanel = ScrollPaneFactory.createScrollPane((Component)component2, (boolean)true);
        }

        @NotNull
        private JComponent createComponent(@NotNull DiffRequest request2) {
            if (request2 == null) {
                MyViewer.$$$reportNull$$$0(2);
            }
            if (request2 instanceof ErrorDiffRequest) {
                String message = ((ErrorDiffRequest)request2).getMessage();
                JComponent jComponent = ErrorDiffTool.createReloadMessagePanel(this.myContext, message, DiffBundle.message((String)"button.reload.diff.request", (Object[])new Object[0]), null);
                if (jComponent == null) {
                    MyViewer.$$$reportNull$$$0(3);
                }
                return jComponent;
            }
            if (request2 instanceof MessageDiffRequest) {
                String message = ((MessageDiffRequest)request2).getMessage();
                JPanel jPanel2 = DiffUtil.createMessagePanel(message);
                if (jPanel2 == null) {
                    MyViewer.$$$reportNull$$$0(4);
                }
                return jPanel2;
            }
            if (request2 instanceof ComponentDiffRequest) {
                JComponent jComponent = ((ComponentDiffRequest)request2).getComponent(this.myContext);
                if (jComponent == null) {
                    MyViewer.$$$reportNull$$$0(5);
                }
                return jComponent;
            }
            if (request2 instanceof ContentDiffRequest) {
                List contents = ((ContentDiffRequest)request2).getContents();
                for (DiffContent content2 : contents) {
                    if (!(content2 instanceof FileContent) || !FileTypes.UNKNOWN.equals(content2.getContentType())) continue;
                    VirtualFile file2 = ((FileContent)content2).getFile();
                    JComponent jComponent = UnknownFileTypeDiffRequest.createComponent(file2.getName(), this.myContext);
                    if (jComponent == null) {
                        MyViewer.$$$reportNull$$$0(6);
                    }
                    return jComponent;
                }
                if (ContainerUtil.all((Collection)contents, it -> it instanceof EmptyContent)) {
                    JPanel jPanel3 = DiffUtil.createMessagePanel(NoDiffRequest.INSTANCE.getMessage());
                    if (jPanel3 == null) {
                        MyViewer.$$$reportNull$$$0(7);
                    }
                    return jPanel3;
                }
            }
            LOG.info("Can't show diff for " + request2.getClass().getName());
            if (request2 instanceof ContentDiffRequest) {
                for (DiffContent content3 : ((ContentDiffRequest)request2).getContents()) {
                    String type = content3.getContentType() != null ? content3.getContentType().getName() : "null";
                    LOG.info(String.format("      %s, content type: %s", content3.getClass().getName(), type));
                }
            }
            JPanel jPanel4 = DiffUtil.createMessagePanel(DiffBundle.message((String)"error.message.cannot.show.diff", (Object[])new Object[0]));
            if (jPanel4 == null) {
                MyViewer.$$$reportNull$$$0(8);
            }
            return jPanel4;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myPanel;
            if (jComponent == null) {
                MyViewer.$$$reportNull$$$0(9);
            }
            return jComponent;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            String fileName;
            if (this.myRequest instanceof UnknownFileTypeDiffRequest && (fileName = ((UnknownFileTypeDiffRequest)this.myRequest).getFileName()) != null && FileTypeManager.getInstance().getFileTypeByFileName(fileName) != UnknownFileType.INSTANCE && this.myContext instanceof DiffContextEx) {
                ApplicationManager.getApplication().invokeLater(() -> ((DiffContextEx)this.myContext).reloadDiffRequest(), ModalityState.current());
            }
            FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
            components.needTopToolbarBorder = true;
            FrameDiffTool.ToolbarComponents toolbarComponents = components;
            if (toolbarComponents == null) {
                MyViewer.$$$reportNull$$$0(10);
            }
            return toolbarComponents;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/ErrorDiffTool$MyViewer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/ErrorDiffTool$MyViewer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "init";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

