/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.IntStack;
import com.intellij.util.graph.Graph;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance((String)ControlFlowUtil.class.getName());

    private ControlFlowUtil() {
    }

    @NotNull
    public static Graph<Instruction> createGraph(final Instruction @NotNull [] flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(0);
        }
        return new Graph<Instruction>(){
            @NotNull
            private final List<Instruction> myList;
            {
                this.myList = Arrays.asList(flow);
            }

            @NotNull
            public Collection<Instruction> getNodes() {
                List<Instruction> list2 = this.myList;
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @NotNull
            public Iterator<Instruction> getIn(Instruction n) {
                Iterator<Instruction> iterator2 = n.allPred().iterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            @NotNull
            public Iterator<Instruction> getOut(Instruction n) {
                Iterator<Instruction> iterator2 = n.allSucc().iterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInsight/controlflow/ControlFlowUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static int findInstructionNumberByElement(Instruction[] flow, PsiElement element2) {
        for (int i2 = 0; i2 < flow.length; ++i2) {
            ProgressManager.checkCanceled();
            if (element2 != flow[i2].getElement()) continue;
            return i2;
        }
        return -1;
    }

    public static boolean process(Instruction[] flow, int start2, Processor<? super Instruction> processor2) {
        int length = flow.length;
        boolean[] visited = new boolean[length];
        Arrays.fill(visited, false);
        IntStack stack = new IntStack(length);
        stack.push(start2);
        while (!stack.empty()) {
            ProgressManager.checkCanceled();
            int num = stack.pop();
            Instruction instruction = flow[num];
            if (!processor2.process((Object)instruction)) {
                return false;
            }
            for (Instruction succ : instruction.allSucc()) {
                int succNum = succ.num();
                if (visited[succNum]) continue;
                visited[succNum] = true;
                stack.push(succNum);
            }
        }
        return true;
    }

    public static void iteratePrev(int startInstruction, Instruction @NotNull [] instructions, @NotNull Function<? super Instruction, Operation> closure) {
        if (closure == null) {
            ControlFlowUtil.$$$reportNull$$$0(1);
        }
        if (instructions == null) {
            ControlFlowUtil.$$$reportNull$$$0(2);
        }
        ControlFlowUtil.iterate(startInstruction, instructions, closure, true);
    }

    public static void iterate(int startInstruction, Instruction @NotNull [] instructions, @NotNull Function<? super Instruction, Operation> closure, boolean prev) {
        if (closure == null) {
            ControlFlowUtil.$$$reportNull$$$0(3);
        }
        if (instructions == null) {
            ControlFlowUtil.$$$reportNull$$$0(4);
        }
        IntStack stack = new IntStack(instructions.length);
        boolean[] visited = new boolean[instructions.length];
        stack.push(startInstruction);
        while (!stack.empty()) {
            ProgressManager.checkCanceled();
            int num = stack.pop();
            Instruction instr = instructions[num];
            Operation nextOperation = (Operation)((Object)closure.fun((Object)instr));
            if (nextOperation == Operation.CONTINUE) continue;
            if (nextOperation == Operation.BREAK) break;
            assert (nextOperation == Operation.NEXT);
            Collection nextToProcess = prev ? instr.allPred() : instr.allSucc();
            for (Instruction pred : nextToProcess) {
                int predNum = pred.num();
                if (visited[predNum]) continue;
                visited[predNum] = true;
                stack.push(predNum);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/controlflow/ControlFlowUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createGraph";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "iteratePrev";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "iterate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Operation {
        CONTINUE,
        BREAK,
        NEXT;

    }
}

