/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.PageSizes;
import com.intellij.codeEditor.printing.PrintSettings;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

class PrintDialog
extends DialogWrapper {
    private JRadioButton myRbCurrentFile = null;
    private JRadioButton myRbSelectedText = null;
    private JRadioButton myRbCurrentPackage = null;
    private JCheckBox myCbIncludeSubpackages = null;
    private JComboBox<Object> myPaperSizeCombo = null;
    private JCheckBox myCbColorPrinting = null;
    private JCheckBox myCbSyntaxPrinting = null;
    private JCheckBox myCbPrintAsGraphics = null;
    private JRadioButton myRbPortrait = null;
    private JRadioButton myRbLandscape = null;
    private FontComboBox myFontNameCombo = null;
    private JComboBox<Integer> myFontSizeCombo = null;
    private JCheckBox myCbLineNumbers = null;
    private JRadioButton myRbNoWrap = null;
    private JRadioButton myRbWrapAtWordBreaks = null;
    private JTextField myTopMarginField = null;
    private JTextField myBottomMarginField = null;
    private JTextField myLeftMarginField = null;
    private JTextField myRightMarginField = null;
    private JCheckBox myCbDrawBorder = null;
    private JCheckBox myCbEvenNumberOfPages = null;
    private JTextField myLineTextField1 = null;
    private JComboBox<PrintSettings.Placement> myLinePlacementCombo1 = null;
    private JComboBox<PrintSettings.Alignment> myLineAlignmentCombo1 = null;
    private JTextField myLineTextField2 = null;
    private JComboBox<PrintSettings.Placement> myLinePlacementCombo2 = null;
    private JComboBox<PrintSettings.Alignment> myLineAlignmentCombo2 = null;
    private JComboBox<Integer> myFooterFontSizeCombo = null;
    private FontComboBox myFooterFontNameCombo = null;
    private final String myFileName;
    private final String myDirectoryName;
    private final boolean isSelectedTextEnabled;
    private final int mySelectedFileCount;
    private final String mySelectedText;

    PrintDialog(String fileName, String directoryName, String selectedText, int selectedFileCount, Project project) {
        super(project, true);
        this.mySelectedText = selectedText;
        this.setOKButtonText(EditorBundle.message((String)"print.print.button", (Object[])new Object[0]));
        this.myFileName = fileName;
        this.myDirectoryName = directoryName;
        this.isSelectedTextEnabled = selectedText != null;
        this.mySelectedFileCount = selectedFileCount;
        this.setTitle(EditorBundle.message((String)"print.title", (Object[])new Object[0]));
        this.init();
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 4));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = JBUI.emptyInsets();
        Object @NotNull [] params1 = new Object[]{this.myFileName != null ? this.myFileName : ""};
        this.myRbCurrentFile = new JRadioButton(this.mySelectedFileCount > 1 ? EditorBundle.message((String)"print.files.radio", (Object[])new Object[]{this.mySelectedFileCount}) : EditorBundle.message((String)"print.file.name.radio", (Object[])params1));
        panel2.add((Component)this.myRbCurrentFile, gbConstraints);
        this.myRbSelectedText = new JRadioButton(this.mySelectedText != null ? this.mySelectedText : EditorBundle.message((String)"print.selected.text.radio", (Object[])new Object[0]));
        ++gbConstraints.gridy;
        gbConstraints.insets = JBUI.emptyInsets();
        panel2.add((Component)this.myRbSelectedText, gbConstraints);
        Object[] params = new Object[]{this.myDirectoryName != null ? this.myDirectoryName : ""};
        this.myRbCurrentPackage = new JRadioButton(EditorBundle.message((String)"print.all.files.in.directory.radio", (Object[])params));
        ++gbConstraints.gridy;
        gbConstraints.insets = JBUI.emptyInsets();
        panel2.add((Component)this.myRbCurrentPackage, gbConstraints);
        this.myCbIncludeSubpackages = new JCheckBox(EditorBundle.message((String)"print.include.subdirectories.checkbox", (Object[])new Object[0]));
        ++gbConstraints.gridy;
        gbConstraints.insets = JBUI.insetsLeft((int)20);
        panel2.add((Component)this.myCbIncludeSubpackages, gbConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myRbCurrentFile);
        buttonGroup2.add(this.myRbSelectedText);
        buttonGroup2.add(this.myRbCurrentPackage);
        ActionListener actionListener = e -> this.updateDependentComponents();
        this.myRbCurrentFile.addActionListener(actionListener);
        this.myRbSelectedText.addActionListener(actionListener);
        this.myRbCurrentPackage.addActionListener(actionListener);
        return panel2;
    }

    private void updateDependentComponents() {
        this.myCbIncludeSubpackages.setEnabled(this.myRbCurrentPackage.isSelected());
        this.myCbEvenNumberOfPages.setVisible(this.myRbCurrentFile.isSelected() && this.mySelectedFileCount > 1 || this.myRbCurrentPackage.isSelected());
    }

    protected JComponent createCenterPanel() {
        TabbedPaneWrapper tabbedPaneWrapper = new TabbedPaneWrapper(this.myDisposable);
        tabbedPaneWrapper.addTab(EditorBundle.message((String)"print.settings.tab", (Object[])new Object[0]), this.createPrintSettingsPanel());
        tabbedPaneWrapper.addTab(EditorBundle.message((String)"print.header.footer.tab", (Object[])new Object[0]), this.createHeaderAndFooterPanel());
        tabbedPaneWrapper.addTab(EditorBundle.message((String)"print.advanced.tab", (Object[])new Object[0]), this.createAdvancedPanel());
        return tabbedPaneWrapper.getComponent();
    }

    private JPanel createPrintSettingsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        panel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 4, 4));
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.insets = JBUI.insets((int)0, (int)8, (int)6, (int)4);
        gbConstraints.fill = 1;
        MyLabel paperSizeLabel = new MyLabel(EditorBundle.message((String)"print.settings.paper.size.label", (Object[])new Object[0]));
        panel2.add((Component)paperSizeLabel, gbConstraints);
        this.myPaperSizeCombo = PrintDialog.createPageSizesCombo();
        gbConstraints.gridx = 1;
        gbConstraints.gridwidth = 2;
        panel2.add(this.myPaperSizeCombo, gbConstraints);
        MyLabel fontLabel = new MyLabel(EditorBundle.message((String)"print.settings.font.label", (Object[])new Object[0]));
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        ++gbConstraints.gridy;
        panel2.add((Component)fontLabel, gbConstraints);
        this.myFontNameCombo = new FontComboBox(true);
        gbConstraints.gridx = 1;
        panel2.add((Component)((Object)this.myFontNameCombo), gbConstraints);
        this.myFontSizeCombo = PrintDialog.createFontSizesComboBox();
        gbConstraints.gridx = 2;
        panel2.add(this.myFontSizeCombo, gbConstraints);
        this.myCbLineNumbers = new JCheckBox(EditorBundle.message((String)"print.settings.show.line.numbers.checkbox", (Object[])new Object[0]));
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 3;
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbLineNumbers, gbConstraints);
        this.myCbDrawBorder = new JCheckBox(EditorBundle.message((String)"print.settings.draw.border.checkbox", (Object[])new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbDrawBorder, gbConstraints);
        this.myCbEvenNumberOfPages = new JCheckBox(EditorBundle.message((String)"print.settings.even.number.of.pages", (Object[])new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbEvenNumberOfPages, gbConstraints);
        gbConstraints.insets = JBUI.insets((int)0, (int)0, (int)6, (int)4);
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 3;
        ++gbConstraints.gridy;
        panel2.add((Component)this.createStyleAndLayoutPanel(), gbConstraints);
        ++gbConstraints.gridy;
        gbConstraints.weighty = 1.0;
        panel2.add((Component)new MyTailPanel(), gbConstraints);
        return panel2;
    }

    private JPanel createAdvancedPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        panel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 4, 4));
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = JBUI.insets((int)0, (int)0, (int)6, (int)4);
        panel2.add((Component)this.createWrappingPanel(), gbConstraints);
        ++gbConstraints.gridy;
        panel2.add((Component)this.createMarginsPanel(), gbConstraints);
        ++gbConstraints.gridy;
        gbConstraints.weighty = 1.0;
        panel2.add((Component)new MyTailPanel(), gbConstraints);
        return panel2;
    }

    private JPanel createStyleAndLayoutPanel() {
        JPanel panel2 = new JPanel(new GridLayout(1, 2));
        panel2.add(this.createOrientationPanel());
        panel2.add(this.createStylePanel());
        return panel2;
    }

    private JPanel createOrientationPanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)EditorBundle.message((String)"print.orientation.group", (Object[])new Object[0])));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myRbPortrait = new JRadioButton(EditorBundle.message((String)"print.orientation.portrait.radio", (Object[])new Object[0]));
        panel2.add((Component)this.myRbPortrait, gbConstraints);
        this.myRbLandscape = new JRadioButton(EditorBundle.message((String)"print.orientation.landscape.radio", (Object[])new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myRbLandscape, gbConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myRbPortrait);
        buttonGroup2.add(this.myRbLandscape);
        return panel2;
    }

    private JPanel createStylePanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)EditorBundle.message((String)"print.style.group", (Object[])new Object[0])));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbColorPrinting = new JCheckBox(EditorBundle.message((String)"print.style.color.printing.checkbox", (Object[])new Object[0]));
        panel2.add((Component)this.myCbColorPrinting, gbConstraints);
        this.myCbSyntaxPrinting = new JCheckBox(EditorBundle.message((String)"print.style.syntax.printing.checkbox", (Object[])new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbSyntaxPrinting, gbConstraints);
        this.myCbPrintAsGraphics = new JCheckBox(EditorBundle.message((String)"print.style.print.as.graphics.checkbox", (Object[])new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbPrintAsGraphics, gbConstraints);
        return panel2;
    }

    private JPanel createWrappingPanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)EditorBundle.message((String)"print.wrapping.group", (Object[])new Object[0])));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myRbNoWrap = new JRadioButton(EditorBundle.message((String)"print.wrapping.none.radio", (Object[])new Object[0]));
        panel2.add((Component)this.myRbNoWrap, gbConstraints);
        this.myRbWrapAtWordBreaks = new JRadioButton(EditorBundle.message((String)"print.wrapping.word.breaks.radio", (Object[])new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myRbWrapAtWordBreaks, gbConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myRbNoWrap);
        buttonGroup2.add(this.myRbWrapAtWordBreaks);
        return panel2;
    }

    private JPanel createMarginsPanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)EditorBundle.message((String)"print.margins.group", (Object[])new Object[0])));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        panel2.add((Component)new MyLabel(EditorBundle.message((String)"print.margins.top.label", (Object[])new Object[0])), gbConstraints);
        this.myTopMarginField = new MyTextField(6);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 1;
        panel2.add((Component)this.myTopMarginField, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 2;
        panel2.add((Component)new MyLabel(EditorBundle.message((String)"print.margins.bottom.label", (Object[])new Object[0])), gbConstraints);
        this.myBottomMarginField = new MyTextField(6);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 3;
        panel2.add((Component)this.myBottomMarginField, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        panel2.add((Component)new MyLabel(EditorBundle.message((String)"print.margins.left.label", (Object[])new Object[0])), gbConstraints);
        this.myLeftMarginField = new MyTextField(6);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 1;
        panel2.add((Component)this.myLeftMarginField, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 2;
        panel2.add((Component)new MyLabel(EditorBundle.message((String)"print.margins.right.label", (Object[])new Object[0])), gbConstraints);
        this.myRightMarginField = new MyTextField(6);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 3;
        panel2.add((Component)this.myRightMarginField, gbConstraints);
        return panel2;
    }

    private JPanel createHeaderAndFooterPanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 4, 4));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = JBUI.insets((int)0, (int)0, (int)6, (int)4);
        gbConstraints.gridwidth = 3;
        this.myLineTextField1 = new MyTextField(30);
        this.myLinePlacementCombo1 = new ComboBox();
        this.myLineAlignmentCombo1 = new ComboBox();
        JPanel linePanel1 = PrintDialog.createLinePanel(EditorBundle.message((String)"print.header.line.1.label", (Object[])new Object[0]), this.myLineTextField1, this.myLinePlacementCombo1, this.myLineAlignmentCombo1);
        panel2.add((Component)linePanel1, gbConstraints);
        this.myLineTextField2 = new MyTextField(30);
        this.myLinePlacementCombo2 = new ComboBox();
        this.myLineAlignmentCombo2 = new ComboBox();
        JPanel linePanel2 = PrintDialog.createLinePanel(EditorBundle.message((String)"print.header.line.2.label", (Object[])new Object[0]), this.myLineTextField2, this.myLinePlacementCombo2, this.myLineAlignmentCombo2);
        ++gbConstraints.gridy;
        panel2.add((Component)linePanel2, gbConstraints);
        gbConstraints.insets = JBUI.insets((int)0, (int)8, (int)6, (int)4);
        ++gbConstraints.gridy;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        panel2.add((Component)new MyLabel(EditorBundle.message((String)"print.header.font.label", (Object[])new Object[0])), gbConstraints);
        this.myFooterFontNameCombo = new FontComboBox(true);
        gbConstraints.gridx = 1;
        panel2.add((Component)((Object)this.myFooterFontNameCombo), gbConstraints);
        this.myFooterFontSizeCombo = PrintDialog.createFontSizesComboBox();
        gbConstraints.gridx = 2;
        panel2.add(this.myFooterFontSizeCombo, gbConstraints);
        return panel2;
    }

    private static JPanel createLinePanel(String name, JTextField lineTextField, JComboBox<PrintSettings.Placement> linePlacementCombo, JComboBox<PrintSettings.Alignment> lineAlignmentCombo) {
        JPanel panel2 = new JPanel();
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)name));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = JBUI.insetsBottom((int)6);
        panel2.add((Component)new MyLabel(EditorBundle.message((String)"print.header.text.line.editbox", (Object[])new Object[0])), gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.gridwidth = 4;
        gbConstraints.weightx = 1.0;
        panel2.add((Component)lineTextField, gbConstraints);
        gbConstraints.gridwidth = 1;
        ++gbConstraints.gridy;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 0.0;
        panel2.add((Component)new MyLabel(EditorBundle.message((String)"print.header.placement.combobox", (Object[])new Object[0])), gbConstraints);
        linePlacementCombo.addItem(PrintSettings.Placement.Header);
        linePlacementCombo.addItem(PrintSettings.Placement.Footer);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 0.0;
        panel2.add(linePlacementCombo, gbConstraints);
        gbConstraints.gridx = 2;
        gbConstraints.weightx = 1.0;
        panel2.add((Component)new MyTailPanel(), gbConstraints);
        gbConstraints.gridx = 3;
        gbConstraints.weightx = 0.0;
        panel2.add((Component)new MyLabel(EditorBundle.message((String)"print.header.alignment.combobox", (Object[])new Object[0])), gbConstraints);
        lineAlignmentCombo.addItem(PrintSettings.Alignment.Left);
        lineAlignmentCombo.addItem(PrintSettings.Alignment.Center);
        lineAlignmentCombo.addItem(PrintSettings.Alignment.Right);
        gbConstraints.gridx = 4;
        gbConstraints.weightx = 0.0;
        panel2.add(lineAlignmentCombo, gbConstraints);
        return panel2;
    }

    private static JComboBox<Integer> createFontSizesComboBox() {
        ComboBox comboBox2 = new ComboBox();
        for (int i2 = 6; i2 < 40; ++i2) {
            comboBox2.addItem(i2);
        }
        return comboBox2;
    }

    private static JComboBox<Object> createPageSizesCombo() {
        ComboBox pageSizesCombo = new ComboBox();
        for (String name : PageSizes.getNames()) {
            pageSizesCombo.addItem(PageSizes.getItem(name));
        }
        return pageSizesCombo;
    }

    public void reset() {
        PrintSettings printSettings = PrintSettings.getInstance();
        this.myRbSelectedText.setEnabled(this.isSelectedTextEnabled);
        this.myRbSelectedText.setSelected(this.isSelectedTextEnabled);
        this.myRbCurrentFile.setEnabled(this.myFileName != null || this.mySelectedFileCount > 1);
        this.myRbCurrentFile.setSelected(this.myFileName != null && !this.isSelectedTextEnabled || this.mySelectedFileCount > 1);
        this.myRbCurrentPackage.setEnabled(this.myDirectoryName != null);
        this.myRbCurrentPackage.setSelected(this.myDirectoryName != null && !this.isSelectedTextEnabled && this.myFileName == null);
        this.myCbIncludeSubpackages.setSelected(printSettings.isIncludeSubdirectories());
        this.updateDependentComponents();
        Object selectedPageSize = PageSizes.getItem(printSettings.PAPER_SIZE);
        if (selectedPageSize != null) {
            this.myPaperSizeCombo.setSelectedItem(selectedPageSize);
        }
        this.myCbColorPrinting.setSelected(printSettings.COLOR_PRINTING);
        this.myCbSyntaxPrinting.setSelected(printSettings.SYNTAX_PRINTING);
        this.myCbPrintAsGraphics.setSelected(printSettings.PRINT_AS_GRAPHICS);
        if (printSettings.PORTRAIT_LAYOUT) {
            this.myRbPortrait.setSelected(true);
        } else {
            this.myRbLandscape.setSelected(true);
        }
        this.myFontNameCombo.setFontName(printSettings.FONT_NAME);
        this.myFontSizeCombo.setSelectedItem(printSettings.FONT_SIZE);
        this.myCbLineNumbers.setSelected(printSettings.PRINT_LINE_NUMBERS);
        if (printSettings.WRAP) {
            this.myRbWrapAtWordBreaks.setSelected(true);
        } else {
            this.myRbNoWrap.setSelected(true);
        }
        this.myTopMarginField.setText(String.valueOf(printSettings.TOP_MARGIN));
        this.myBottomMarginField.setText(String.valueOf(printSettings.BOTTOM_MARGIN));
        this.myLeftMarginField.setText(String.valueOf(printSettings.LEFT_MARGIN));
        this.myRightMarginField.setText(String.valueOf(printSettings.RIGHT_MARGIN));
        this.myCbDrawBorder.setSelected(printSettings.DRAW_BORDER);
        this.myCbEvenNumberOfPages.setSelected(printSettings.EVEN_NUMBER_OF_PAGES);
        this.myLineTextField1.setText(printSettings.FOOTER_HEADER_TEXT1);
        this.myLinePlacementCombo1.setSelectedItem((Object)printSettings.FOOTER_HEADER_PLACEMENT1);
        this.myLineAlignmentCombo1.setSelectedItem((Object)printSettings.FOOTER_HEADER_ALIGNMENT1);
        this.myLineTextField2.setText(printSettings.FOOTER_HEADER_TEXT2);
        this.myLinePlacementCombo2.setSelectedItem((Object)printSettings.FOOTER_HEADER_PLACEMENT2);
        this.myLineAlignmentCombo2.setSelectedItem((Object)printSettings.FOOTER_HEADER_ALIGNMENT2);
        this.myFooterFontSizeCombo.setSelectedItem(printSettings.FOOTER_HEADER_FONT_SIZE);
        this.myFooterFontNameCombo.setFontName(printSettings.FOOTER_HEADER_FONT_NAME);
    }

    public void apply() {
        PrintSettings printSettings = PrintSettings.getInstance();
        if (this.myRbCurrentFile.isSelected()) {
            printSettings.setPrintScope(1);
        } else if (this.myRbSelectedText.isSelected()) {
            printSettings.setPrintScope(2);
        } else if (this.myRbCurrentPackage.isSelected()) {
            printSettings.setPrintScope(4);
        }
        printSettings.setIncludeSubdirectories(this.myCbIncludeSubpackages.isSelected());
        printSettings.PAPER_SIZE = PageSizes.getName(this.myPaperSizeCombo.getSelectedItem());
        printSettings.COLOR_PRINTING = this.myCbColorPrinting.isSelected();
        printSettings.SYNTAX_PRINTING = this.myCbSyntaxPrinting.isSelected();
        printSettings.PRINT_AS_GRAPHICS = this.myCbPrintAsGraphics.isSelected();
        printSettings.PORTRAIT_LAYOUT = this.myRbPortrait.isSelected();
        printSettings.FONT_NAME = this.myFontNameCombo.getFontName();
        printSettings.FONT_SIZE = (Integer)ObjectUtils.notNull((Object)((Integer)this.myFontSizeCombo.getSelectedItem()), (Object)printSettings.FONT_SIZE);
        printSettings.PRINT_LINE_NUMBERS = this.myCbLineNumbers.isSelected();
        printSettings.WRAP = this.myRbWrapAtWordBreaks.isSelected();
        try {
            printSettings.TOP_MARGIN = Float.parseFloat(this.myTopMarginField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            printSettings.BOTTOM_MARGIN = Float.parseFloat(this.myBottomMarginField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            printSettings.LEFT_MARGIN = Float.parseFloat(this.myLeftMarginField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            printSettings.RIGHT_MARGIN = Float.parseFloat(this.myRightMarginField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        printSettings.DRAW_BORDER = this.myCbDrawBorder.isSelected();
        printSettings.EVEN_NUMBER_OF_PAGES = this.myCbEvenNumberOfPages.isSelected();
        printSettings.FOOTER_HEADER_TEXT1 = this.myLineTextField1.getText();
        printSettings.FOOTER_HEADER_ALIGNMENT1 = (PrintSettings.Alignment)((Object)this.myLineAlignmentCombo1.getSelectedItem());
        printSettings.FOOTER_HEADER_PLACEMENT1 = (PrintSettings.Placement)((Object)this.myLinePlacementCombo1.getSelectedItem());
        printSettings.FOOTER_HEADER_TEXT2 = this.myLineTextField2.getText();
        printSettings.FOOTER_HEADER_ALIGNMENT2 = (PrintSettings.Alignment)((Object)this.myLineAlignmentCombo2.getSelectedItem());
        printSettings.FOOTER_HEADER_PLACEMENT2 = (PrintSettings.Placement)((Object)this.myLinePlacementCombo2.getSelectedItem());
        printSettings.FOOTER_HEADER_FONT_NAME = this.myFooterFontNameCombo.getFontName();
        printSettings.FOOTER_HEADER_FONT_SIZE = (Integer)ObjectUtils.notNull((Object)((Integer)this.myFooterFontSizeCombo.getSelectedItem()), (Object)printSettings.FOOTER_HEADER_FONT_SIZE);
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), new ApplyAction(), this.getHelpAction()};
        if (actionArray == null) {
            PrintDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected String getHelpId() {
        return "reference.file.print";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeEditor/printing/PrintDialog", "createActions"));
    }

    private static class MyLabel
    extends JLabel {
        MyLabel(String text) {
            super(text);
        }

        @Override
        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }
    }

    private static class MyTextField
    extends JTextField {
        MyTextField(int size) {
            super(size);
        }

        @Override
        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        ApplyAction() {
            this.putValue("Name", EditorBundle.message((String)"print.apply.button", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrintDialog.this.apply();
        }
    }

    private static class MyTailPanel
    extends JPanel {
        MyTailPanel() {
            this.setFocusable(false);
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.emptySize();
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.emptySize();
        }
    }
}

