/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.HighlightingFileRoot;
import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel$WhenMappings;
import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel$sam$java_lang_Runnable$0;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemNode;
import com.intellij.analysis.problemsView.toolWindow.ProblemsTreeModel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.analysis.problemsView.toolWindow.Status;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.TreeExpander;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\r\u0010\u001a\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001bH\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\b\u0010$\u001a\u00020\u000eH\u0016J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0014J\u001a\u0010.\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010/\u001a\u00020-H\u0002J\u001a\u00100\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010/\u001a\u00020-H\u0002J\b\u00101\u001a\u00020\u000eH\u0002J\b\u00102\u001a\u00020\u000eH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingPanel;", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/ide/PowerSaveMode$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewState;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewState;)V", "previousStatus", "Lcom/intellij/analysis/problemsView/toolWindow/Status;", "statusUpdateAlarm", "Lcom/intellij/util/SingleAlarm;", "fileClosed", "", "manager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpened", "findCurrentFile", "getCurrentStatus", "getData", "", "dataId", "", "getDisplayName", "Lorg/jetbrains/annotations/NotNull;", "getSortFoldersFirst", "Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "getToolWindowIcon", "Ljavax/swing/Icon;", "count", "", "getTreeExpander", "Lcom/intellij/ide/TreeExpander;", "powerSaveStateChanged", "selectHighlighter", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "selectionChangedTo", "selected", "", "statusAnalyzing", "filtered", "statusComplete", "updateCurrentFile", "updateStatus", "intellij.platform.lang.impl"})
public final class HighlightingPanel
extends ProblemsViewPanel
implements FileEditorManagerListener,
PowerSaveMode.Listener {
    private final SingleAlarm statusUpdateAlarm;
    private Status previousStatus;

    @Override
    @NotNull
    protected String getDisplayName() {
        String string = ProblemsViewBundle.message("problems.view.highlighting", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ProblemsViewBundle.messa\u2026blems.view.highlighting\")");
        return string;
    }

    @Override
    @Nullable
    protected ToggleOptionAction.Option getSortFoldersFirst() {
        return null;
    }

    @Override
    @Nullable
    protected TreeExpander getTreeExpander() {
        return null;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        ProblemsTreeModel problemsTreeModel = this.getTreeModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)problemsTreeModel, (String)"treeModel");
        Root root = problemsTreeModel.getRoot();
        if (!(root instanceof HighlightingFileRoot)) {
            root = null;
        }
        HighlightingFileRoot root2 = (HighlightingFileRoot)root;
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            HighlightingFileRoot highlightingFileRoot = root2;
            return highlightingFileRoot != null ? highlightingFileRoot.getFile() : null;
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected Icon getToolWindowIcon(int count) {
        boolean bl;
        block7: {
            if (Experiments.getInstance().isFeatureEnabled("problems.view.project.errors.enabled")) {
                return null;
            }
            ProblemsTreeModel problemsTreeModel = this.getTreeModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)problemsTreeModel, (String)"treeModel");
            Root root = problemsTreeModel.getRoot();
            if (!(root instanceof HighlightingFileRoot)) {
                root = null;
            }
            HighlightingFileRoot highlightingFileRoot = (HighlightingFileRoot)root;
            if (highlightingFileRoot == null) {
                return AllIcons.Toolwindows.ToolWindowProblemsEmpty;
            }
            HighlightingFileRoot root2 = highlightingFileRoot;
            Iterable $this$any$iv = root2.getChildren(root2.getFile());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Integer severity;
                    Node it = (Node)((Object)element$iv);
                    boolean bl2 = false;
                    Node node = it;
                    if (!(node instanceof ProblemNode)) {
                        node = null;
                    }
                    ProblemNode problemNode = (ProblemNode)node;
                    Integer n = severity = problemNode != null ? Integer.valueOf(problemNode.getSeverity()) : null;
                    boolean bl3 = severity != null && severity >= HighlightSeverity.ERROR.myVal;
                    if (!bl3) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean problem = bl;
        return problem ? AllIcons.Toolwindows.ToolWindowProblems : AllIcons.Toolwindows.ToolWindowProblemsEmpty;
    }

    @Override
    protected void selectionChangedTo(boolean selected2) {
        super.selectionChangedTo(selected2);
        if (selected2) {
            this.updateCurrentFile();
        }
    }

    public final void selectHighlighter(@NotNull RangeHighlighterEx highlighter) {
        block1: {
            HighlightingFileRoot root;
            Node node;
            Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
            ProblemsTreeModel problemsTreeModel = this.getTreeModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)problemsTreeModel, (String)"treeModel");
            Root root2 = problemsTreeModel.getRoot();
            if (!(root2 instanceof HighlightingFileRoot)) {
                root2 = null;
            }
            if ((node = (root = (HighlightingFileRoot)root2)) == null || (node = node.findProblemNode(highlighter)) == null) break block1;
            Node node2 = node;
            boolean bl = false;
            boolean bl2 = false;
            Node it = node2;
            boolean bl3 = false;
            this.select(it);
        }
    }

    public void powerSaveStateChanged() {
        this.statusUpdateAlarm.cancelAndRequest(true);
        this.updateToolWindowContent();
    }

    public void fileOpened(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.updateCurrentFile();
    }

    public void fileClosed(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.updateCurrentFile();
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateCurrentFile();
    }

    private final void updateCurrentFile() {
        VirtualFile file2 = this.findCurrentFile();
        ProblemsTreeModel problemsTreeModel = this.getTreeModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)problemsTreeModel, (String)"treeModel");
        Root root = problemsTreeModel.getRoot();
        if (!(root instanceof HighlightingFileRoot)) {
            root = null;
        }
        HighlightingFileRoot root2 = (HighlightingFileRoot)root;
        if (file2 == null) {
            if (root2 == null) {
                return;
            }
            ProblemsTreeModel problemsTreeModel2 = this.getTreeModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)problemsTreeModel2, (String)"treeModel");
            problemsTreeModel2.setRoot(null);
        } else {
            if (root2 != null && Intrinsics.areEqual((Object)root2.getFile(), (Object)file2)) {
                return;
            }
            ProblemsTreeModel problemsTreeModel3 = this.getTreeModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)problemsTreeModel3, (String)"treeModel");
            problemsTreeModel3.setRoot(new HighlightingFileRoot((ProblemsViewPanel)this, file2));
            Intrinsics.checkExpressionValueIsNotNull((Object)TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)this.getTree())), (String)"promiseSelectFirstLeaf(tree)");
        }
        this.powerSaveStateChanged();
    }

    private final VirtualFile findCurrentFile() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        if (project.isDisposed()) {
            return null;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
        if (fileEditorManager == null || (fileEditorManager = fileEditorManager.getSelectedEditor()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getIns\u2026ctedEditor ?: return null");
        FileEditorManager fileEditor = fileEditorManager;
        VirtualFile file2 = fileEditor.getFile();
        if (file2 != null) {
            return file2;
        }
        FileEditorManager fileEditorManager2 = fileEditor;
        if (!(fileEditorManager2 instanceof TextEditor)) {
            fileEditorManager2 = null;
        }
        TextEditor textEditor = (TextEditor)fileEditorManager2;
        if (textEditor == null) {
            return null;
        }
        TextEditor textEditor2 = textEditor;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Editor editor = textEditor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"textEditor.editor");
        return fileDocumentManager.getFile(editor.getDocument());
    }

    private final void updateStatus() {
        Status status = this.getCurrentStatus();
        if (Intrinsics.areEqual((Object)this.previousStatus, (Object)status) ^ true) {
            this.previousStatus = status;
            Tree tree = this.getTree();
            Intrinsics.checkExpressionValueIsNotNull((Object)tree, (String)"tree");
            StatusText statusText = tree.getEmptyText();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"tree.emptyText");
            statusText.setText(status.getTitle());
            CharSequence charSequence = status.getDetails();
            boolean bl = false;
            if (charSequence.length() > 0) {
                Tree tree2 = this.getTree();
                Intrinsics.checkExpressionValueIsNotNull((Object)tree2, (String)"tree");
                tree2.getEmptyText().appendLine(status.getDetails());
            }
        }
        if (status.getRequest()) {
            SingleAlarm.cancelAndRequest$default(this.statusUpdateAlarm, false, 1, null);
        }
    }

    private final Status getCurrentStatus() {
        Status status;
        HighlightingFileRoot root;
        HighlightingFileRoot highlightingFileRoot;
        ProblemsTreeModel problemsTreeModel = this.getTreeModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)problemsTreeModel, (String)"treeModel");
        Root root2 = problemsTreeModel.getRoot();
        if (!(root2 instanceof HighlightingFileRoot)) {
            root2 = null;
        }
        if ((highlightingFileRoot = (root = (HighlightingFileRoot)root2)) == null || (highlightingFileRoot = highlightingFileRoot.getFile()) == null) {
            String string = ProblemsViewBundle.message("problems.view.highlighting.no.selected.file", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ProblemsViewBundle.messa\u2026ghting.no.selected.file\")");
            return new Status(string, null, false, 6, null);
        }
        HighlightingFileRoot file2 = highlightingFileRoot;
        if (PowerSaveMode.isEnabled()) {
            String string = ProblemsViewBundle.message("problems.view.highlighting.power.save.mode", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ProblemsViewBundle.messa\u2026ighting.power.save.mode\")");
            return new Status(string, null, false, 6, null);
        }
        Document document = ProblemsView.getDocument(this.getProject(), (VirtualFile)file2);
        if (document == null) {
            return HighlightingPanel.statusAnalyzing$default(this, (VirtualFile)file2, false, 2, null);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"ProblemsView.getDocument\u2026urn statusAnalyzing(file)");
        Document document2 = document;
        Editor editor = EditorFactory.getInstance().editors(document2, this.getProject()).findFirst().orElse(null);
        if (editor == null) {
            return HighlightingPanel.statusAnalyzing$default(this, (VirtualFile)file2, false, 2, null);
        }
        Editor editor2 = editor;
        MarkupModel markupModel = editor2.getMarkupModel();
        if (!(markupModel instanceof EditorMarkupModel)) {
            markupModel = null;
        }
        EditorMarkupModel editorMarkupModel = (EditorMarkupModel)markupModel;
        if (editorMarkupModel == null) {
            return HighlightingPanel.statusAnalyzing$default(this, (VirtualFile)file2, false, 2, null);
        }
        EditorMarkupModel model = editorMarkupModel;
        ErrorStripeRenderer errorStripeRenderer = model.getErrorStripeRenderer();
        if (errorStripeRenderer == null || (errorStripeRenderer = errorStripeRenderer.getStatus(editor2)) == null) {
            return HighlightingPanel.statusComplete$default(this, (VirtualFile)file2, false, 2, null);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)errorStripeRenderer, (String)"model.errorStripeRendere\u2026turn statusComplete(file)");
        ErrorStripeRenderer status2 = errorStripeRenderer;
        switch (HighlightingPanel$WhenMappings.$EnumSwitchMapping$0[status2.getAnalyzingType().ordinal()]) {
            case 1: {
                status = new Status(status2.getTitle(), status2.getDetails(), true);
                break;
            }
            case 2: {
                Collection collection = this.getState().getHideBySeverity();
                HighlightingFileRoot highlightingFileRoot2 = file2;
                HighlightingPanel highlightingPanel = this;
                boolean bl = false;
                boolean bl2 = !collection.isEmpty();
                status = highlightingPanel.statusComplete((VirtualFile)highlightingFileRoot2, bl2);
                break;
            }
            case 3: {
                Collection collection = this.getState().getHideBySeverity();
                HighlightingFileRoot highlightingFileRoot3 = file2;
                HighlightingPanel highlightingPanel = this;
                boolean bl = false;
                boolean bl3 = !collection.isEmpty();
                status = highlightingPanel.statusAnalyzing((VirtualFile)highlightingFileRoot3, bl3);
                break;
            }
            default: {
                status = HighlightingPanel.statusAnalyzing$default(this, (VirtualFile)file2, false, 2, null);
            }
        }
        return status;
    }

    private final Status statusAnalyzing(VirtualFile file2, boolean filtered2) {
        String string = ProblemsViewBundle.message("problems.view.highlighting.problems.analyzing", file2.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ProblemsViewBundle.messa\u2026ms.analyzing\", file.name)");
        String title = string;
        if (filtered2) {
            String string2 = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found.filter", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ProblemsViewBundle.messa\u2026oblems.not.found.filter\")");
            String details = string2;
            return new Status(title, details, true);
        }
        return new Status(title, null, true, 2, null);
    }

    static /* synthetic */ Status statusAnalyzing$default(HighlightingPanel highlightingPanel, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return highlightingPanel.statusAnalyzing(virtualFile, bl);
    }

    private final Status statusComplete(VirtualFile file2, boolean filtered2) {
        String string = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found", file2.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ProblemsViewBundle.messa\u2026ms.not.found\", file.name)");
        String title = string;
        if (filtered2) {
            String string2 = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found.filter", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ProblemsViewBundle.messa\u2026oblems.not.found.filter\")");
            String details = string2;
            return new Status(title, details, false, 4, null);
        }
        return new Status(title, null, false, 6, null);
    }

    static /* synthetic */ Status statusComplete$default(HighlightingPanel highlightingPanel, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return highlightingPanel.statusComplete(virtualFile, bl);
    }

    public HighlightingPanel(@NotNull Project project, @NotNull ProblemsViewState state) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        super(project, state);
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                HighlightingPanel.access$updateStatus((HighlightingPanel)((Object)this.receiver));
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(HighlightingPanel.class);
            }

            public final String getName() {
                return "updateStatus";
            }

            public final String getSignature() {
                return "updateStatus()V";
            }
        };
        Runnable runnable2 = new HighlightingPanel$sam$java_lang_Runnable$0(function0);
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)((Object)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"stateForComponent(this)");
        this.statusUpdateAlarm = new SingleAlarm(runnable2, 200, modalityState, (Disposable)this);
        Tree tree = this.getTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)tree, (String)"tree");
        tree.setShowsRootHandles(false);
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"getApplication()");
        application.getMessageBus().connect((Disposable)this).subscribe(PowerSaveMode.TOPIC, (Object)this);
    }

    public static final /* synthetic */ void access$updateStatus(HighlightingPanel $this) {
        $this.updateStatus();
    }
}

