/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.whitelist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.persistence.BaseEventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogTestWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.whitelist.BaseWhitelistStorage;
import com.intellij.internal.statistic.eventLog.whitelist.LocalWhitelistGroup;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistGroupRulesStorage;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistTestRulesStorageHolder;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistGroupConditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhitelistTestGroupStorage
extends BaseWhitelistStorage {
    protected final ConcurrentMap<String, EventGroupRules> eventsValidators;
    private final Object myLock;
    @NotNull
    private final EventLogTestWhitelistPersistence myTestWhitelistPersistence;
    @NotNull
    private final EventLogWhitelistPersistence myWhitelistPersistence;
    @NotNull
    private final String myRecorderId;

    WhitelistTestGroupStorage(@NotNull String recorderId) {
        if (recorderId == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(0);
        }
        this.eventsValidators = new ConcurrentHashMap<String, EventGroupRules>();
        this.myLock = new Object();
        this.myTestWhitelistPersistence = new EventLogTestWhitelistPersistence(recorderId);
        this.myWhitelistPersistence = new EventLogWhitelistPersistence(recorderId);
        this.updateValidators();
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public EventGroupRules getGroupRules(@NotNull String groupId) {
        if (groupId == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(1);
        }
        return (EventGroupRules)this.eventsValidators.get(groupId);
    }

    @Override
    public void update() {
        this.updateValidators();
    }

    @Override
    public void reload() {
        this.updateValidators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValidators() {
        Object object = this.myLock;
        synchronized (object) {
            this.eventsValidators.clear();
            this.isWhiteListInitialized.set(false);
            FUStatisticsWhiteListGroupsService.WLGroups productionGroups = EventLogTestWhitelistPersistence.loadTestWhitelist(this.myWhitelistPersistence);
            FUStatisticsWhiteListGroupsService.WLGroups testGroups = EventLogTestWhitelistPersistence.loadTestWhitelist(this.myTestWhitelistPersistence);
            Map<String, EventGroupRules> result = this.createValidators(testGroups, productionGroups.rules);
            this.eventsValidators.putAll(result);
            this.isWhiteListInitialized.set(true);
        }
    }

    @NotNull
    public FUStatisticsWhiteListGroupsService.WLGroups loadProductionGroups() {
        FUStatisticsWhiteListGroupsService.WLGroups wLGroups = EventLogTestWhitelistPersistence.loadTestWhitelist(this.myWhitelistPersistence);
        if (wLGroups == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(2);
        }
        return wLGroups;
    }

    @NotNull
    protected Map<String, EventGroupRules> createValidators(@NotNull FUStatisticsWhiteListGroupsService.WLGroups groups, @Nullable FUStatisticsWhiteListGroupsService.WLRule productionRules) {
        if (groups == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(3);
        }
        FUStatisticsWhiteListGroupsService.WLRule rules = WhitelistTestGroupStorage.merge(groups.rules, productionRules);
        EventLogBuild build2 = EventLogBuild.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
        Map<String, EventGroupRules> map = groups.groups.stream().filter(group -> StatisticsWhitelistGroupConditions.create((FUStatisticsWhiteListGroupsService.WLGroup)group).accepts(build2)).collect(Collectors.toMap(group -> group.id, group -> WhitelistTestGroupStorage.createRules(group, rules)));
        if (map == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(4);
        }
        return map;
    }

    public void addTestGroup(@NotNull LocalWhitelistGroup group) throws IOException {
        if (group == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(5);
        }
        EventLogTestWhitelistPersistence.addTestGroup(this.myRecorderId, group);
        this.updateValidators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Object object = this.myLock;
        synchronized (object) {
            this.eventsValidators.clear();
            this.myTestWhitelistPersistence.cleanup();
        }
    }

    @NotNull
    public List<LocalWhitelistGroup> loadLocalWhitelistGroups() {
        ArrayList localWhitelistGroups = EventLogTestWhitelistPersistence.loadTestWhitelist((BaseEventLogWhitelistPersistence)this.myTestWhitelistPersistence).groups;
        ArrayList<LocalWhitelistGroup> groups = new ArrayList<LocalWhitelistGroup>();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (FUStatisticsWhiteListGroupsService.WLGroup group : localWhitelistGroups) {
            if (group.id == null || group.rules == null || group.rules.event_id == null) continue;
            Set eventIds = group.rules.event_id;
            if (eventIds.contains("{util#fus_test_mode}")) {
                groups.add(new LocalWhitelistGroup(group.id, false));
                continue;
            }
            groups.add(new LocalWhitelistGroup(group.id, true, gson.toJson((Object)group.rules)));
        }
        ArrayList<LocalWhitelistGroup> arrayList = groups;
        if (arrayList == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public void updateTestGroups(@NotNull List<LocalWhitelistGroup> groups) throws IOException {
        if (groups == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(7);
        }
        this.myTestWhitelistPersistence.updateTestGroups(groups);
        this.updateValidators();
    }

    @Nullable
    private static FUStatisticsWhiteListGroupsService.WLRule merge(@Nullable FUStatisticsWhiteListGroupsService.WLRule testRules, @Nullable FUStatisticsWhiteListGroupsService.WLRule productionTestRules) {
        if (testRules == null) {
            return productionTestRules;
        }
        if (productionTestRules == null) {
            return testRules;
        }
        FUStatisticsWhiteListGroupsService.WLRule rule = new FUStatisticsWhiteListGroupsService.WLRule();
        WhitelistTestGroupStorage.copyRules(rule, productionTestRules);
        WhitelistTestGroupStorage.copyRules(rule, testRules);
        return rule;
    }

    private static void copyRules(@NotNull FUStatisticsWhiteListGroupsService.WLRule to, @NotNull FUStatisticsWhiteListGroupsService.WLRule from) {
        if (to == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(8);
        }
        if (from == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(9);
        }
        if (to.enums == null) {
            to.enums = new HashMap();
        }
        if (to.regexps == null) {
            to.regexps = new HashMap();
        }
        if (from.enums != null) {
            to.enums.putAll(from.enums);
        }
        if (from.regexps != null) {
            to.regexps.putAll(from.regexps);
        }
    }

    public static void cleanupAll() {
        List<String> recorders = StatisticsEventLoggerKt.getEventLogProviders().stream().filter(provider -> provider.isRecordEnabled()).map(provider -> provider.getRecorderId()).collect(Collectors.toList());
        WhitelistTestGroupStorage.cleanupAll(recorders);
    }

    public static void cleanupAll(List<String> recorders) {
        for (String recorderId : recorders) {
            WhitelistTestGroupStorage testWhitelist = WhitelistTestGroupStorage.getTestStorage(recorderId);
            if (testWhitelist == null) continue;
            testWhitelist.cleanup();
        }
    }

    @Nullable
    public static WhitelistTestGroupStorage getTestStorage(String recorderId) {
        SensitiveDataValidator validator = SensitiveDataValidator.getIfInitialized(recorderId);
        WhitelistGroupRulesStorage storage = validator != null ? validator.getWhiteListStorage() : null;
        return storage instanceof WhitelistTestRulesStorageHolder ? ((WhitelistTestRulesStorageHolder)((Object)storage)).getTestGroupStorage() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.myLock;
        synchronized (object) {
            return this.eventsValidators.size();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/whitelist/WhitelistTestGroupStorage";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/whitelist/WhitelistTestGroupStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProductionGroups";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidators";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLocalWhitelistGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGroupRules";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValidators";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTestGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateTestGroups";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyRules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

