/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.vcs.log.Hash;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashUtils;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.validators.GitBranchValidatorKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class GitUnstashDialog
extends DialogWrapper {
    private JComboBox<VirtualFile> myGitRootComboBox;
    private JLabel myCurrentBranch;
    private JButton myViewButton;
    private JButton myDropButton;
    private JButton myClearButton;
    private JCheckBox myPopStashCheckBox;
    private JTextField myBranchTextField;
    private JPanel myPanel;
    private JList<StashInfo> myStashList;
    private final DefaultListModel<StashInfo> myStashListModel;
    private JCheckBox myReinstateIndexCheckBox;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(GitUnstashDialog.class);

    public GitUnstashDialog(final Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setModal(false);
        this.myProject = project;
        this.setTitle(GitBundle.getString("unstash.title"));
        this.setOKButtonText(GitBundle.getString("unstash.button.apply"));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        GitUIUtil.setupRootChooser(project, roots, defaultRoot, this.myGitRootComboBox, this.myCurrentBranch);
        this.myStashListModel = new DefaultListModel();
        this.myStashList.setModel(this.myStashListModel);
        this.refreshStashList();
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.refreshStashList();
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myStashList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myBranchTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitUnstashDialog.this.updateDialogState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/GitUnstashDialog$3", "textChanged"));
            }
        });
        this.myPopStashCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0 == Messages.showYesNoDialog((Component)GitUnstashDialog.this.getContentPane(), (String)GitBundle.message("git.unstash.clear.confirmation.message", new Object[0]), (String)GitBundle.message("git.unstash.clear.confirmation.title", new Object[0]), (Icon)Messages.getWarningIcon())) {
                    final GitLineHandler h2 = new GitLineHandler(GitUnstashDialog.this.myProject, GitUnstashDialog.this.getGitRoot(), GitCommand.STASH);
                    h2.addParameters("clear");
                    new Task.Modal(project, GitBundle.getString("unstash.clearing.stashes"), false){

                        public void run(@NotNull ProgressIndicator indicator) {
                            GitCommandResult result2;
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (!(result2 = Git.getInstance().runCommand(h2)).success()) {
                                ApplicationManager.getApplication().invokeLater(() -> GitUIUtil.showOperationError(project, GitBundle.getString("unstash.clearing.stashes"), result2.getErrorOutputAsJoinedString()));
                            }
                        }

                        public void onFinished() {
                            GitUnstashDialog.this.refreshStashList();
                            GitUnstashDialog.this.updateDialogState();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/ui/GitUnstashDialog$5$1", "run"));
                        }
                    }.queue();
                }
            }
        });
        this.myDropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final StashInfo stash = GitUnstashDialog.this.getSelectedStash();
                if (0 == Messages.showYesNoDialog((Component)GitUnstashDialog.this.getContentPane(), (String)GitBundle.message("git.unstash.drop.confirmation.message", stash.getStash(), stash.getMessage()), (String)GitBundle.message("git.unstash.drop.confirmation.title", stash.getStash()), (Icon)Messages.getQuestionIcon())) {
                    final ModalityState current = ModalityState.current();
                    ProgressManager.getInstance().run((Task)new Task.Modal(GitUnstashDialog.this.myProject, GitBundle.message("unstash.dialog.remove.stash.progress.indicator.title", stash.getStash()), true){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            GitLineHandler h2 = this.dropHandler(stash.getStash());
                            try {
                                Git.getInstance().runCommand(h2).throwOnError(new int[0]);
                            }
                            catch (VcsException ex) {
                                ApplicationManager.getApplication().invokeLater(() -> GitUIUtil.showOperationError(this.myProject, ex, h2.printableCommandLine()), current);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/ui/GitUnstashDialog$6$1", "run"));
                        }
                    });
                    GitUnstashDialog.this.refreshStashList();
                    GitUnstashDialog.this.updateDialogState();
                }
            }

            private GitLineHandler dropHandler(String stash) {
                GitLineHandler h2 = new GitLineHandler(GitUnstashDialog.this.myProject, GitUnstashDialog.this.getGitRoot(), GitCommand.STASH);
                h2.addParameters("drop", stash);
                return h2;
            }
        });
        this.myViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile root = GitUnstashDialog.this.getGitRoot();
                String selectedStash = GitUnstashDialog.this.getSelectedStash().getStash();
                try {
                    String hash = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitUnstashDialog.this.resolveHashOfStash(root, selectedStash), GitBundle.getString("unstash.dialog.stash.details.load.progress.indicator.title"), true, project);
                    GitUtil.showSubmittedFiles(GitUnstashDialog.this.myProject, hash, root, true, false);
                }
                catch (VcsException ex) {
                    GitUIUtil.showOperationError(GitUnstashDialog.this.myProject, ex, "resolving revision");
                }
            }
        });
        this.init();
        this.updateDialogState();
    }

    @NotNull
    private String resolveHashOfStash(@NotNull VirtualFile root, @NotNull String stash) throws VcsException {
        if (root == null) {
            GitUnstashDialog.$$$reportNull$$$0(0);
        }
        if (stash == null) {
            GitUnstashDialog.$$$reportNull$$$0(1);
        }
        GitLineHandler h2 = new GitLineHandler(this.myProject, root, GitCommand.REV_LIST);
        h2.setSilent(true);
        h2.addParameters("--timestamp", "--max-count=1", stash);
        h2.endOptions();
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        String string = GitRevisionNumber.parseRevlistOutputAsRevisionNumber(h2, output).asString();
        if (string == null) {
            GitUnstashDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void updateDialogState() {
        String branch = this.myBranchTextField.getText();
        if (branch.length() != 0) {
            ValidationInfo branchValidationInfo;
            this.setOKButtonText(GitBundle.getString("unstash.button.branch"));
            this.myPopStashCheckBox.setEnabled(false);
            this.myPopStashCheckBox.setSelected(true);
            this.myReinstateIndexCheckBox.setEnabled(false);
            this.myReinstateIndexCheckBox.setSelected(true);
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRootQuick(this.getGitRoot());
            if (repository != null && (branchValidationInfo = GitBranchValidatorKt.validateName(Collections.singletonList(repository), branch)) != null) {
                this.setErrorText(branchValidationInfo.message, this.myBranchTextField);
                this.setOKActionEnabled(false);
                return;
            }
        } else {
            if (!this.myPopStashCheckBox.isEnabled()) {
                this.myPopStashCheckBox.setSelected(false);
            }
            this.myPopStashCheckBox.setEnabled(true);
            this.setOKButtonText(this.myPopStashCheckBox.isSelected() ? GitBundle.getString("unstash.button.pop") : GitBundle.getString("unstash.button.apply"));
            if (!this.myReinstateIndexCheckBox.isEnabled()) {
                this.myReinstateIndexCheckBox.setSelected(false);
            }
            this.myReinstateIndexCheckBox.setEnabled(true);
        }
        if (this.myStashList.getModel().getSize() == 0) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.myClearButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myClearButton.setEnabled(true);
        if (this.myStashList.getSelectedIndex() == -1) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myViewButton.setEnabled(true);
        this.myDropButton.setEnabled(true);
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void refreshStashList() {
        this.myStashListModel.clear();
        VirtualFile root = this.getGitRoot();
        try {
            List listOfStashes = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitStashUtils.loadStashStack(this.myProject, root), GitBundle.getString("unstash.dialog.stash.list.load.progress.indicator.title"), true, this.myProject);
            for (StashInfo info : listOfStashes) {
                this.myStashListModel.addElement(info);
            }
            this.myStashList.setSelectedIndex(0);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)GitBundle.getString("unstash.dialog.show.stashes.error.dialog.title"));
        }
    }

    private VirtualFile getGitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    private GitLineHandler handler() {
        GitLineHandler h2 = new GitLineHandler(this.myProject, this.getGitRoot(), GitCommand.STASH);
        String branch = this.myBranchTextField.getText();
        if (branch.length() == 0) {
            h2.addParameters(this.myPopStashCheckBox.isSelected() ? "pop" : "apply");
            if (this.myReinstateIndexCheckBox.isSelected()) {
                h2.addParameters("--index");
            }
        } else {
            h2.addParameters("branch", branch);
        }
        String selectedStash = this.getSelectedStash().getStash();
        h2.addParameters(selectedStash);
        return h2;
    }

    private StashInfo getSelectedStash() {
        return this.myStashList.getSelectedValue();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Unstash";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStashList;
    }

    protected void doOKAction() {
        VirtualFile root = this.getGitRoot();
        GitLineHandler h2 = this.handler();
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            StashInfo stash = this.getSelectedStash();
            GitRepository repository = Objects.requireNonNull((GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRootQuick(root));
            Hash hash = Git.getInstance().resolveReference(repository, stash.getStash());
            GitStashUtils.unstash(this.myProject, Collections.singletonMap(root, hash), (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)r -> h2), new UnstashConflictResolver(this.myProject, root, stash));
        }, GitBundle.getString("unstash.unstashing"), true, this.myProject);
        if (completed) {
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess(VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]));
            super.doOKAction();
        }
    }

    public static void showUnstashDialog(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot) {
        new GitUnstashDialog(project, gitRoots, defaultRoot).show();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JBList jBList;
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myGitRootComboBox = jComboBox;
        jComboBox.setToolTipText(ResourceBundle.getBundle("messages/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setText("  ");
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/GitBundle").getString("common.current.branch.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 2, 0, 1, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.stashes"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myViewButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.view"));
        jButton3.setToolTipText(ResourceBundle.getBundle("messages/GitBundle").getString("unstash.view.tooltip"));
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDropButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.drop"));
        jButton2.setToolTipText(ResourceBundle.getBundle("messages/GitBundle").getString("unstash.drop.tooltip"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myClearButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.clear"));
        jButton.setToolTipText(ResourceBundle.getBundle("messages/GitBundle").getString("unstash.clear.tooltip"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.branch.label:"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchTextField = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("messages/GitBundle").getString("unstash.branch.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myStashList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPopStashCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.pop.stash"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/GitBundle").getString("unstash.pop.stash.tooltip"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myReinstateIndexCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.reinstate.index"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/GitBundle").getString("unstash.reinstate.index.tooltip"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel4.setLabelFor((Component)jBScrollPane);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stash";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/GitUnstashDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/GitUnstashDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveHashOfStash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveHashOfStash";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnstashMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private final StashInfo myStashInfo;

        UnstashMergeDialogCustomizer(StashInfo stashInfo) {
            this.myStashInfo = stashInfo;
        }

        @NotNull
        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            if (files == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(0);
            }
            String string = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("unstash.conflict.dialog.description.label.text", XmlStringUtil.wrapInHtmlTag((String)(this.myStashInfo.getStash() + "\"" + this.myStashInfo.getMessage() + "\""), (String)"code")));
            if (string == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            if (file == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(2);
            }
            String string = GitBundle.getString("unstash.conflict.diff.dialog.left.title");
            if (string == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
            if (file == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(4);
            }
            String string = GitBundle.getString("unstash.conflict.diff.dialog.right.title");
            if (string == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/GitUnstashDialog$UnstashMergeDialogCustomizer";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/GitUnstashDialog$UnstashMergeDialogCustomizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMultipleFileMergeDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeftPanelTitle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRightPanelTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMultipleFileMergeDescription";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLeftPanelTitle";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getRightPanelTitle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnstashConflictResolver
    extends GitConflictResolver {
        private final VirtualFile myRoot;
        private final StashInfo myStashInfo;

        UnstashConflictResolver(Project project, VirtualFile root, StashInfo stashInfo) {
            super(project, Collections.singleton(root), UnstashConflictResolver.makeParams(project, stashInfo));
            this.myRoot = root;
            this.myStashInfo = stashInfo;
        }

        private static GitConflictResolver.Params makeParams(Project project, StashInfo stashInfo) {
            GitConflictResolver.Params params = new GitConflictResolver.Params(project);
            params.setErrorNotificationTitle(GitBundle.getString("unstash.unstashed.with.conflicts.error.title"));
            params.setMergeDialogCustomizer(new UnstashMergeDialogCustomizer(stashInfo));
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning(GitBundle.getString("unstash.dialog.unresolved.conflict.warning.notification.title"), GitBundle.getString("unstash.dialog.unresolved.conflict.warning.notification.message"), new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                        new UnstashConflictResolver(myProject, myRoot, myStashInfo).mergeNoProceed();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "git4idea/ui/GitUnstashDialog$UnstashConflictResolver$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }
}

