/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class SimplifyBooleanCheckQuickFix
implements LocalQuickFix {
    private final String myReplacementText;

    public SimplifyBooleanCheckQuickFix(PyBinaryExpression binaryExpression) {
        this.myReplacementText = SimplifyBooleanCheckQuickFix.createReplacementText(binaryExpression);
    }

    private static boolean isTrue(PyExpression expression) {
        return "True".equals(expression.getText());
    }

    private static boolean isFalse(PyExpression expression) {
        return "False".equals(expression.getText());
    }

    private static boolean isNull(PyExpression expression) {
        return "0".equals(expression.getText());
    }

    private static boolean isEmpty(PyExpression expression) {
        return "[]".equals(expression.getText());
    }

    @NotNull
    public String getName() {
        String string = PyPsiBundle.message("QFIX.simplify.$0", this.myReplacementText);
        if (string == null) {
            SimplifyBooleanCheckQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.simplify.boolean.expression", new Object[0]);
        if (string == null) {
            SimplifyBooleanCheckQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            SimplifyBooleanCheckQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            SimplifyBooleanCheckQuickFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor2.getPsiElement();
        PyPsiUtils.assertValid(element);
        if (!element.isValid() || !(element instanceof PyBinaryExpression)) {
            return;
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        element.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement(element), this.myReplacementText));
    }

    private static String createReplacementText(PyBinaryExpression expression) {
        PyExpression leftExpression = expression.getLeftExpression();
        PyExpression rightExpression = expression.getRightExpression();
        boolean positiveCondition = !TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.NE, PyTokenTypes.NE_OLD}).contains((IElementType)expression.getOperator());
        PyExpression resultExpression = SimplifyBooleanCheckQuickFix.isTrue(leftExpression) || SimplifyBooleanCheckQuickFix.isFalse(leftExpression) || SimplifyBooleanCheckQuickFix.isNull(leftExpression) || SimplifyBooleanCheckQuickFix.isEmpty(leftExpression) ? rightExpression : leftExpression;
        return ((positiveCondition ^= SimplifyBooleanCheckQuickFix.isFalse(leftExpression) || SimplifyBooleanCheckQuickFix.isFalse(rightExpression) || SimplifyBooleanCheckQuickFix.isNull(rightExpression) || SimplifyBooleanCheckQuickFix.isNull(leftExpression) || SimplifyBooleanCheckQuickFix.isEmpty(rightExpression) || SimplifyBooleanCheckQuickFix.isEmpty(leftExpression)) ? "" : "not ") + resultExpression.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/SimplifyBooleanCheckQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/SimplifyBooleanCheckQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

