/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.validation;

import com.intellij.stats.completion.LogEventVisitor;
import com.intellij.stats.completion.LookupEntryDiff;
import com.intellij.stats.completion.LookupEntryInfo;
import com.intellij.stats.completion.events.BackspaceEvent;
import com.intellij.stats.completion.events.CompletionCancelledEvent;
import com.intellij.stats.completion.events.CompletionStartedEvent;
import com.intellij.stats.completion.events.DownPressedEvent;
import com.intellij.stats.completion.events.ExplicitSelectEvent;
import com.intellij.stats.completion.events.LogEvent;
import com.intellij.stats.completion.events.LookupStateLogData;
import com.intellij.stats.completion.events.TypeEvent;
import com.intellij.stats.completion.events.TypedSelectEvent;
import com.intellij.stats.completion.events.UpPressedEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fJ\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\f\u001a\u00020\u0006J\u001e\u0010\u001c\u001a\u00020\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0006\u0010 \u001a\u00020\u0014J\u0006\u0010!\u001a\u00020\u0014J\u0016\u0010\"\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\bH\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020)H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020*H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020+H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020,H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020-H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020.H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020/H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/stats/validation/CompletionValidationState;", "Lcom/intellij/stats/completion/LogEventVisitor;", "event", "Lcom/intellij/stats/completion/events/CompletionStartedEvent;", "(Lcom/intellij/stats/completion/events/CompletionStartedEvent;)V", "bucket", "", "completionList", "", "", "currentId", "currentPosition", "errorMessage", "events", "", "Lcom/intellij/stats/completion/events/LogEvent;", "idToFactorNames", "", "", "isFinished", "", "isValid", "accept", "", "nextEvent", "checkDiffValid", "diff", "Lcom/intellij/stats/completion/LookupEntryDiff;", "getSafeCurrentId", "position", "invalidate", "error", "isCurrentlyValid", "isSessionValid", "updateFactors", "diffs", "updateState", "Lcom/intellij/stats/completion/events/LookupStateLogData;", "updateValid", "value", "visit", "Lcom/intellij/stats/completion/events/BackspaceEvent;", "Lcom/intellij/stats/completion/events/CompletionCancelledEvent;", "Lcom/intellij/stats/completion/events/DownPressedEvent;", "Lcom/intellij/stats/completion/events/ExplicitSelectEvent;", "Lcom/intellij/stats/completion/events/TypeEvent;", "Lcom/intellij/stats/completion/events/TypedSelectEvent;", "Lcom/intellij/stats/completion/events/UpPressedEvent;", "intellij.statsCollector.logEvents"})
public final class CompletionValidationState
extends LogEventVisitor {
    private int currentPosition;
    private List<Integer> completionList;
    private String bucket;
    private int currentId;
    private Map<Integer, Set<String>> idToFactorNames;
    private boolean isValid;
    private boolean isFinished;
    private String errorMessage;
    private List<LogEvent> events;

    private final void updateState(LookupStateLogData nextEvent) {
        this.currentPosition = nextEvent.currentPosition;
        Iterable $this$forEach$iv = nextEvent.newCompletionListItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LookupEntryInfo it = (LookupEntryInfo)element$iv;
            boolean bl = false;
            Map<Integer, Set<String>> map = this.idToFactorNames;
            Integer n = it.getId();
            CompletionValidationState completionValidationState = this;
            boolean bl2 = false;
            Map<Integer, Set<String>> map2 = map;
            boolean bl3 = false;
            boolean bl4 = map2.containsKey(n);
            completionValidationState.updateValid(!bl4, "item with " + it.getId() + " marked as a new item twice");
            Map<String, String> map3 = it.getRelevance();
            if (map3 == null || (map3 = map3.keySet()) == null) {
                map3 = SetsKt.emptySet();
            }
            Map<String, String> factorNames = map3;
            this.idToFactorNames.put(it.getId(), CollectionsKt.toMutableSet((Iterable)((Iterable)((Object)factorNames))));
        }
        this.completionList = nextEvent.completionListIds;
        this.updateFactors(nextEvent.itemsDiff);
        this.updateValid(Intrinsics.areEqual((Object)nextEvent.getBucket(), (Object)this.bucket), "All events inside a session should have the same bucket. But " + this.bucket + " != " + nextEvent.getBucket());
        this.currentId = this.getSafeCurrentId(this.completionList, this.currentPosition);
    }

    private final int getSafeCurrentId(List<Integer> completionList, int position) {
        int n;
        if (completionList.isEmpty()) {
            n = -1;
        } else if (position < completionList.size() && position >= 0) {
            n = ((Number)completionList.get(position)).intValue();
        } else {
            this.invalidate("completion list size: " + completionList.size() + ", requested position: " + position);
            n = -2;
        }
        return n;
    }

    private final void updateFactors(List<LookupEntryDiff> diffs) {
        for (LookupEntryDiff diff : diffs) {
            String name;
            int id = diff.getId();
            Set<String> knownFactors = this.idToFactorNames.get(id);
            if (knownFactors == null) {
                this.invalidate("unknown element id in the diff list: " + id);
                return;
            }
            this.checkDiffValid(diff);
            Iterable $this$forEach$iv = diff.getAdded().keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                name = (String)element$iv;
                boolean bl = false;
                this.updateValid(!knownFactors.contains(name), "factor '" + name + "' has been added earlier");
                knownFactors.add(name);
            }
            $this$forEach$iv = diff.getChanged().keySet();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                name = (String)element$iv;
                boolean bl = false;
                this.updateValid(knownFactors.contains(name), "changed factor '" + name + "' not found among factors");
            }
            $this$forEach$iv = diff.getRemoved();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                name = (String)element$iv;
                boolean bl = false;
                this.updateValid(knownFactors.contains(name), "removed factor '" + name + "' not found among factors");
                knownFactors.remove(name);
            }
        }
    }

    private final void checkDiffValid(LookupEntryDiff diff) {
        Function3<Set<? extends String>, Iterable<? extends String>, String, Unit> $fun$checkIntersection$1 = new Function3<Set<? extends String>, Iterable<? extends String>, String, Unit>(this){
            final /* synthetic */ CompletionValidationState this$0;

            public final void invoke(@NotNull Set<String> first, @NotNull Iterable<String> second, @NotNull String keysDescription) {
                Intrinsics.checkParameterIsNotNull(first, (String)"first");
                Intrinsics.checkParameterIsNotNull(second, (String)"second");
                Intrinsics.checkParameterIsNotNull((Object)keysDescription, (String)"keysDescription");
                Set intersection = CollectionsKt.intersect((Iterable)first, second);
                Collection collection = intersection;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    CompletionValidationState.access$invalidate(this.this$0, keysDescription + " factors changed simultaneously: ");
                }
            }
            {
                this.this$0 = completionValidationState;
                super(3);
            }
        };
        $fun$checkIntersection$1.invoke(diff.getAdded().keySet(), (Iterable<String>)diff.getChanged().keySet(), "added and changed");
        $fun$checkIntersection$1.invoke(diff.getAdded().keySet(), (Iterable<String>)diff.getRemoved(), "added and removed");
        $fun$checkIntersection$1.invoke(diff.getChanged().keySet(), (Iterable<String>)diff.getRemoved(), "changed and removed");
    }

    public final void accept(@NotNull LogEvent nextEvent) {
        Intrinsics.checkParameterIsNotNull((Object)nextEvent, (String)"nextEvent");
        this.events.add(nextEvent);
        if (this.isFinished) {
            this.invalidate("activity after completion finish session");
        } else if (this.isValid) {
            nextEvent.accept(this);
        }
    }

    @Override
    public void visit(@NotNull DownPressedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int beforeDownPressedPosition = this.currentPosition;
        this.updateState(event);
        if (this.completionList.isEmpty()) {
            return;
        }
        boolean isCorrectPosition = (beforeDownPressedPosition + 1) % this.completionList.size() == this.currentPosition;
        this.updateValid(isCorrectPosition, "position after up pressed event incorrect, before event " + beforeDownPressedPosition + ", " + "now " + this.currentPosition + ", " + "elements in list " + this.completionList.size());
    }

    private final void invalidate(String error) {
        this.updateValid(false, error);
    }

    private final void updateValid(boolean value, String error) {
        boolean wasValidBefore = this.isValid;
        boolean bl = this.isValid = this.isValid && value;
        if (wasValidBefore && !this.isValid) {
            this.errorMessage = error;
        }
    }

    @Override
    public void visit(@NotNull UpPressedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int beforeUpPressedPosition = this.currentPosition;
        this.updateState(event);
        if (this.completionList.isEmpty()) {
            return;
        }
        boolean isCorrectPosition = (this.completionList.size() + beforeUpPressedPosition - 1) % this.completionList.size() == this.currentPosition;
        this.updateValid(isCorrectPosition, "position after up pressed event incorrect, before event " + beforeUpPressedPosition + ", " + "now " + this.currentPosition + ", " + "elements in list " + this.completionList.size());
    }

    @Override
    public void visit(@NotNull TypeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateState(event);
        this.updateValid(this.idToFactorNames.keySet().containsAll((Collection)this.completionList), "TypeEvent: some elements in completion list are not registered");
    }

    @Override
    public void visit(@NotNull BackspaceEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateState(event);
        this.updateValid(this.idToFactorNames.keySet().containsAll((Collection)this.completionList), "Backspace: some elements in completion list are not registered");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visit(@NotNull ExplicitSelectEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        selectedIdBefore = this.currentId;
        this.updateState(event);
        v0 = this;
        if (selectedIdBefore != this.currentId) ** GOTO lbl-1000
        var3_3 = this.idToFactorNames;
        var4_4 = this.currentId;
        var8_5 = v0;
        var5_6 = false;
        var6_7 = var3_3;
        var7_8 = false;
        var9_9 = var6_7.containsKey(var4_4);
        v0 = var8_5;
        if (var9_9) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        v0.updateValid(v1, "Selected element was not registered");
        this.isFinished = true;
    }

    @Override
    public void visit(@NotNull CompletionCancelledEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.isFinished = true;
    }

    @Override
    public void visit(@NotNull TypedSelectEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateState(event);
        int id = event.selectedId;
        this.updateValid(((Number)this.completionList.get(this.currentPosition)).intValue() == id, "Element selected by typing is not the same id");
        this.isFinished = true;
    }

    public final boolean isSessionValid() {
        return this.isValid && this.isFinished;
    }

    public final boolean isCurrentlyValid() {
        return this.isValid;
    }

    @NotNull
    public final String errorMessage() {
        return this.isValid && !this.isFinished ? "Session was not finished" : this.errorMessage;
    }

    /*
     * WARNING - void declaration
     */
    public CompletionValidationState(@NotNull CompletionStartedEvent event) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.currentPosition = event.currentPosition;
        this.completionList = event.completionListIds;
        this.bucket = event.getBucket();
        this.currentId = this.getSafeCurrentId(this.completionList, this.currentPosition);
        Iterable iterable = event.newCompletionListItems;
        CompletionValidationState completionValidationState = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            LookupEntryInfo it = (LookupEntryInfo)element$iv$iv;
            boolean bl = false;
            Integer n = it.getId();
            Map<String, String> map2 = it.getRelevance();
            if (map2 == null || (map2 = map2.keySet()) == null || (map2 = CollectionsKt.toMutableSet((Iterable)((Iterable)((Object)map2)))) == null) {
                Integer n2 = n;
                boolean bl2 = false;
                Set set = new LinkedHashSet();
                n = n2;
                map2 = set;
            }
            Pair pair = TuplesKt.to((Object)n, (Object)map2);
            boolean bl3 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        completionValidationState.idToFactorNames = MapsKt.toMutableMap((Map)map);
        this.isValid = true;
        this.errorMessage = "";
        this.events = CollectionsKt.mutableListOf((Object[])new LogEvent[]{event});
    }

    public static final /* synthetic */ void access$invalidate(CompletionValidationState $this, String error) {
        $this.invalidate(error);
    }
}

