/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * exp(-2.0) => 0.13533528
 * exp(-0.6666667) => 0.5134171
 * exp(0.6666667) => 1.9477341
 * exp(2.0) => 7.389056
 */
#version 150

void main()
{
  float[distance(exp(-2.0), 0.13533528) <= 1.3533528e-06 ? 1 : -1] array0;
  float[distance(exp(-0.6666667), 0.5134171) <= 5.1341713e-06 ? 1 : -1] array1;
  float[distance(exp(0.6666667), 1.9477341) <= 1.947734e-05 ? 1 : -1] array2;
  float[distance(exp(2.0), 7.389056) <= 7.389056e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
