/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.Proxy;
import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;

public class ProxyImpl
implements Proxy,
TransportLayer {
    private final int proxyHandshakeBufferSize = 4096;
    private final ByteBuffer inputBuffer;
    private final ByteBuffer outputBuffer;
    private boolean tailClosed = false;
    private boolean headClosed = false;
    private boolean isProxyConfigured = false;
    private String host = "";
    private Map<String, String> headers = null;
    private TransportImpl underlyingTransport;
    private Proxy.ProxyState proxyState = Proxy.ProxyState.PN_PROXY_NOT_STARTED;
    private ProxyHandler proxyHandler;

    public ProxyImpl() {
        this.inputBuffer = ByteBufferUtils.newWriteableBuffer((int)4096);
        this.outputBuffer = ByteBufferUtils.newWriteableBuffer((int)4096);
    }

    public TransportWrapper wrap(TransportInput input, TransportOutput output) {
        return new ProxyTransportWrapper(input, output);
    }

    @Override
    public void configure(String host, Map<String, String> headers, ProxyHandler proxyHandler, Transport underlyingTransport) {
        this.host = host;
        this.headers = headers;
        this.proxyHandler = proxyHandler;
        this.underlyingTransport = (TransportImpl)underlyingTransport;
        this.isProxyConfigured = true;
    }

    protected ByteBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    protected ByteBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    protected Boolean getIsProxyConfigured() {
        return this.isProxyConfigured;
    }

    protected ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }

    protected Transport getUnderlyingTransport() {
        return this.underlyingTransport;
    }

    protected void writeProxyRequest() {
        this.outputBuffer.clear();
        String request = this.proxyHandler.createProxyRequest(this.host, this.headers);
        this.outputBuffer.put(request.getBytes());
    }

    protected boolean getIsHandshakeInProgress() {
        return this.isProxyConfigured && this.proxyState != Proxy.ProxyState.PN_PROXY_CONNECTED;
    }

    protected Proxy.ProxyState getProxyState() {
        return this.proxyState;
    }

    public Map<String, String> getProxyRequestHeaders() {
        return this.headers;
    }

    private class ProxyTransportWrapper
    implements TransportWrapper {
        private final TransportInput underlyingInput;
        private final TransportOutput underlyingOutput;
        private final ByteBuffer head;

        ProxyTransportWrapper(TransportInput input, TransportOutput output) {
            this.underlyingInput = input;
            this.underlyingOutput = output;
            this.head = ProxyImpl.this.outputBuffer.asReadOnlyBuffer();
        }

        public int capacity() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                if (ProxyImpl.this.tailClosed) {
                    return -1;
                }
                return ProxyImpl.this.inputBuffer.remaining();
            }
            return this.underlyingInput.capacity();
        }

        public int position() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                if (ProxyImpl.this.tailClosed) {
                    return -1;
                }
                return ProxyImpl.this.inputBuffer.position();
            }
            return this.underlyingInput.position();
        }

        public ByteBuffer tail() throws TransportException {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                return ProxyImpl.this.inputBuffer;
            }
            return this.underlyingInput.tail();
        }

        public void process() throws TransportException {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                switch (ProxyImpl.this.proxyState) {
                    case PN_PROXY_CONNECTING: {
                        ProxyImpl.this.inputBuffer.flip();
                        ProxyHandler.ProxyResponseResult responseResult = ProxyImpl.this.proxyHandler.validateProxyResponse(ProxyImpl.this.inputBuffer);
                        ProxyImpl.this.inputBuffer.compact();
                        if (responseResult.getIsSuccess().booleanValue()) {
                            ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CONNECTED;
                            break;
                        }
                        ProxyImpl.this.tailClosed = true;
                        ProxyImpl.this.underlyingTransport.closed(new TransportException("proxy connect request failed with error: " + responseResult.getError()));
                        break;
                    }
                    default: {
                        this.underlyingInput.process();
                        break;
                    }
                }
            } else {
                this.underlyingInput.process();
            }
        }

        public void close_tail() {
            ProxyImpl.this.tailClosed = true;
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                ProxyImpl.this.headClosed = true;
            }
            this.underlyingInput.close_tail();
        }

        public int pending() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                switch (ProxyImpl.this.proxyState) {
                    case PN_PROXY_NOT_STARTED: {
                        if (ProxyImpl.this.outputBuffer.position() == 0) {
                            ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CONNECTING;
                            ProxyImpl.this.writeProxyRequest();
                            this.head.limit(ProxyImpl.this.outputBuffer.position());
                            if (ProxyImpl.this.headClosed) {
                                ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_FAILED;
                                return -1;
                            }
                            return ProxyImpl.this.outputBuffer.position();
                        }
                        return ProxyImpl.this.outputBuffer.position();
                    }
                    case PN_PROXY_CONNECTING: {
                        if (ProxyImpl.this.headClosed && ProxyImpl.this.outputBuffer.position() == 0) {
                            ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_FAILED;
                            return -1;
                        }
                        return ProxyImpl.this.outputBuffer.position();
                    }
                }
                return -1;
            }
            return this.underlyingOutput.pending();
        }

        public ByteBuffer head() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                switch (ProxyImpl.this.proxyState) {
                    case PN_PROXY_CONNECTING: {
                        return this.head;
                    }
                }
                return this.underlyingOutput.head();
            }
            return this.underlyingOutput.head();
        }

        public void pop(int bytes) {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                switch (ProxyImpl.this.proxyState) {
                    case PN_PROXY_CONNECTING: {
                        if (ProxyImpl.this.outputBuffer.position() != 0) {
                            ProxyImpl.this.outputBuffer.flip();
                            ProxyImpl.this.outputBuffer.position(bytes);
                            ProxyImpl.this.outputBuffer.compact();
                            this.head.position(0);
                            this.head.limit(ProxyImpl.this.outputBuffer.position());
                            break;
                        }
                        this.underlyingOutput.pop(bytes);
                        break;
                    }
                    default: {
                        this.underlyingOutput.pop(bytes);
                        break;
                    }
                }
            } else {
                this.underlyingOutput.pop(bytes);
            }
        }

        public void close_head() {
            ProxyImpl.this.headClosed = true;
            this.underlyingOutput.close_head();
        }
    }
}

