/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.logstash.plugins.inputs.http.IMessageHandler;
import org.logstash.plugins.inputs.http.util.RejectableRunnable;

public class MessageProcessor
implements RejectableRunnable {
    private final ChannelHandlerContext ctx;
    private final FullHttpRequest req;
    private final String remoteAddress;
    private final IMessageHandler messageHandler;
    private final HttpResponseStatus responseStatus;
    private static final Charset charset = Charset.forName("UTF-8");

    MessageProcessor(ChannelHandlerContext ctx, FullHttpRequest req, String remoteAddress, IMessageHandler messageHandler, HttpResponseStatus responseStatus) {
        this.ctx = ctx;
        this.req = req;
        this.remoteAddress = remoteAddress;
        this.messageHandler = messageHandler;
        this.responseStatus = responseStatus;
    }

    @Override
    public void onRejection() {
        try {
            FullHttpResponse response = this.generateFailedResponse(HttpResponseStatus.TOO_MANY_REQUESTS);
            this.ctx.writeAndFlush((Object)response);
        }
        finally {
            this.req.release();
        }
    }

    @Override
    public void run() {
        try {
            String token = this.req.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
            this.req.headers().remove((CharSequence)HttpHeaderNames.AUTHORIZATION);
            FullHttpResponse response = this.messageHandler.validatesToken(token) ? this.processMessage() : this.generateFailedResponse(HttpResponseStatus.UNAUTHORIZED);
            this.ctx.writeAndFlush((Object)response);
        }
        finally {
            this.req.release();
        }
    }

    private FullHttpResponse processMessage() {
        String body;
        Map<String, String> formattedHeaders = this.formatHeaders(this.req.headers());
        if (this.messageHandler.onNewMessage(this.remoteAddress, formattedHeaders, body = this.req.content().toString(charset))) {
            return this.generateResponse(this.messageHandler.responseHeaders());
        }
        return this.generateFailedResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    private FullHttpResponse generateFailedResponse(HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.req.protocolVersion(), status);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        return response;
    }

    private FullHttpResponse generateResponse(Map<String, String> stringHeaders) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.req.protocolVersion(), this.responseStatus);
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        for (String key : stringHeaders.keySet()) {
            headers.set(key, (Object)stringHeaders.get(key));
        }
        response.headers().set((HttpHeaders)headers);
        if (this.responseStatus != HttpResponseStatus.NO_CONTENT) {
            ByteBuf payload = Unpooled.wrappedBuffer((byte[])"ok".getBytes(charset));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)payload.readableBytes());
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
            response.content().writeBytes(payload);
        }
        return response;
    }

    private Map<String, String> formatHeaders(HttpHeaders headers) {
        HashMap<String, String> formattedHeaders = new HashMap<String, String>();
        for (Map.Entry header : headers) {
            String key = (String)header.getKey();
            key = key.toLowerCase();
            key = key.replace('-', '_');
            formattedHeaders.put(key, (String)header.getValue());
        }
        formattedHeaders.put("http_accept", (String)formattedHeaders.remove("accept"));
        formattedHeaders.put("http_host", (String)formattedHeaders.remove("host"));
        formattedHeaders.put("http_user_agent", (String)formattedHeaders.remove("user_agent"));
        formattedHeaders.put("request_method", this.req.method().name());
        formattedHeaders.put("request_path", this.req.uri());
        formattedHeaders.put("http_version", this.req.protocolVersion().text());
        return formattedHeaders;
    }
}

