/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';
import { Router } from 'react-router-dom';
import { KibanaContextProvider } from '../../../kibana_react/public';
import { VisualizeApp } from './app';
import { addHelpMenuToAppChrome, addBadgeToAppChrome } from './utils';
export var renderApp = function renderApp(_ref, services) {
  var element = _ref.element;
  // add help link to visualize docs into app chrome menu
  addHelpMenuToAppChrome(services.chrome, services.docLinks); // add readonly badge if saving restricted

  if (!services.visualizeCapabilities.save) {
    addBadgeToAppChrome(services.chrome);
  }

  var app = /*#__PURE__*/React.createElement(Router, {
    history: services.history
  }, /*#__PURE__*/React.createElement(KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/React.createElement(services.i18n.Context, null, /*#__PURE__*/React.createElement(VisualizeApp, null))));
  ReactDOM.render(app, element);
  return function () {
    return ReactDOM.unmountComponentAtNode(element);
  };
};