/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { colorSchemas, Rotates } from '../../../charts/public';
export var Positions = Object.freeze({
  RIGHT: 'right',
  LEFT: 'left',
  TOP: 'top',
  BOTTOM: 'bottom'
});

var getPositions = function getPositions() {
  return [{
    text: i18n.translate('visTypeVislib.legendPositions.topText', {
      defaultMessage: 'Top'
    }),
    value: Positions.TOP
  }, {
    text: i18n.translate('visTypeVislib.legendPositions.leftText', {
      defaultMessage: 'Left'
    }),
    value: Positions.LEFT
  }, {
    text: i18n.translate('visTypeVislib.legendPositions.rightText', {
      defaultMessage: 'Right'
    }),
    value: Positions.RIGHT
  }, {
    text: i18n.translate('visTypeVislib.legendPositions.bottomText', {
      defaultMessage: 'Bottom'
    }),
    value: Positions.BOTTOM
  }];
};

export var ChartTypes = Object.freeze({
  LINE: 'line',
  AREA: 'area',
  HISTOGRAM: 'histogram'
});

var getChartTypes = function getChartTypes() {
  return [{
    text: i18n.translate('visTypeVislib.chartTypes.lineText', {
      defaultMessage: 'Line'
    }),
    value: ChartTypes.LINE
  }, {
    text: i18n.translate('visTypeVislib.chartTypes.areaText', {
      defaultMessage: 'Area'
    }),
    value: ChartTypes.AREA
  }, {
    text: i18n.translate('visTypeVislib.chartTypes.barText', {
      defaultMessage: 'Bar'
    }),
    value: ChartTypes.HISTOGRAM
  }];
};

export var ChartModes = Object.freeze({
  NORMAL: 'normal',
  STACKED: 'stacked'
});

var getChartModes = function getChartModes() {
  return [{
    text: i18n.translate('visTypeVislib.chartModes.normalText', {
      defaultMessage: 'Normal'
    }),
    value: ChartModes.NORMAL
  }, {
    text: i18n.translate('visTypeVislib.chartModes.stackedText', {
      defaultMessage: 'Stacked'
    }),
    value: ChartModes.STACKED
  }];
};

export var InterpolationModes = Object.freeze({
  LINEAR: 'linear',
  CARDINAL: 'cardinal',
  STEP_AFTER: 'step-after'
});

var getInterpolationModes = function getInterpolationModes() {
  return [{
    text: i18n.translate('visTypeVislib.interpolationModes.straightText', {
      defaultMessage: 'Straight'
    }),
    value: InterpolationModes.LINEAR
  }, {
    text: i18n.translate('visTypeVislib.interpolationModes.smoothedText', {
      defaultMessage: 'Smoothed'
    }),
    value: InterpolationModes.CARDINAL
  }, {
    text: i18n.translate('visTypeVislib.interpolationModes.steppedText', {
      defaultMessage: 'Stepped'
    }),
    value: InterpolationModes.STEP_AFTER
  }];
};

export var AxisTypes = Object.freeze({
  CATEGORY: 'category',
  VALUE: 'value'
});
export var ScaleTypes = Object.freeze({
  LINEAR: 'linear',
  LOG: 'log',
  SQUARE_ROOT: 'square root'
});

var getScaleTypes = function getScaleTypes() {
  return [{
    text: i18n.translate('visTypeVislib.scaleTypes.linearText', {
      defaultMessage: 'Linear'
    }),
    value: ScaleTypes.LINEAR
  }, {
    text: i18n.translate('visTypeVislib.scaleTypes.logText', {
      defaultMessage: 'Log'
    }),
    value: ScaleTypes.LOG
  }, {
    text: i18n.translate('visTypeVislib.scaleTypes.squareRootText', {
      defaultMessage: 'Square root'
    }),
    value: ScaleTypes.SQUARE_ROOT
  }];
};

export var AxisModes = Object.freeze({
  NORMAL: 'normal',
  PERCENTAGE: 'percentage',
  WIGGLE: 'wiggle',
  SILHOUETTE: 'silhouette'
});

var getAxisModes = function getAxisModes() {
  return [{
    text: i18n.translate('visTypeVislib.axisModes.normalText', {
      defaultMessage: 'Normal'
    }),
    value: AxisModes.NORMAL
  }, {
    text: i18n.translate('visTypeVislib.axisModes.percentageText', {
      defaultMessage: 'Percentage'
    }),
    value: AxisModes.PERCENTAGE
  }, {
    text: i18n.translate('visTypeVislib.axisModes.wiggleText', {
      defaultMessage: 'Wiggle'
    }),
    value: AxisModes.WIGGLE
  }, {
    text: i18n.translate('visTypeVislib.axisModes.silhouetteText', {
      defaultMessage: 'Silhouette'
    }),
    value: AxisModes.SILHOUETTE
  }];
};

export var ThresholdLineStyles = Object.freeze({
  FULL: 'full',
  DASHED: 'dashed',
  DOT_DASHED: 'dot-dashed'
});

var getThresholdLineStyles = function getThresholdLineStyles() {
  return [{
    value: ThresholdLineStyles.FULL,
    text: i18n.translate('visTypeVislib.thresholdLine.style.fullText', {
      defaultMessage: 'Full'
    })
  }, {
    value: ThresholdLineStyles.DASHED,
    text: i18n.translate('visTypeVislib.thresholdLine.style.dashedText', {
      defaultMessage: 'Dashed'
    })
  }, {
    value: ThresholdLineStyles.DOT_DASHED,
    text: i18n.translate('visTypeVislib.thresholdLine.style.dotdashedText', {
      defaultMessage: 'Dot-dashed'
    })
  }];
};

var getRotateOptions = function getRotateOptions() {
  return [{
    text: i18n.translate('visTypeVislib.categoryAxis.rotate.horizontalText', {
      defaultMessage: 'Horizontal'
    }),
    value: Rotates.HORIZONTAL
  }, {
    text: i18n.translate('visTypeVislib.categoryAxis.rotate.verticalText', {
      defaultMessage: 'Vertical'
    }),
    value: Rotates.VERTICAL
  }, {
    text: i18n.translate('visTypeVislib.categoryAxis.rotate.angledText', {
      defaultMessage: 'Angled'
    }),
    value: Rotates.ANGLED
  }];
};

export var GaugeTypes = Object.freeze({
  ARC: 'Arc',
  CIRCLE: 'Circle'
});

var getGaugeTypes = function getGaugeTypes() {
  return [{
    text: i18n.translate('visTypeVislib.gauge.gaugeTypes.arcText', {
      defaultMessage: 'Arc'
    }),
    value: GaugeTypes.ARC
  }, {
    text: i18n.translate('visTypeVislib.gauge.gaugeTypes.circleText', {
      defaultMessage: 'Circle'
    }),
    value: GaugeTypes.CIRCLE
  }];
};

export var Alignments = Object.freeze({
  AUTOMATIC: 'automatic',
  HORIZONTAL: 'horizontal',
  VERTICAL: 'vertical'
});

var getAlignments = function getAlignments() {
  return [{
    text: i18n.translate('visTypeVislib.gauge.alignmentAutomaticTitle', {
      defaultMessage: 'Automatic'
    }),
    value: Alignments.AUTOMATIC
  }, {
    text: i18n.translate('visTypeVislib.gauge.alignmentHorizontalTitle', {
      defaultMessage: 'Horizontal'
    }),
    value: Alignments.HORIZONTAL
  }, {
    text: i18n.translate('visTypeVislib.gauge.alignmentVerticalTitle', {
      defaultMessage: 'Vertical'
    }),
    value: Alignments.VERTICAL
  }];
};

var getConfigCollections = function getConfigCollections() {
  return {
    legendPositions: getPositions(),
    positions: getPositions(),
    chartTypes: getChartTypes(),
    axisModes: getAxisModes(),
    scaleTypes: getScaleTypes(),
    chartModes: getChartModes(),
    interpolationModes: getInterpolationModes(),
    thresholdLineStyles: getThresholdLineStyles()
  };
};

var getGaugeCollections = function getGaugeCollections() {
  return {
    gaugeTypes: getGaugeTypes(),
    alignments: getAlignments(),
    colorSchemas: colorSchemas
  };
};

var getHeatmapCollections = function getHeatmapCollections() {
  return {
    legendPositions: getPositions(),
    scales: getScaleTypes(),
    colorSchemas: colorSchemas
  };
};

export { getConfigCollections, getGaugeCollections, getHeatmapCollections, getPositions, getRotateOptions, getScaleTypes, getInterpolationModes, getChartTypes, getChartModes, getAxisModes };