/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiFormLabel, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { useMount } from 'react-use';
import { AggGroupNames } from '../../../../data/public';
import { useSubAggParamsHandlers } from './utils';
import { DefaultEditorAggParams } from '../agg_params';

function SubMetricParamEditor(_ref) {
  var agg = _ref.agg,
      aggParam = _ref.aggParam,
      formIsTouched = _ref.formIsTouched,
      metricAggs = _ref.metricAggs,
      state = _ref.state,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      setTouched = _ref.setTouched,
      schemas = _ref.schemas;
  var metricTitle = i18n.translate('visDefaultEditor.controls.metrics.metricTitle', {
    defaultMessage: 'Metric'
  });
  var bucketTitle = i18n.translate('visDefaultEditor.controls.metrics.bucketTitle', {
    defaultMessage: 'Bucket'
  });
  var type = aggParam.name;
  var isCustomMetric = type === 'customMetric';
  var aggTitle = isCustomMetric ? metricTitle : bucketTitle;
  var aggGroup = isCustomMetric ? AggGroupNames.Metrics : AggGroupNames.Buckets;
  useMount(function () {
    if (agg.params[type]) {
      setValue(agg.params[type]);
    } else {
      setValue(aggParam.makeAgg(agg));
    }
  });

  var _useSubAggParamsHandl = useSubAggParamsHandlers(agg, aggParam, agg.params[type], setValue),
      onAggTypeChange = _useSubAggParamsHandl.onAggTypeChange,
      setAggParamValue = _useSubAggParamsHandl.setAggParamValue;

  if (!agg.params[type]) {
    return null;
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiFormLabel, null, aggTitle), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(DefaultEditorAggParams, {
    agg: agg.params[type],
    allowedAggs: aggParam.allowedAggs,
    groupName: aggGroup,
    className: "visEditorAgg__subAgg",
    formIsTouched: formIsTouched,
    indexPattern: agg.getIndexPattern(),
    metricAggs: metricAggs,
    state: state,
    setAggParamValue: setAggParamValue,
    onAggTypeChange: onAggTypeChange,
    setValidity: setValidity,
    setTouched: setTouched,
    schemas: schemas,
    hideCustomLabel: !isCustomMetric
  }));
}

export { SubMetricParamEditor };