function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { EuiSpacer, EuiCallOut } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { indexPatterns, UI_SETTINGS } from '../../../../../../../plugins/data/public';
import { getIndices, containsIllegalCharacters, getMatchedIndices, canAppendWildcard, ensureMinimumTime } from '../../lib';
import { LoadingIndices } from './components/loading_indices';
import { StatusMessage } from './components/status_message';
import { IndicesList } from './components/indices_list';
import { Header } from './components/header';
import { context as contextType } from '../../../../../../kibana_react/public';
export var canPreselectTimeField = function canPreselectTimeField(indices) {
  var preselectStatus = indices.reduce(function (_ref, matchedItem) {
    var canPreselect = _ref.canPreselect,
        timeFieldName = _ref.timeFieldName;
    var dataStreamItem = matchedItem.item;
    var dataStreamTimestampField = dataStreamItem.timestamp_field;
    var isDataStream = !!dataStreamItem.timestamp_field;
    var timestampFieldMatches = timeFieldName === undefined || timeFieldName === dataStreamTimestampField;
    return {
      canPreselect: canPreselect && isDataStream && timestampFieldMatches,
      timeFieldName: dataStreamTimestampField || timeFieldName
    };
  }, {
    canPreselect: true,
    timeFieldName: undefined
  });
  return preselectStatus.canPreselect ? preselectStatus.timeFieldName : undefined;
};
export var StepIndexPattern = /*#__PURE__*/function (_Component) {
  _inherits(StepIndexPattern, _Component);

  var _super = _createSuper(StepIndexPattern);

  function StepIndexPattern(props, context) {
    var _this;

    _classCallCheck(this, StepIndexPattern);

    _this = _super.call(this, props, context);

    _defineProperty(_assertThisInitialized(_this), "context", void 0);

    _defineProperty(_assertThisInitialized(_this), "state", {
      partialMatchedIndices: [],
      exactMatchedIndices: [],
      isLoadingIndices: false,
      existingIndexPatterns: [],
      indexPatternExists: false,
      query: '',
      appendedWildcard: false,
      showingIndexPatternQueryErrors: false,
      indexPatternName: '',
      isIncludingSystemIndices: false
    });

    _defineProperty(_assertThisInitialized(_this), "ILLEGAL_CHARACTERS", _toConsumableArray(indexPatterns.ILLEGAL_CHARACTERS));

    _defineProperty(_assertThisInitialized(_this), "lastQuery", '');

    _defineProperty(_assertThisInitialized(_this), "fetchExistingIndexPatterns", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var _yield$_this$context$, savedObjects, existingIndexPatterns;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return _this.context.services.savedObjects.client.find({
                type: 'index-pattern',
                fields: ['title'],
                perPage: 10000
              });

            case 2:
              _yield$_this$context$ = _context.sent;
              savedObjects = _yield$_this$context$.savedObjects;
              existingIndexPatterns = savedObjects.map(function (obj) {
                return obj && obj.attributes ? obj.attributes.title : '';
              });

              _this.setState({
                existingIndexPatterns: existingIndexPatterns
              });

            case 6:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(_assertThisInitialized(_this), "fetchIndices", /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(query) {
        var indexPatternCreationType, existingIndexPatterns, _exactMatchedIndices, _yield$ensureMinimumT, _yield$ensureMinimumT2, partialMatchedIndices, exactMatchedIndices;

        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                indexPatternCreationType = _this.props.indexPatternCreationType;
                existingIndexPatterns = _this.state.existingIndexPatterns;

                if (!existingIndexPatterns.includes(query)) {
                  _context2.next = 5;
                  break;
                }

                _this.setState({
                  indexPatternExists: true
                });

                return _context2.abrupt("return");

              case 5:
                _this.setState({
                  isLoadingIndices: true,
                  indexPatternExists: false
                });

                if (!query.endsWith('*')) {
                  _context2.next = 14;
                  break;
                }

                _context2.next = 9;
                return ensureMinimumTime(getIndices(_this.context.services.http, indexPatternCreationType, query, _this.state.isIncludingSystemIndices));

              case 9:
                _exactMatchedIndices = _context2.sent;

                if (!(query !== _this.lastQuery)) {
                  _context2.next = 12;
                  break;
                }

                return _context2.abrupt("return");

              case 12:
                _this.setState({
                  exactMatchedIndices: _exactMatchedIndices,
                  isLoadingIndices: false
                });

                return _context2.abrupt("return");

              case 14:
                _context2.next = 16;
                return ensureMinimumTime([getIndices(_this.context.services.http, indexPatternCreationType, "".concat(query, "*"), _this.state.isIncludingSystemIndices), getIndices(_this.context.services.http, indexPatternCreationType, query, _this.state.isIncludingSystemIndices)]);

              case 16:
                _yield$ensureMinimumT = _context2.sent;
                _yield$ensureMinimumT2 = _slicedToArray(_yield$ensureMinimumT, 2);
                partialMatchedIndices = _yield$ensureMinimumT2[0];
                exactMatchedIndices = _yield$ensureMinimumT2[1];

                if (!(query !== _this.lastQuery)) {
                  _context2.next = 22;
                  break;
                }

                return _context2.abrupt("return");

              case 22:
                _this.setState({
                  partialMatchedIndices: partialMatchedIndices,
                  exactMatchedIndices: exactMatchedIndices,
                  isLoadingIndices: false
                });

              case 23:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      return function (_x) {
        return _ref3.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "onQueryChanged", function (e) {
      var appendedWildcard = _this.state.appendedWildcard;
      var target = e.target;
      var query = target.value;

      if (query.length === 1 && canAppendWildcard(query)) {
        query += '*';

        _this.setState({
          appendedWildcard: true
        });

        setTimeout(function () {
          return target.setSelectionRange(1, 1);
        });
      } else {
        if (query === '*' && appendedWildcard) {
          query = '';

          _this.setState({
            appendedWildcard: false
          });
        }
      }

      _this.lastQuery = query;

      _this.setState({
        query: query,
        showingIndexPatternQueryErrors: !!query.length
      });

      _this.fetchIndices(query);
    });

    _defineProperty(_assertThisInitialized(_this), "onChangeIncludingSystemIndices", function (event) {
      _this.setState({
        isIncludingSystemIndices: event.target.checked
      }, function () {
        return _this.fetchIndices(_this.state.query);
      });
    });

    var _this$props = _this.props,
        _indexPatternCreationType = _this$props.indexPatternCreationType,
        initialQuery = _this$props.initialQuery;
    _this.state.query = initialQuery || context.services.uiSettings.get(UI_SETTINGS.INDEXPATTERN_PLACEHOLDER);
    _this.state.indexPatternName = _indexPatternCreationType.getIndexPatternName();
    return _this;
  }

  _createClass(StepIndexPattern, [{
    key: "UNSAFE_componentWillMount",
    value: function () {
      var _UNSAFE_componentWillMount = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                this.fetchExistingIndexPatterns();

                if (this.state.query) {
                  this.lastQuery = this.state.query;
                  this.fetchIndices(this.state.query);
                }

              case 2:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function UNSAFE_componentWillMount() {
        return _UNSAFE_componentWillMount.apply(this, arguments);
      }

      return UNSAFE_componentWillMount;
    }()
  }, {
    key: "renderLoadingState",
    value: function renderLoadingState() {
      var isLoadingIndices = this.state.isLoadingIndices;

      if (!isLoadingIndices) {
        return null;
      }

      return /*#__PURE__*/React.createElement(LoadingIndices, {
        "data-test-subj": "createIndexPatternStep1Loading"
      });
    }
  }, {
    key: "renderStatusMessage",
    value: function renderStatusMessage(matchedIndices) {
      var indexPatternCreationType = this.props.indexPatternCreationType;
      var _this$state = this.state,
          query = _this$state.query,
          isLoadingIndices = _this$state.isLoadingIndices,
          indexPatternExists = _this$state.indexPatternExists,
          isIncludingSystemIndices = _this$state.isIncludingSystemIndices;

      if (isLoadingIndices || indexPatternExists) {
        return null;
      }

      return /*#__PURE__*/React.createElement(StatusMessage, {
        matchedIndices: matchedIndices,
        showSystemIndices: indexPatternCreationType.getShowSystemIndices(),
        isIncludingSystemIndices: isIncludingSystemIndices,
        query: query
      });
    }
  }, {
    key: "renderList",
    value: function renderList(_ref4) {
      var visibleIndices = _ref4.visibleIndices,
          allIndices = _ref4.allIndices;
      var _this$state2 = this.state,
          query = _this$state2.query,
          isLoadingIndices = _this$state2.isLoadingIndices,
          indexPatternExists = _this$state2.indexPatternExists;

      if (isLoadingIndices || indexPatternExists) {
        return null;
      }

      var indicesToList = query.length ? visibleIndices : allIndices;
      return /*#__PURE__*/React.createElement(IndicesList, {
        "data-test-subj": "createIndexPatternStep1IndicesList",
        query: query,
        indices: indicesToList
      });
    }
  }, {
    key: "renderIndexPatternExists",
    value: function renderIndexPatternExists() {
      var _this$state3 = this.state,
          indexPatternExists = _this$state3.indexPatternExists,
          query = _this$state3.query;

      if (!indexPatternExists) {
        return null;
      }

      return /*#__PURE__*/React.createElement(EuiCallOut, {
        title: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.createIndexPattern.step.warningHeader",
          defaultMessage: "There's already an index pattern called {query}",
          values: {
            query: query
          }
        }),
        iconType: "help",
        color: "warning"
      });
    }
  }, {
    key: "renderHeader",
    value: function renderHeader(_ref5) {
      var indices = _ref5.exactMatchedIndices;
      var _this$props2 = this.props,
          _goToNextStep = _this$props2.goToNextStep,
          indexPatternCreationType = _this$props2.indexPatternCreationType;
      var _this$state4 = this.state,
          query = _this$state4.query,
          showingIndexPatternQueryErrors = _this$state4.showingIndexPatternQueryErrors,
          indexPatternExists = _this$state4.indexPatternExists,
          indexPatternName = _this$state4.indexPatternName,
          isIncludingSystemIndices = _this$state4.isIncludingSystemIndices;
      var containsErrors = false;
      var errors = [];
      var characterList = this.ILLEGAL_CHARACTERS.slice(0, this.ILLEGAL_CHARACTERS.length - 1).join(', ');
      var checkIndices = indexPatternCreationType.checkIndicesForErrors(indices);

      if (!query || !query.length || query === '.' || query === '..') {
        // This is an error scenario but do not report an error
        containsErrors = true;
      } else if (containsIllegalCharacters(query, indexPatterns.ILLEGAL_CHARACTERS)) {
        var errorMessage = i18n.translate('indexPatternManagement.createIndexPattern.step.invalidCharactersErrorMessage', {
          defaultMessage: 'A {indexPatternName} cannot contain spaces or the characters: {characterList}',
          values: {
            characterList: characterList,
            indexPatternName: indexPatternName
          }
        });
        errors.push(errorMessage);
        containsErrors = true;
      } else if (checkIndices) {
        errors.push.apply(errors, _toConsumableArray(checkIndices));
        containsErrors = true;
      }

      var isInputInvalid = showingIndexPatternQueryErrors && containsErrors && errors.length > 0;
      var isNextStepDisabled = containsErrors || indices.length === 0 || indexPatternExists;
      return /*#__PURE__*/React.createElement(Header, {
        "data-test-subj": "createIndexPatternStep1Header",
        isInputInvalid: isInputInvalid,
        errors: errors,
        characterList: characterList,
        query: query,
        onQueryChanged: this.onQueryChanged,
        goToNextStep: function goToNextStep() {
          return _goToNextStep(query, canPreselectTimeField(indices));
        },
        isNextStepDisabled: isNextStepDisabled,
        onChangeIncludingSystemIndices: this.onChangeIncludingSystemIndices,
        isIncludingSystemIndices: isIncludingSystemIndices,
        showSystemIndices: this.props.showSystemIndices
      });
    }
  }, {
    key: "render",
    value: function render() {
      var allIndices = this.props.allIndices;
      var _this$state5 = this.state,
          partialMatchedIndices = _this$state5.partialMatchedIndices,
          exactMatchedIndices = _this$state5.exactMatchedIndices,
          isIncludingSystemIndices = _this$state5.isIncludingSystemIndices;
      var matchedIndices = getMatchedIndices(allIndices, partialMatchedIndices, exactMatchedIndices, isIncludingSystemIndices);
      return /*#__PURE__*/React.createElement(React.Fragment, null, this.renderHeader(matchedIndices), /*#__PURE__*/React.createElement(EuiSpacer, null), this.renderLoadingState(), this.renderIndexPatternExists(), this.renderStatusMessage(matchedIndices), /*#__PURE__*/React.createElement(EuiSpacer, null), this.renderList(matchedIndices));
    }
  }]);

  return StepIndexPattern;
}(Component);

_defineProperty(StepIndexPattern, "contextType", contextType);