function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { esFilters } from '../../data/public';
import { setStateToKbnUrl } from '../../kibana_utils/public';
export var DISCOVER_APP_URL_GENERATOR = 'DISCOVER_APP_URL_GENERATOR';
export var DiscoverUrlGenerator = function DiscoverUrlGenerator(params) {
  var _this = this;

  _classCallCheck(this, DiscoverUrlGenerator);

  this.params = params;

  _defineProperty(this, "id", DISCOVER_APP_URL_GENERATOR);

  _defineProperty(this, "createUrl", /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
      var filters, indexPatternId, query, refreshInterval, savedSearchId, timeRange, _ref$useHash, useHash, savedSearchPath, appState, queryState, url;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              filters = _ref.filters, indexPatternId = _ref.indexPatternId, query = _ref.query, refreshInterval = _ref.refreshInterval, savedSearchId = _ref.savedSearchId, timeRange = _ref.timeRange, _ref$useHash = _ref.useHash, useHash = _ref$useHash === void 0 ? _this.params.useHash : _ref$useHash;
              savedSearchPath = savedSearchId ? encodeURIComponent(savedSearchId) : '';
              appState = {};
              queryState = {};
              if (query) appState.query = query;
              if (filters && filters.length) appState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(function (f) {
                return !esFilters.isFilterPinned(f);
              });
              if (indexPatternId) appState.index = indexPatternId;
              if (timeRange) queryState.time = timeRange;
              if (filters && filters.length) queryState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(function (f) {
                return esFilters.isFilterPinned(f);
              });
              if (refreshInterval) queryState.refreshInterval = refreshInterval;
              url = "".concat(_this.params.appBasePath, "#/").concat(savedSearchPath);
              url = setStateToKbnUrl('_g', queryState, {
                useHash: useHash
              }, url);
              url = setStateToKbnUrl('_a', appState, {
                useHash: useHash
              }, url);
              return _context.abrupt("return", url);

            case 14:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function (_x) {
      return _ref2.apply(this, arguments);
    };
  }());
};