/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiLink, EuiIconTip, EuiText } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { DiscoverFieldBucket } from './discover_field_bucket';
import { getWarnings } from './lib/get_warnings';
import { getServices } from '../../../kibana_services';
export function DiscoverFieldDetails(_ref) {
  var field = _ref.field,
      indexPattern = _ref.indexPattern,
      details = _ref.details,
      onAddFilter = _ref.onAddFilter;
  var warnings = getWarnings(field);
  return /*#__PURE__*/React.createElement("div", {
    className: "dscFieldDetails"
  }, !details.error && /*#__PURE__*/React.createElement(EuiText, {
    size: "xs"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.fieldChooser.detailViews.topValuesInRecordsDescription",
    defaultMessage: "Top 5 values in"
  }), ' ', !indexPattern.metaFields.includes(field.name) && !field.scripted ? /*#__PURE__*/React.createElement(EuiLink, {
    onClick: function onClick() {
      return onAddFilter('_exists_', field.name, '+');
    }
  }, details.exists) : /*#__PURE__*/React.createElement("span", null, details.exists), ' ', "/ ", details.total, ' ', /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.fieldChooser.detailViews.recordsText",
    defaultMessage: "records"
  })), details.error && /*#__PURE__*/React.createElement(EuiText, {
    size: "xs"
  }, details.error), !details.error && /*#__PURE__*/React.createElement("div", {
    style: {
      marginTop: '4px'
    }
  }, details.buckets.map(function (bucket, idx) {
    return /*#__PURE__*/React.createElement(DiscoverFieldBucket, {
      key: "bucket".concat(idx),
      bucket: bucket,
      field: field,
      onAddFilter: onAddFilter
    });
  })), details.visualizeUrl && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiLink, {
    onClick: function onClick() {
      getServices().core.application.navigateToApp(details.visualizeUrl.app, {
        path: details.visualizeUrl.path
      });
    },
    className: "kuiButton kuiButton--secondary kuiButton--small kuiVerticalRhythmSmall",
    "data-test-subj": "fieldVisualize-".concat(field.name)
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.fieldChooser.detailViews.visualizeLinkText",
    defaultMessage: "Visualize"
  }), warnings.length > 0 && /*#__PURE__*/React.createElement(EuiIconTip, {
    type: "alert",
    color: "warning",
    content: warnings.join(' ')
  }))));
}