function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiButtonEmpty, EuiForm, EuiFormRow, EuiLink, EuiPopover, EuiPopoverTitle, EuiSpacer, EuiSwitch, EuiText } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import React, { useState } from 'react';
import { useKibana } from '../../../../kibana_react/public';
export function QueryLanguageSwitcher(props) {
  var kibana = useKibana();
  var kueryQuerySyntaxDocs = kibana.services.docLinks.links.query.kueryQuerySyntax;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isPopoverOpen = _useState2[0],
      setIsPopoverOpen = _useState2[1];

  var luceneLabel = /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "data.query.queryBar.luceneLanguageName",
    defaultMessage: "Lucene"
  });
  var kqlLabel = /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "data.query.queryBar.kqlLanguageName",
    defaultMessage: "KQL"
  });
  var kqlFullName = /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "data.query.queryBar.kqlFullLanguageName",
    defaultMessage: "Kibana Query Language"
  });
  var button = /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    size: "xs",
    onClick: function onClick() {
      return setIsPopoverOpen(!isPopoverOpen);
    },
    className: "euiFormControlLayout__append kqlQueryBar__languageSwitcherButton",
    "data-test-subj": 'switchQueryLanguageButton'
  }, props.language === 'lucene' ? luceneLabel : kqlLabel);
  return /*#__PURE__*/React.createElement(EuiPopover, {
    id: "queryLanguageSwitcherPopover",
    anchorClassName: "euiFormControlLayout__append",
    ownFocus: true,
    anchorPosition: props.anchorPosition || 'downRight',
    button: button,
    isOpen: isPopoverOpen,
    closePopover: function closePopover() {
      return setIsPopoverOpen(false);
    },
    withTitle: true,
    repositionOnScroll: true
  }, /*#__PURE__*/React.createElement(EuiPopoverTitle, null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "data.query.queryBar.syntaxOptionsTitle",
    defaultMessage: "Syntax options"
  })), /*#__PURE__*/React.createElement("div", {
    style: {
      width: '350px'
    }
  }, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "data.query.queryBar.syntaxOptionsDescription",
    defaultMessage: "The {docsLink} (KQL) offers a simplified query syntax and support for scripted fields. KQL also provides autocomplete if you have a Basic license or above. If you turn off KQL, Kibana uses Lucene.",
    values: {
      docsLink: /*#__PURE__*/React.createElement(EuiLink, {
        href: kueryQuerySyntaxDocs,
        target: "_blank"
      }, kqlFullName)
    }
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiForm, null, /*#__PURE__*/React.createElement(EuiFormRow, {
    label: kqlFullName
  }, /*#__PURE__*/React.createElement(EuiSwitch, {
    id: "queryEnhancementOptIn",
    name: "popswitch",
    label: props.language === 'kuery' ? /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "data.query.queryBar.kqlOnLabel",
      defaultMessage: "On"
    }) : /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "data.query.queryBar.kqlOffLabel",
      defaultMessage: "Off"
    }),
    checked: props.language === 'kuery',
    onChange: function onChange() {
      var newLanguage = props.language === 'lucene' ? 'kuery' : 'lucene';
      props.onSelectLanguage(newLanguage);
    },
    "data-test-subj": "languageToggle"
  })))));
}