function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import dateMath from '@elastic/datemath';
import { FILTER_OPERATORS } from './filter_operators';
import { isFilterable, Ipv4Address } from '../../../../../common';
export function getFieldFromFilter(filter, indexPattern) {
  return indexPattern.fields.find(function (field) {
    return field.name === filter.meta.key;
  });
}
export function getOperatorFromFilter(filter) {
  return FILTER_OPERATORS.find(function (operator) {
    return filter.meta.type === operator.type && filter.meta.negate === operator.negate;
  });
}
export function getFilterableFields(indexPattern) {
  return indexPattern.fields.filter(isFilterable);
}
export function getOperatorOptions(field) {
  return FILTER_OPERATORS.filter(function (operator) {
    return !operator.fieldTypes || operator.fieldTypes.includes(field.type);
  });
}
export function validateParams(params, type) {
  switch (type) {
    case 'date':
      var moment = typeof params === 'string' ? dateMath.parse(params) : null;
      return Boolean(typeof params === 'string' && moment && moment.isValid());

    case 'ip':
      try {
        return Boolean(new Ipv4Address(params));
      } catch (e) {
        return false;
      }

    default:
      return true;
  }
}
export function isFilterValid(indexPattern, field, operator, params) {
  if (!indexPattern || !field || !operator) {
    return false;
  }

  switch (operator.type) {
    case 'phrase':
      return validateParams(params, field.type);

    case 'phrases':
      if (!Array.isArray(params) || !params.length) {
        return false;
      }

      return params.every(function (phrase) {
        return validateParams(phrase, field.type);
      });

    case 'range':
      if (_typeof(params) !== 'object') {
        return false;
      }

      return (!params.from || validateParams(params.from, field.type)) && (!params.to || validateParams(params.to, field.type));

    case 'exists':
      return true;

    default:
      throw new Error("Unknown operator type: ".concat(operator.type));
  }
}