function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get, noop, find, every } from 'lodash';
import moment from 'moment-timezone';
import { i18n } from '@kbn/i18n';
import { TimeBuckets } from './lib/time_buckets';
import { BucketAggType } from './bucket_agg_type';
import { BUCKET_TYPES } from './bucket_agg_types';
import { createFilterDateHistogram } from './create_filter/date_histogram';
import { intervalOptions } from './_interval_options';
import { writeParams } from '../agg_params';
import { isMetricAggType } from '../metrics/metric_agg_type';
import { dateHistogramInterval, KBN_FIELD_TYPES, UI_SETTINGS } from '../../../../common';

var updateTimeBuckets = function updateTimeBuckets(agg, calculateBounds, customBuckets) {
  var bounds = agg.params.timeRange && (agg.fieldIsTimeField() || agg.params.interval === 'auto') ? calculateBounds(agg.params.timeRange) : undefined;
  var buckets = customBuckets || agg.buckets;
  buckets.setBounds(bounds);
  buckets.setInterval(agg.params.interval);
};

export function isDateHistogramBucketAggConfig(agg) {
  return Boolean(agg.buckets);
}
export var getDateHistogramBucketAgg = function getDateHistogramBucketAgg(_ref) {
  var calculateBounds = _ref.calculateBounds,
      uiSettings = _ref.uiSettings;
  return new BucketAggType({
    name: BUCKET_TYPES.DATE_HISTOGRAM,
    title: i18n.translate('data.search.aggs.buckets.dateHistogramTitle', {
      defaultMessage: 'Date Histogram'
    }),
    ordered: {
      date: true
    },
    makeLabel: function makeLabel(agg) {
      var output = {};

      if (this.params) {
        output = writeParams(this.params, agg);
      }

      var field = agg.getFieldDisplayName();
      return i18n.translate('data.search.aggs.buckets.dateHistogramLabel', {
        defaultMessage: '{fieldName} per {intervalDescription}',
        values: {
          fieldName: field,
          intervalDescription: output.metricScaleText || output.bucketInterval.description
        }
      });
    },
    createFilter: createFilterDateHistogram,
    decorateAggConfig: function decorateAggConfig() {
      var buckets;
      return {
        buckets: {
          configurable: true,
          get: function get() {
            if (buckets) return buckets;
            buckets = new TimeBuckets({
              'histogram:maxBars': uiSettings.get(UI_SETTINGS.HISTOGRAM_MAX_BARS),
              'histogram:barTarget': uiSettings.get(UI_SETTINGS.HISTOGRAM_BAR_TARGET),
              dateFormat: uiSettings.get('dateFormat'),
              'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
            });
            updateTimeBuckets(this, calculateBounds, buckets);
            return buckets;
          }
        }
      };
    },
    getSerializedFormat: function getSerializedFormat(agg) {
      return {
        id: 'date',
        params: {
          pattern: agg.buckets.getScaledDateFormat()
        }
      };
    },
    params: [{
      name: 'field',
      type: 'field',
      filterFieldTypes: KBN_FIELD_TYPES.DATE,
      default: function _default(agg) {
        return agg.getIndexPattern().timeFieldName;
      },
      onChange: function onChange(agg) {
        if (get(agg, 'params.interval') === 'auto' && !agg.fieldIsTimeField()) {
          delete agg.params.interval;
        }
      }
    }, {
      name: 'timeRange',
      default: null,
      write: noop
    }, {
      name: 'useNormalizedEsInterval',
      default: true,
      write: noop
    }, {
      name: 'scaleMetricValues',
      default: false,
      write: noop,
      advanced: true
    }, {
      name: 'interval',
      deserialize: function deserialize(state, agg) {
        // For upgrading from 7.0.x to 7.1.x - intervals are now stored as key of options or custom value
        if (state === 'custom') {
          return get(agg, 'params.customInterval');
        }

        var interval = find(intervalOptions, {
          val: state
        }); // For upgrading from 4.0.x to 4.1.x - intervals are now stored as 'y' instead of 'year',
        // but this maps the old values to the new values

        if (!interval && state === 'year') {
          return 'y';
        }

        return state;
      },
      default: 'auto',
      options: intervalOptions,
      write: function write(agg, output, aggs) {
        updateTimeBuckets(agg, calculateBounds);
        var _agg$params = agg.params,
            useNormalizedEsInterval = _agg$params.useNormalizedEsInterval,
            scaleMetricValues = _agg$params.scaleMetricValues;
        var interval = agg.buckets.getInterval(useNormalizedEsInterval);
        output.bucketInterval = interval;

        if (interval.expression === '0ms') {
          // We are hitting this code a couple of times while configuring in editor
          // with an interval of 0ms because the overall time range has not yet been
          // set. Since 0ms is not a valid ES interval, we cannot pass it through dateHistogramInterval
          // below, since it would throw an exception. So in the cases we still have an interval of 0ms
          // here we simply skip the rest of the method and never write an interval into the DSL, since
          // this DSL will anyway not be used before we're passing this code with an actual interval.
          return;
        }

        output.params = _objectSpread(_objectSpread({}, output.params), dateHistogramInterval(interval.expression));
        var scaleMetrics = scaleMetricValues && interval.scaled && interval.scale && interval.scale < 1;

        if (scaleMetrics && aggs) {
          var metrics = aggs.aggs.filter(function (a) {
            return isMetricAggType(a.type);
          });
          var all = every(metrics, function (a) {
            var type = a.type;

            if (isMetricAggType(type)) {
              return type.isScalable();
            }
          });

          if (all) {
            var _interval$preScaled;

            output.metricScale = interval.scale;
            output.metricScaleText = ((_interval$preScaled = interval.preScaled) === null || _interval$preScaled === void 0 ? void 0 : _interval$preScaled.description) || '';
          }
        }
      }
    }, {
      name: 'time_zone',
      default: undefined,
      // We don't ever want this parameter to be serialized out (when saving or to URLs)
      // since we do all the logic handling it "on the fly" in the `write` method, to prevent
      // time_zones being persisted into saved_objects
      serialize: noop,
      write: function write(agg, output) {
        // If a time_zone has been set explicitly always prefer this.
        var tz = agg.params.time_zone;

        if (!tz && agg.params.field) {
          // If a field has been configured check the index pattern's typeMeta if a date_histogram on that
          // field requires a specific time_zone
          tz = get(agg.getIndexPattern(), ['typeMeta', 'aggs', 'date_histogram', agg.params.field.name, 'time_zone']);
        }

        if (!tz) {
          // If the index pattern typeMeta data, didn't had a time zone assigned for the selected field use the configured tz
          var isDefaultTimezone = uiSettings.isDefault('dateFormat:tz');
          var detectedTimezone = moment.tz.guess();
          var tzOffset = moment().format('Z');
          tz = isDefaultTimezone ? detectedTimezone || tzOffset : uiSettings.get('dateFormat:tz');
        }

        output.params.time_zone = tz;
      }
    }, {
      name: 'drop_partials',
      default: false,
      write: noop,
      shouldShow: function shouldShow(agg) {
        var field = agg.params.field;
        return field && field.name && field.name === agg.getIndexPattern().timeFieldName;
      }
    }, {
      name: 'format'
    }, {
      name: 'min_doc_count',
      default: 1
    }, {
      name: 'extended_bounds',
      default: {},
      write: function write(agg, output) {
        var val = agg.params.extended_bounds;

        if (val.min != null || val.max != null) {
          output.params.extended_bounds = {
            min: moment(val.min).valueOf(),
            max: moment(val.max).valueOf()
          };
          return;
        }
      }
    }]
  });
};