function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { last } from 'lodash';
import moment from 'moment';
import { esFilters } from '../../../public';
import { getIndexPatterns } from '../../../public/services';
import { deserializeAggConfig } from '../../search/expressions/utils';
export function createFiltersFromRangeSelectAction(_x) {
  return _createFiltersFromRangeSelectAction.apply(this, arguments);
}

function _createFiltersFromRangeSelectAction() {
  _createFiltersFromRangeSelectAction = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(event) {
    var column, indexPattern, aggConfig, field, min, max, isDate, range;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            column = event.table.columns[event.column];

            if (!(!column || !column.meta)) {
              _context.next = 3;
              break;
            }

            return _context.abrupt("return", []);

          case 3:
            _context.next = 5;
            return getIndexPatterns().get(column.meta.indexPatternId);

          case 5:
            indexPattern = _context.sent;
            aggConfig = deserializeAggConfig(_objectSpread(_objectSpread({}, column.meta), {}, {
              indexPattern: indexPattern
            }));
            field = aggConfig.params.field;

            if (!(!field || event.range.length <= 1)) {
              _context.next = 10;
              break;
            }

            return _context.abrupt("return", []);

          case 10:
            min = event.range[0];
            max = last(event.range);

            if (!(min === max)) {
              _context.next = 14;
              break;
            }

            return _context.abrupt("return", []);

          case 14:
            isDate = field.type === 'date';
            range = {
              gte: isDate ? moment(min).toISOString() : min,
              lt: isDate ? moment(max).toISOString() : max
            };

            if (isDate) {
              range.format = 'strict_date_optional_time';
            }

            return _context.abrupt("return", esFilters.mapAndFlattenFilters([esFilters.buildRangeFilter(field, range, indexPattern)]));

          case 18:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _createFiltersFromRangeSelectAction.apply(this, arguments);
}