function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { PanelNotFoundError } from '../../../embeddable_plugin';
import { DASHBOARD_GRID_COLUMN_COUNT } from '..';
// Look for the smallest y and x value where the default panel will fit.
export function findTopLeftMostOpenSpace(_ref) {
  var width = _ref.width,
      height = _ref.height,
      currentPanels = _ref.currentPanels;
  var maxY = -1;
  var currentPanelsArray = Object.values(currentPanels);
  currentPanelsArray.forEach(function (panel) {
    maxY = Math.max(panel.gridData.y + panel.gridData.h, maxY);
  }); // Handle case of empty grid.

  if (maxY < 0) {
    return {
      x: 0,
      y: 0,
      w: width,
      h: height
    };
  }

  var grid = new Array(maxY);

  for (var y = 0; y < maxY; y++) {
    grid[y] = new Array(DASHBOARD_GRID_COLUMN_COUNT).fill(0);
  }

  currentPanelsArray.forEach(function (panel) {
    for (var x = panel.gridData.x; x < panel.gridData.x + panel.gridData.w; x++) {
      for (var _y = panel.gridData.y; _y < panel.gridData.y + panel.gridData.h; _y++) {
        var row = grid[_y];

        if (row === undefined) {
          throw new Error("Attempted to access a row that doesn't exist at ".concat(_y, " for panel ").concat(JSON.stringify(panel)));
        }

        grid[_y][x] = 1;
      }
    }
  });

  for (var _y2 = 0; _y2 < maxY; _y2++) {
    for (var x = 0; x < DASHBOARD_GRID_COLUMN_COUNT; x++) {
      if (grid[_y2][x] === 1) {
        // Space is filled
        continue;
      } else {
        for (var h = _y2; h < Math.min(_y2 + height, maxY); h++) {
          for (var w = x; w < Math.min(x + width, DASHBOARD_GRID_COLUMN_COUNT); w++) {
            var spaceIsEmpty = grid[h][w] === 0;
            var fitsPanelWidth = w === x + width - 1; // If the panel is taller than any other panel in the current grid, it can still fit in the space, hence
            // we check the minimum of maxY and the panel height.

            var fitsPanelHeight = h === Math.min(_y2 + height - 1, maxY - 1);

            if (spaceIsEmpty && fitsPanelWidth && fitsPanelHeight) {
              // Found space
              return {
                x: x,
                y: _y2,
                w: width,
                h: height
              };
            } else if (grid[h][w] === 1) {
              // x, y spot doesn't work, break.
              break;
            }
          }
        }
      }
    }
  }

  return {
    x: 0,
    y: maxY,
    w: width,
    h: height
  };
}

/**
 * Compare grid data by an ending y coordinate. Grid data with a smaller ending y coordinate
 * comes first.
 * @param a
 * @param b
 */
function comparePanels(a, b) {
  if (a.y + a.h < b.y + b.h) {
    return -1;
  }

  if (a.y + a.h > b.y + b.h) {
    return 1;
  } // a.y === b.y


  if (a.x + a.w <= b.x + b.w) {
    return -1;
  }

  return 1;
}

export function placePanelBeside(_ref2) {
  var width = _ref2.width,
      height = _ref2.height,
      currentPanels = _ref2.currentPanels,
      placeBesideId = _ref2.placeBesideId;
  var panelToPlaceBeside = currentPanels[placeBesideId];

  if (!panelToPlaceBeside) {
    throw new PanelNotFoundError();
  }

  var beside = panelToPlaceBeside.gridData;
  var otherPanels = [];

  _.forOwn(currentPanels, function (panel, key) {
    otherPanels.push(panel.gridData);
  });

  var possiblePlacementDirections = [{
    grid: {
      x: beside.x + beside.w,
      y: beside.y,
      w: width,
      h: height
    },
    fits: true
  }, // right
  {
    grid: {
      x: 0,
      y: beside.y + beside.h,
      w: width,
      h: height
    },
    fits: true
  }, // left side of next row
  {
    grid: {
      x: beside.x,
      y: beside.y + beside.h,
      w: width,
      h: height
    },
    fits: true
  } // bottom
  ]; // first, we check if there is place around the current panel

  var _loop = function _loop() {
    var direction = _possiblePlacementDir[_i];

    if (direction.grid.x >= 0 && direction.grid.x + direction.grid.w <= DASHBOARD_GRID_COLUMN_COUNT && direction.grid.y >= 0) {
      var intersection = otherPanels.some(function (currentPanelGrid) {
        return direction.grid.x + direction.grid.w > currentPanelGrid.x && direction.grid.x < currentPanelGrid.x + currentPanelGrid.w && direction.grid.y < currentPanelGrid.y + currentPanelGrid.h && direction.grid.y + direction.grid.h > currentPanelGrid.y;
      });

      if (!intersection) {
        return {
          v: direction.grid
        };
      }
    } else {
      direction.fits = false;
    }
  };

  for (var _i = 0, _possiblePlacementDir = possiblePlacementDirections; _i < _possiblePlacementDir.length; _i++) {
    var _ret = _loop();

    if (_typeof(_ret) === "object") return _ret.v;
  } // if we get here that means there is no blank space around the panel we are placing beside. This means it's time to mess up the dashboard's groove. Fun!

  /**
   * 1. sort the panels in the grid
   * 2. place the cloned panel to the bottom
   * 3. reposition the panels after the cloned panel in the grid
   */


  var grid = otherPanels.sort(comparePanels);
  var position = 0;

  for (position; position < grid.length; position++) {
    if (beside.i === grid[position].i) {
      break;
    }
  }

  var bottomPlacement = possiblePlacementDirections[2]; // place to the bottom and move all other panels

  var originalPositionInTheGrid = grid[position + 1].i;
  var diff = bottomPlacement.grid.y + bottomPlacement.grid.h - currentPanels[originalPositionInTheGrid].gridData.y;

  for (var j = position + 1; j < grid.length; j++) {
    originalPositionInTheGrid = grid[j].i;

    var movedPanel = _.cloneDeep(currentPanels[originalPositionInTheGrid]);

    movedPanel.gridData.y = movedPanel.gridData.y + diff;
    currentPanels[originalPositionInTheGrid] = movedPanel;
  }

  return bottomPlacement.grid;
}