function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { DashboardContainer } from './dashboard_container';
import { DASHBOARD_CONTAINER_TYPE } from './dashboard_constants';
export var DashboardContainerFactoryDefinition = /*#__PURE__*/function () {
  function DashboardContainerFactoryDefinition(getStartServices, getHistory) {
    var _this = this;

    _classCallCheck(this, DashboardContainerFactoryDefinition);

    this.getStartServices = getStartServices;
    this.getHistory = getHistory;

    _defineProperty(this, "isContainerType", true);

    _defineProperty(this, "type", DASHBOARD_CONTAINER_TYPE);

    _defineProperty(this, "isEditable", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var _yield$_this$getStart, capabilities;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return _this.getStartServices();

            case 2:
              _yield$_this$getStart = _context.sent;
              capabilities = _yield$_this$getStart.capabilities;
              return _context.abrupt("return", !!capabilities.createNew && !!capabilities.showWriteControls);

            case 5:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(this, "getDisplayName", function () {
      return i18n.translate('dashboard.factory.displayName', {
        defaultMessage: 'dashboard'
      });
    });

    _defineProperty(this, "create", /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(initialInput, parent) {
        var services, stateTransfer;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return _this.getStartServices();

              case 2:
                services = _context2.sent;
                stateTransfer = services.embeddable.getStateTransfer(_this.getHistory());
                return _context2.abrupt("return", new DashboardContainer(initialInput, services, stateTransfer, parent));

              case 5:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      return function (_x, _x2) {
        return _ref2.apply(this, arguments);
      };
    }());
  }

  _createClass(DashboardContainerFactoryDefinition, [{
    key: "getDefaultInput",
    value: function getDefaultInput() {
      return {
        panels: {},
        isEmbeddedExternally: false,
        isFullScreenMode: false,
        useMargins: true
      };
    }
  }]);

  return DashboardContainerFactoryDefinition;
}();