function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _, { uniqBy } from 'lodash';
import { i18n } from '@kbn/i18n';
import { EUI_MODAL_CANCEL_BUTTON, EuiCheckboxGroup } from '@elastic/eui';
import React, { useState } from 'react';
import ReactDOM from 'react-dom';
import angular from 'angular';
import { Observable, pipe, Subscription } from 'rxjs';
import { filter, map, mapTo, startWith, switchMap } from 'rxjs/operators';
import { DashboardEmptyScreen } from './dashboard_empty_screen';
import { connectToQueryState, esFilters, syncQueryStateWithUrl, UI_SETTINGS } from '../../../data/public';
import { getSavedObjectFinder, showSaveModal } from '../../../saved_objects/public';
import { DASHBOARD_CONTAINER_TYPE } from './embeddable';
import { EmbeddableFactoryNotFoundError, isErrorEmbeddable, openAddPanelFlyout, ViewMode } from '../../../embeddable/public';
import { showOptionsPopover } from './top_nav/show_options_popover';
import { DashboardSaveModal } from './top_nav/save_modal';
import { showCloneModal } from './top_nav/show_clone_modal';
import { saveDashboard } from './lib';
import { DashboardStateManager } from './dashboard_state_manager';
import { createDashboardEditUrl, DashboardConstants } from '../dashboard_constants';
import { getTopNavConfig } from './top_nav/get_top_nav_config';
import { TopNavIds } from './top_nav/top_nav_ids';
import { getDashboardTitle } from './dashboard_strings';
import { convertSavedDashboardPanelToPanelState } from './lib/embeddable_saved_object_converters';
import { unhashUrl } from '../../../kibana_utils/public';
import { addFatalError, migrateLegacyQuery, subscribeWithScope } from '../../../kibana_legacy/public';
var UrlParams;

(function (UrlParams) {
  UrlParams["SHOW_TOP_MENU"] = "show-top-menu";
  UrlParams["SHOW_QUERY_INPUT"] = "show-query-input";
  UrlParams["SHOW_TIME_FILTER"] = "show-time-filter";
  UrlParams["SHOW_FILTER_BAR"] = "show-filter-bar";
  UrlParams["HIDE_FILTER_BAR"] = "hide-filter-bar";
})(UrlParams || (UrlParams = {}));

export var DashboardAppController = // Part of the exposed plugin API - do not remove without careful consideration.
function DashboardAppController(_ref) {
  var _this = this;

  var pluginInitializerContext = _ref.pluginInitializerContext,
      $scope = _ref.$scope,
      $route = _ref.$route,
      $routeParams = _ref.$routeParams,
      dashboardConfig = _ref.dashboardConfig,
      localStorage = _ref.localStorage,
      indexPatterns = _ref.indexPatterns,
      savedQueryService = _ref.savedQueryService,
      embeddable = _ref.embeddable,
      share = _ref.share,
      dashboardCapabilities = _ref.dashboardCapabilities,
      scopedHistory = _ref.scopedHistory,
      _ref$embeddableCapabi = _ref.embeddableCapabilities,
      visualizeCapabilities = _ref$embeddableCapabi.visualizeCapabilities,
      mapsCapabilities = _ref$embeddableCapabi.mapsCapabilities,
      queryService = _ref.data.query,
      _ref$core = _ref.core,
      notifications = _ref$core.notifications,
      overlays = _ref$core.overlays,
      chrome = _ref$core.chrome,
      injectedMetadata = _ref$core.injectedMetadata,
      fatalErrors = _ref$core.fatalErrors,
      uiSettings = _ref$core.uiSettings,
      savedObjects = _ref$core.savedObjects,
      http = _ref$core.http,
      i18nStart = _ref$core.i18n,
      history = _ref.history,
      kbnUrlStateStorage = _ref.kbnUrlStateStorage,
      usageCollection = _ref.usageCollection,
      navigation = _ref.navigation;

  _classCallCheck(this, DashboardAppController);

  _defineProperty(this, "appStatus", void 0);

  var filterManager = queryService.filterManager;
  var queryFilter = filterManager;
  var timefilter = queryService.timefilter.timefilter;
  var isEmbeddedExternally = Boolean($routeParams.embed); // url param rules should only apply when embedded (e.g. url?embed=true)

  var shouldForceDisplay = function shouldForceDisplay(param) {
    return isEmbeddedExternally && Boolean($routeParams[param]);
  };

  var forceShowTopNavMenu = shouldForceDisplay(UrlParams.SHOW_TOP_MENU);
  var forceShowQueryInput = shouldForceDisplay(UrlParams.SHOW_QUERY_INPUT);
  var forceShowDatePicker = shouldForceDisplay(UrlParams.SHOW_TIME_FILTER);
  var forceHideFilterBar = shouldForceDisplay(UrlParams.HIDE_FILTER_BAR);
  var lastReloadRequestTime = 0;
  var dash = $scope.dash = $route.current.locals.dash;

  if (dash.id) {
    chrome.docTitle.change(dash.title);
  }

  var incomingEmbeddable = embeddable.getStateTransfer(scopedHistory()).getIncomingEmbeddablePackage();
  var dashboardStateManager = new DashboardStateManager({
    savedDashboard: dash,
    hideWriteControls: dashboardConfig.getHideWriteControls(),
    kibanaVersion: pluginInitializerContext.env.packageInfo.version,
    kbnUrlStateStorage: kbnUrlStateStorage,
    history: history,
    usageCollection: usageCollection
  }); // sync initial app filters from state to filterManager
  // if there is an existing similar global filter, then leave it as global

  filterManager.setAppFilters(_.cloneDeep(dashboardStateManager.appState.filters)); // setup syncing of app filters between appState and filterManager

  var stopSyncingAppFilters = connectToQueryState(queryService, {
    set: function set(_ref2) {
      var filters = _ref2.filters;
      return dashboardStateManager.setFilters(filters || []);
    },
    get: function get() {
      return {
        filters: dashboardStateManager.appState.filters
      };
    },
    state$: dashboardStateManager.appState$.pipe(map(function (state) {
      return {
        filters: state.filters
      };
    }))
  }, {
    filters: esFilters.FilterStateStore.APP_STATE
  }); // The hash check is so we only update the time filter on dashboard open, not during
  // normal cross app navigation.

  if (dashboardStateManager.getIsTimeSavedWithDashboard()) {
    var initialGlobalStateInUrl = kbnUrlStateStorage.get('_g');

    if (!(initialGlobalStateInUrl === null || initialGlobalStateInUrl === void 0 ? void 0 : initialGlobalStateInUrl.time)) {
      dashboardStateManager.syncTimefilterWithDashboardTime(timefilter);
    }

    if (!(initialGlobalStateInUrl === null || initialGlobalStateInUrl === void 0 ? void 0 : initialGlobalStateInUrl.refreshInterval)) {
      dashboardStateManager.syncTimefilterWithDashboardRefreshInterval(timefilter);
    }
  } // starts syncing `_g` portion of url with query services
  // it is important to start this syncing after `dashboardStateManager.syncTimefilterWithDashboard(timefilter);` above is run,
  // otherwise it will case redundant browser history records


  var _syncQueryStateWithUr = syncQueryStateWithUrl(queryService, kbnUrlStateStorage),
      stopSyncingQueryServiceStateWithUrl = _syncQueryStateWithUr.stop; // starts syncing `_a` portion of url


  dashboardStateManager.startStateSyncing();
  $scope.showSaveQuery = dashboardCapabilities.saveQuery;

  var getShouldShowEditHelp = function getShouldShowEditHelp() {
    return !dashboardStateManager.getPanels().length && dashboardStateManager.getIsEditMode() && !dashboardConfig.getHideWriteControls();
  };

  var getShouldShowViewHelp = function getShouldShowViewHelp() {
    return !dashboardStateManager.getPanels().length && dashboardStateManager.getIsViewMode() && !dashboardConfig.getHideWriteControls();
  };

  var shouldShowUnauthorizedEmptyState = function shouldShowUnauthorizedEmptyState() {
    var readonlyMode = !dashboardStateManager.getPanels().length && !getShouldShowEditHelp() && !getShouldShowViewHelp() && dashboardConfig.getHideWriteControls();
    var userHasNoPermissions = !dashboardStateManager.getPanels().length && !visualizeCapabilities.save && !mapsCapabilities.save;
    return readonlyMode || userHasNoPermissions;
  };

  var addVisualization = function addVisualization() {
    navActions[TopNavIds.VISUALIZE]();
  };

  function getDashboardIndexPatterns(container) {
    var panelIndexPatterns = [];
    Object.values(container.getChildIds()).forEach(function (id) {
      var _panelIndexPatterns;

      var embeddableInstance = container.getChild(id);
      if (isErrorEmbeddable(embeddableInstance)) return;
      var embeddableIndexPatterns = embeddableInstance.getOutput().indexPatterns;
      if (!embeddableIndexPatterns) return;

      (_panelIndexPatterns = panelIndexPatterns).push.apply(_panelIndexPatterns, _toConsumableArray(embeddableIndexPatterns));
    });
    panelIndexPatterns = uniqBy(panelIndexPatterns, 'id');
    return panelIndexPatterns;
  }

  var updateIndexPatternsOperator = pipe(filter(function (container) {
    return !!container && !isErrorEmbeddable(container);
  }), map(getDashboardIndexPatterns), // using switchMap for previous task cancellation
  switchMap(function (panelIndexPatterns) {
    return new Observable(function (observer) {
      if (panelIndexPatterns && panelIndexPatterns.length > 0) {
        $scope.$evalAsync(function () {
          if (observer.closed) return;
          $scope.indexPatterns = panelIndexPatterns;
          observer.complete();
        });
      } else {
        indexPatterns.getDefault().then(function (defaultIndexPattern) {
          if (observer.closed) return;
          $scope.$evalAsync(function () {
            if (observer.closed) return;
            $scope.indexPatterns = [defaultIndexPattern];
            observer.complete();
          });
        });
      }
    });
  }));

  var getEmptyScreenProps = function getEmptyScreenProps(shouldShowEditHelp, isEmptyInReadOnlyMode) {
    var emptyScreenProps = {
      onLinkClick: shouldShowEditHelp ? $scope.showAddPanel : $scope.enterEditMode,
      showLinkToVisualize: shouldShowEditHelp,
      uiSettings: uiSettings,
      http: http
    };

    if (shouldShowEditHelp) {
      emptyScreenProps.onVisualizeClick = addVisualization;
    }

    if (isEmptyInReadOnlyMode) {
      emptyScreenProps.isReadonlyMode = true;
    }

    return emptyScreenProps;
  };

  var getDashboardInput = function getDashboardInput() {
    var embeddablesMap = {};
    dashboardStateManager.getPanels().forEach(function (panel) {
      embeddablesMap[panel.panelIndex] = convertSavedDashboardPanelToPanelState(panel);
    });
    var expandedPanelId;

    if (dashboardContainer && !isErrorEmbeddable(dashboardContainer)) {
      expandedPanelId = dashboardContainer.getInput().expandedPanelId;
    }

    var shouldShowEditHelp = getShouldShowEditHelp();
    var shouldShowViewHelp = getShouldShowViewHelp();
    var isEmptyInReadonlyMode = shouldShowUnauthorizedEmptyState();
    return {
      id: dashboardStateManager.savedDashboard.id || '',
      filters: queryFilter.getFilters(),
      hidePanelTitles: dashboardStateManager.getHidePanelTitles(),
      query: $scope.model.query,
      timeRange: _objectSpread({}, _.cloneDeep(timefilter.getTime())),
      refreshConfig: timefilter.getRefreshInterval(),
      viewMode: dashboardStateManager.getViewMode(),
      panels: embeddablesMap,
      isFullScreenMode: dashboardStateManager.getFullScreenMode(),
      isEmbeddedExternally: isEmbeddedExternally,
      isEmptyState: shouldShowEditHelp || shouldShowViewHelp || isEmptyInReadonlyMode,
      useMargins: dashboardStateManager.getUseMargins(),
      lastReloadRequestTime: lastReloadRequestTime,
      title: dashboardStateManager.getTitle(),
      description: dashboardStateManager.getDescription(),
      expandedPanelId: expandedPanelId
    };
  };

  var updateState = function updateState() {
    // Following the "best practice" of always have a '.' in your ng-models –
    // https://github.com/angular/angular.js/wiki/Understanding-Scopes
    $scope.model = {
      query: dashboardStateManager.getQuery(),
      filters: queryFilter.getFilters(),
      timeRestore: dashboardStateManager.getTimeRestore(),
      title: dashboardStateManager.getTitle(),
      description: dashboardStateManager.getDescription(),
      timeRange: timefilter.getTime(),
      refreshInterval: timefilter.getRefreshInterval()
    };
    $scope.panels = dashboardStateManager.getPanels();
  };

  updateState();
  var dashboardContainer;
  var inputSubscription;
  var outputSubscription;
  var dashboardDom = document.getElementById('dashboardViewport');
  var dashboardFactory = embeddable.getEmbeddableFactory(DASHBOARD_CONTAINER_TYPE);

  if (dashboardFactory) {
    dashboardFactory.create(getDashboardInput()).then(function (container) {
      if (container && !isErrorEmbeddable(container)) {
        dashboardContainer = container;

        dashboardContainer.renderEmpty = function () {
          var shouldShowEditHelp = getShouldShowEditHelp();
          var shouldShowViewHelp = getShouldShowViewHelp();
          var isEmptyInReadOnlyMode = shouldShowUnauthorizedEmptyState();
          var isEmptyState = shouldShowEditHelp || shouldShowViewHelp || isEmptyInReadOnlyMode;
          return isEmptyState ? /*#__PURE__*/React.createElement(DashboardEmptyScreen, getEmptyScreenProps(shouldShowEditHelp, isEmptyInReadOnlyMode)) : null;
        };

        outputSubscription = new Subscription();
        outputSubscription.add(dashboardContainer.getOutput$().pipe(mapTo(dashboardContainer), startWith(dashboardContainer), // to trigger initial index pattern update
        updateIndexPatternsOperator).subscribe());
        inputSubscription = dashboardContainer.getInput$().subscribe(function () {
          var dirty = false; // This has to be first because handleDashboardContainerChanges causes
          // appState.save which will cause refreshDashboardContainer to be called.

          if (!esFilters.compareFilters(container.getInput().filters, queryFilter.getFilters(), esFilters.COMPARE_ALL_OPTIONS)) {
            // Add filters modifies the object passed to it, hence the clone deep.
            queryFilter.addFilters(_.cloneDeep(container.getInput().filters));
            dashboardStateManager.applyFilters($scope.model.query, container.getInput().filters);
            dirty = true;
          }

          dashboardStateManager.handleDashboardContainerChanges(container);
          $scope.$evalAsync(function () {
            if (dirty) {
              updateState();
            }
          });
        });
        dashboardStateManager.registerChangeListener(function () {
          // we aren't checking dirty state because there are changes the container needs to know about
          // that won't make the dashboard "dirty" - like a view mode change.
          refreshDashboardContainer();
        });

        if (incomingEmbeddable) {
          if ('id' in incomingEmbeddable) {
            container.addOrUpdateEmbeddable(incomingEmbeddable.type, {
              savedObjectId: incomingEmbeddable.id
            });
          } else if ('input' in incomingEmbeddable) {
            var input = incomingEmbeddable.input;
            delete input.id;
            var explicitInput = {
              savedVis: input
            };
            container.addOrUpdateEmbeddable(incomingEmbeddable.type, explicitInput);
          }
        }
      }

      if (dashboardDom && container) {
        container.render(dashboardDom);
      }
    });
  } // Part of the exposed plugin API - do not remove without careful consideration.


  this.appStatus = {
    dirty: !dash.id
  };
  dashboardStateManager.registerChangeListener(function (status) {
    _this.appStatus.dirty = status.dirty || !dash.id;
    updateState();
  });
  dashboardStateManager.applyFilters(dashboardStateManager.getQuery() || {
    query: '',
    language: localStorage.get('kibana.userQueryLanguage') || uiSettings.get(UI_SETTINGS.SEARCH_QUERY_LANGUAGE)
  }, queryFilter.getFilters());
  timefilter.disableTimeRangeSelector();
  timefilter.disableAutoRefreshSelector();

  var landingPageUrl = function landingPageUrl() {
    return "#".concat(DashboardConstants.LANDING_PAGE_PATH);
  };

  var getDashTitle = function getDashTitle() {
    return getDashboardTitle(dashboardStateManager.getTitle(), dashboardStateManager.getViewMode(), dashboardStateManager.getIsDirty(timefilter), dashboardStateManager.isNew());
  }; // Push breadcrumbs to new header navigation


  var updateBreadcrumbs = function updateBreadcrumbs() {
    chrome.setBreadcrumbs([{
      text: i18n.translate('dashboard.dashboardAppBreadcrumbsTitle', {
        defaultMessage: 'Dashboard'
      }),
      href: landingPageUrl()
    }, {
      text: getDashTitle()
    }]);
  };

  updateBreadcrumbs();
  dashboardStateManager.registerChangeListener(updateBreadcrumbs);

  var getChangesFromAppStateForContainerState = function getChangesFromAppStateForContainerState() {
    var appStateDashboardInput = getDashboardInput();

    if (!dashboardContainer || isErrorEmbeddable(dashboardContainer)) {
      return appStateDashboardInput;
    }

    var containerInput = dashboardContainer.getInput();
    var differences = {}; // Filters shouldn't  be compared using regular isEqual

    if (!esFilters.compareFilters(containerInput.filters, appStateDashboardInput.filters, esFilters.COMPARE_ALL_OPTIONS)) {
      differences.filters = appStateDashboardInput.filters;
    }

    Object.keys(_.omit(containerInput, ['filters'])).forEach(function (key) {
      var containerValue = containerInput[key];
      var appStateValue = appStateDashboardInput[key];

      if (!_.isEqual(containerValue, appStateValue)) {
        differences[key] = appStateValue;
      }
    }); // cloneDeep hack is needed, as there are multiple place, where container's input mutated,
    // but values from appStateValue are deeply frozen, as they can't be mutated directly

    return Object.values(differences).length === 0 ? undefined : _.cloneDeep(differences);
  };

  var refreshDashboardContainer = function refreshDashboardContainer() {
    var changes = getChangesFromAppStateForContainerState();

    if (changes && dashboardContainer) {
      dashboardContainer.updateInput(changes);
    }
  };

  $scope.updateQueryAndFetch = function (_ref3) {
    var query = _ref3.query,
        dateRange = _ref3.dateRange;

    if (dateRange) {
      timefilter.setTime(dateRange);
    }

    var oldQuery = $scope.model.query;

    if (_.isEqual(oldQuery, query)) {
      // The user can still request a reload in the query bar, even if the
      // query is the same, and in that case, we have to explicitly ask for
      // a reload, since no state changes will cause it.
      lastReloadRequestTime = new Date().getTime();
      refreshDashboardContainer();
    } else {
      $scope.model.query = query;
      dashboardStateManager.applyFilters($scope.model.query, $scope.model.filters);
    }
  };

  var updateStateFromSavedQuery = function updateStateFromSavedQuery(savedQuery) {
    var allFilters = filterManager.getFilters();
    dashboardStateManager.applyFilters(savedQuery.attributes.query, allFilters);

    if (savedQuery.attributes.timefilter) {
      timefilter.setTime({
        from: savedQuery.attributes.timefilter.from,
        to: savedQuery.attributes.timefilter.to
      });

      if (savedQuery.attributes.timefilter.refreshInterval) {
        timefilter.setRefreshInterval(savedQuery.attributes.timefilter.refreshInterval);
      }
    } // Making this method sync broke the updates.
    // Temporary fix, until we fix the complex state in this file.


    setTimeout(function () {
      queryFilter.setFilters(allFilters);
    }, 0);
  };

  $scope.$watch('savedQuery', function (newSavedQuery) {
    if (!newSavedQuery) return;
    dashboardStateManager.setSavedQueryId(newSavedQuery.id);
    updateStateFromSavedQuery(newSavedQuery);
  });
  $scope.$watch(function () {
    return dashboardStateManager.getSavedQueryId();
  }, function (newSavedQueryId) {
    if (!newSavedQueryId) {
      $scope.savedQuery = undefined;
      return;
    }

    if (!$scope.savedQuery || newSavedQueryId !== $scope.savedQuery.id) {
      savedQueryService.getSavedQuery(newSavedQueryId).then(function (savedQuery) {
        $scope.$evalAsync(function () {
          $scope.savedQuery = savedQuery;
          updateStateFromSavedQuery(savedQuery);
        });
      });
    }
  });
  $scope.indexPatterns = [];
  $scope.$watch('model.query', function (newQuery) {
    var query = migrateLegacyQuery(newQuery);
    $scope.updateQueryAndFetch({
      query: query
    });
  });
  $scope.$watch(function () {
    return dashboardCapabilities.saveQuery;
  }, function (newCapability) {
    $scope.showSaveQuery = newCapability;
  });

  var onSavedQueryIdChange = function onSavedQueryIdChange(savedQueryId) {
    dashboardStateManager.setSavedQueryId(savedQueryId);
  };

  var shouldShowFilterBar = function shouldShowFilterBar(forceHide) {
    return !forceHide && ($scope.model.filters.length > 0 || !dashboardStateManager.getFullScreenMode());
  };

  var shouldShowNavBarComponent = function shouldShowNavBarComponent(forceShow) {
    return (forceShow || $scope.isVisible) && !dashboardStateManager.getFullScreenMode();
  };

  var getNavBarProps = function getNavBarProps() {
    var isFullScreenMode = dashboardStateManager.getFullScreenMode();
    var screenTitle = dashboardStateManager.getTitle();
    var showTopNavMenu = shouldShowNavBarComponent(forceShowTopNavMenu);
    var showQueryInput = shouldShowNavBarComponent(forceShowQueryInput);
    var showDatePicker = shouldShowNavBarComponent(forceShowDatePicker);
    var showQueryBar = showQueryInput || showDatePicker;
    var showFilterBar = shouldShowFilterBar(forceHideFilterBar);
    var showSearchBar = showQueryBar || showFilterBar;
    return {
      appName: 'dashboard',
      config: showTopNavMenu ? $scope.topNavMenu : undefined,
      className: isFullScreenMode ? 'kbnTopNavMenu-isFullScreen' : undefined,
      screenTitle: screenTitle,
      showTopNavMenu: showTopNavMenu,
      showSearchBar: showSearchBar,
      showQueryBar: showQueryBar,
      showQueryInput: showQueryInput,
      showDatePicker: showDatePicker,
      showFilterBar: showFilterBar,
      indexPatterns: $scope.indexPatterns,
      showSaveQuery: $scope.showSaveQuery,
      query: $scope.model.query,
      savedQuery: $scope.savedQuery,
      onSavedQueryIdChange: onSavedQueryIdChange,
      savedQueryId: dashboardStateManager.getSavedQueryId(),
      useDefaultBehaviors: true,
      onQuerySubmit: function onQuerySubmit(payload) {
        if (!payload.query) {
          $scope.updateQueryAndFetch({
            query: $scope.model.query,
            dateRange: payload.dateRange
          });
        } else {
          $scope.updateQueryAndFetch({
            query: payload.query,
            dateRange: payload.dateRange
          });
        }
      }
    };
  };

  var dashboardNavBar = document.getElementById('dashboardChrome');

  var updateNavBar = function updateNavBar() {
    ReactDOM.render( /*#__PURE__*/React.createElement(navigation.ui.TopNavMenu, getNavBarProps()), dashboardNavBar);
  };

  var unmountNavBar = function unmountNavBar() {
    if (dashboardNavBar) {
      ReactDOM.unmountComponentAtNode(dashboardNavBar);
    }
  };

  $scope.timefilterSubscriptions$ = new Subscription();
  $scope.timefilterSubscriptions$.add(subscribeWithScope($scope, timefilter.getRefreshIntervalUpdate$(), {
    next: function next() {
      updateState();
      refreshDashboardContainer();
    }
  }, function (error) {
    return addFatalError(fatalErrors, error);
  }));
  $scope.timefilterSubscriptions$.add(subscribeWithScope($scope, timefilter.getTimeUpdate$(), {
    next: function next() {
      updateState();
      refreshDashboardContainer();
    }
  }, function (error) {
    return addFatalError(fatalErrors, error);
  }));

  function updateViewMode(newMode) {
    dashboardStateManager.switchViewMode(newMode);
  }

  var onChangeViewMode = function onChangeViewMode(newMode) {
    var isPageRefresh = newMode === dashboardStateManager.getViewMode();
    var isLeavingEditMode = !isPageRefresh && newMode === ViewMode.VIEW;
    var willLoseChanges = isLeavingEditMode && dashboardStateManager.getIsDirty(timefilter);

    if (!willLoseChanges) {
      updateViewMode(newMode);
      return;
    }

    function revertChangesAndExitEditMode() {
      dashboardStateManager.resetState(); // This is only necessary for new dashboards, which will default to Edit mode.

      updateViewMode(ViewMode.VIEW); // We need to do a hard reset of the timepicker. appState will not reload like
      // it does on 'open' because it's been saved to the url and the getAppState.previouslyStored() check on
      // reload will cause it not to sync.

      if (dashboardStateManager.getIsTimeSavedWithDashboard()) {
        dashboardStateManager.syncTimefilterWithDashboardTime(timefilter);
        dashboardStateManager.syncTimefilterWithDashboardRefreshInterval(timefilter);
      } // Angular's $location skips this update because of history updates from syncState which happen simultaneously
      // when calling kbnUrl.change() angular schedules url update and when angular finally starts to process it,
      // the update is considered outdated and angular skips it
      // so have to use implementation of dashboardStateManager.changeDashboardUrl, which workarounds those issues


      dashboardStateManager.changeDashboardUrl(dash.id ? createDashboardEditUrl(dash.id) : DashboardConstants.CREATE_NEW_DASHBOARD_URL);
    }

    overlays.openConfirm(i18n.translate('dashboard.changeViewModeConfirmModal.discardChangesDescription', {
      defaultMessage: "Once you discard your changes, there's no getting them back."
    }), {
      confirmButtonText: i18n.translate('dashboard.changeViewModeConfirmModal.confirmButtonLabel', {
        defaultMessage: 'Discard changes'
      }),
      cancelButtonText: i18n.translate('dashboard.changeViewModeConfirmModal.cancelButtonLabel', {
        defaultMessage: 'Continue editing'
      }),
      defaultFocusedButton: EUI_MODAL_CANCEL_BUTTON,
      title: i18n.translate('dashboard.changeViewModeConfirmModal.discardChangesTitle', {
        defaultMessage: 'Discard changes to dashboard?'
      })
    }).then(function (isConfirmed) {
      if (isConfirmed) {
        revertChangesAndExitEditMode();
      }
    });
    updateNavBar();
  };
  /**
   * Saves the dashboard.
   *
   * @param {object} [saveOptions={}]
   * @property {boolean} [saveOptions.confirmOverwrite=false] - If true, attempts to create the source so it
   * can confirm an overwrite if a document with the id already exists.
   * @property {boolean} [saveOptions.isTitleDuplicateConfirmed=false] - If true, save allowed with duplicate title
   * @property {func} [saveOptions.onTitleDuplicate] - function called if duplicate title exists.
   * When not provided, confirm modal will be displayed asking user to confirm or cancel save.
   * @return {Promise}
   * @resolved {String} - The id of the doc
   */


  function save(saveOptions) {
    return saveDashboard(angular.toJson, timefilter, dashboardStateManager, saveOptions).then(function (id) {
      if (id) {
        notifications.toasts.addSuccess({
          title: i18n.translate('dashboard.dashboardWasSavedSuccessMessage', {
            defaultMessage: "Dashboard '{dashTitle}' was saved",
            values: {
              dashTitle: dash.title
            }
          }),
          'data-test-subj': 'saveDashboardSuccess'
        });

        if (dash.id !== $routeParams.id) {
          // Angular's $location skips this update because of history updates from syncState which happen simultaneously
          // when calling kbnUrl.change() angular schedules url update and when angular finally starts to process it,
          // the update is considered outdated and angular skips it
          // so have to use implementation of dashboardStateManager.changeDashboardUrl, which workarounds those issues
          dashboardStateManager.changeDashboardUrl(createDashboardEditUrl(dash.id));
        } else {
          chrome.docTitle.change(dash.lastSavedTitle);
          updateViewMode(ViewMode.VIEW);
        }
      }

      return {
        id: id
      };
    }).catch(function (error) {
      notifications.toasts.addDanger({
        title: i18n.translate('dashboard.dashboardWasNotSavedDangerMessage', {
          defaultMessage: "Dashboard '{dashTitle}' was not saved. Error: {errorMessage}",
          values: {
            dashTitle: dash.title,
            errorMessage: error.message
          }
        }),
        'data-test-subj': 'saveDashboardFailure'
      });
      return {
        error: error
      };
    });
  }

  $scope.showAddPanel = function () {
    dashboardStateManager.setFullScreenMode(false);
    /*
     * Temp solution for triggering menu click.
     * When de-angularizing this code, please call the underlaying action function
     * directly and not via the top nav object.
     **/

    navActions[TopNavIds.ADD_EXISTING]();
  };

  $scope.enterEditMode = function () {
    dashboardStateManager.setFullScreenMode(false);
    /*
     * Temp solution for triggering menu click.
     * When de-angularizing this code, please call the underlaying action function
     * directly and not via the top nav object.
     **/

    navActions[TopNavIds.ENTER_EDIT_MODE]();
  };

  var navActions = {};

  navActions[TopNavIds.FULL_SCREEN] = function () {
    dashboardStateManager.setFullScreenMode(true);
    updateNavBar();
  };

  navActions[TopNavIds.EXIT_EDIT_MODE] = function () {
    return onChangeViewMode(ViewMode.VIEW);
  };

  navActions[TopNavIds.ENTER_EDIT_MODE] = function () {
    return onChangeViewMode(ViewMode.EDIT);
  };

  navActions[TopNavIds.SAVE] = function () {
    var currentTitle = dashboardStateManager.getTitle();
    var currentDescription = dashboardStateManager.getDescription();
    var currentTimeRestore = dashboardStateManager.getTimeRestore();

    var onSave = function onSave(_ref4) {
      var newTitle = _ref4.newTitle,
          newDescription = _ref4.newDescription,
          newCopyOnSave = _ref4.newCopyOnSave,
          newTimeRestore = _ref4.newTimeRestore,
          isTitleDuplicateConfirmed = _ref4.isTitleDuplicateConfirmed,
          onTitleDuplicate = _ref4.onTitleDuplicate;
      dashboardStateManager.setTitle(newTitle);
      dashboardStateManager.setDescription(newDescription);
      dashboardStateManager.savedDashboard.copyOnSave = newCopyOnSave;
      dashboardStateManager.setTimeRestore(newTimeRestore);
      var saveOptions = {
        confirmOverwrite: false,
        isTitleDuplicateConfirmed: isTitleDuplicateConfirmed,
        onTitleDuplicate: onTitleDuplicate
      };
      return save(saveOptions).then(function (response) {
        // If the save wasn't successful, put the original values back.
        if (!response.id) {
          dashboardStateManager.setTitle(currentTitle);
          dashboardStateManager.setDescription(currentDescription);
          dashboardStateManager.setTimeRestore(currentTimeRestore);
        }

        return response;
      });
    };

    var dashboardSaveModal = /*#__PURE__*/React.createElement(DashboardSaveModal, {
      onSave: onSave,
      onClose: function onClose() {},
      title: currentTitle,
      description: currentDescription,
      timeRestore: currentTimeRestore,
      showCopyOnSave: dash.id ? true : false
    });
    showSaveModal(dashboardSaveModal, i18nStart.Context);
  };

  navActions[TopNavIds.CLONE] = function () {
    var currentTitle = dashboardStateManager.getTitle();

    var onClone = function onClone(newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) {
      dashboardStateManager.savedDashboard.copyOnSave = true;
      dashboardStateManager.setTitle(newTitle);
      var saveOptions = {
        confirmOverwrite: false,
        isTitleDuplicateConfirmed: isTitleDuplicateConfirmed,
        onTitleDuplicate: onTitleDuplicate
      };
      return save(saveOptions).then(function (response) {
        // If the save wasn't successful, put the original title back.
        if (response.error) {
          dashboardStateManager.setTitle(currentTitle);
        }

        updateNavBar();
        return response;
      });
    };

    showCloneModal(onClone, currentTitle);
  };

  navActions[TopNavIds.ADD_EXISTING] = function () {
    if (dashboardContainer && !isErrorEmbeddable(dashboardContainer)) {
      openAddPanelFlyout({
        embeddable: dashboardContainer,
        getAllFactories: embeddable.getEmbeddableFactories,
        getFactory: embeddable.getEmbeddableFactory,
        notifications: notifications,
        overlays: overlays,
        SavedObjectFinder: getSavedObjectFinder(savedObjects, uiSettings)
      });
    }
  };

  navActions[TopNavIds.VISUALIZE] = /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
    var type, factory, explicitInput;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            type = 'visualization';
            factory = embeddable.getEmbeddableFactory(type);

            if (factory) {
              _context.next = 4;
              break;
            }

            throw new EmbeddableFactoryNotFoundError(type);

          case 4:
            _context.next = 6;
            return factory.getExplicitInput();

          case 6:
            explicitInput = _context.sent;

            if (!dashboardContainer) {
              _context.next = 10;
              break;
            }

            _context.next = 10;
            return dashboardContainer.addNewEmbeddable(type, explicitInput);

          case 10:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  navActions[TopNavIds.OPTIONS] = function (anchorElement) {
    showOptionsPopover({
      anchorElement: anchorElement,
      useMargins: dashboardStateManager.getUseMargins(),
      onUseMarginsChange: function onUseMarginsChange(isChecked) {
        dashboardStateManager.setUseMargins(isChecked);
      },
      hidePanelTitles: dashboardStateManager.getHidePanelTitles(),
      onHidePanelTitlesChange: function onHidePanelTitlesChange(isChecked) {
        dashboardStateManager.setHidePanelTitles(isChecked);
      }
    });
  };

  if (share) {
    // the share button is only availabale if "share" plugin contract enabled
    navActions[TopNavIds.SHARE] = function (anchorElement) {
      var EmbedUrlParamExtension = function EmbedUrlParamExtension(_ref6) {
        var _useState3;

        var setParamValue = _ref6.setParamValue;

        var _useState = useState((_useState3 = {}, _defineProperty(_useState3, UrlParams.SHOW_TOP_MENU, false), _defineProperty(_useState3, UrlParams.SHOW_QUERY_INPUT, false), _defineProperty(_useState3, UrlParams.SHOW_TIME_FILTER, false), _defineProperty(_useState3, UrlParams.SHOW_FILTER_BAR, true), _useState3)),
            _useState2 = _slicedToArray(_useState, 2),
            urlParamsSelectedMap = _useState2[0],
            setUrlParamsSelectedMap = _useState2[1];

        var checkboxes = [{
          id: UrlParams.SHOW_TOP_MENU,
          label: i18n.translate('dashboard.embedUrlParamExtension.topMenu', {
            defaultMessage: 'Top menu'
          })
        }, {
          id: UrlParams.SHOW_QUERY_INPUT,
          label: i18n.translate('dashboard.embedUrlParamExtension.query', {
            defaultMessage: 'Query'
          })
        }, {
          id: UrlParams.SHOW_TIME_FILTER,
          label: i18n.translate('dashboard.embedUrlParamExtension.timeFilter', {
            defaultMessage: 'Time filter'
          })
        }, {
          id: UrlParams.SHOW_FILTER_BAR,
          label: i18n.translate('dashboard.embedUrlParamExtension.filterBar', {
            defaultMessage: 'Filter bar'
          })
        }];

        var handleChange = function handleChange(param) {
          var _urlParamValues;

          var urlParamsSelectedMapUpdate = _objectSpread(_objectSpread({}, urlParamsSelectedMap), {}, _defineProperty({}, param, !urlParamsSelectedMap[param]));

          setUrlParamsSelectedMap(urlParamsSelectedMapUpdate);
          var urlParamValues = (_urlParamValues = {}, _defineProperty(_urlParamValues, UrlParams.SHOW_TOP_MENU, urlParamsSelectedMap[UrlParams.SHOW_TOP_MENU]), _defineProperty(_urlParamValues, UrlParams.SHOW_QUERY_INPUT, urlParamsSelectedMap[UrlParams.SHOW_QUERY_INPUT]), _defineProperty(_urlParamValues, UrlParams.SHOW_TIME_FILTER, urlParamsSelectedMap[UrlParams.SHOW_TIME_FILTER]), _defineProperty(_urlParamValues, UrlParams.HIDE_FILTER_BAR, !urlParamsSelectedMap[UrlParams.SHOW_FILTER_BAR]), _defineProperty(_urlParamValues, param === UrlParams.SHOW_FILTER_BAR ? UrlParams.HIDE_FILTER_BAR : param, param === UrlParams.SHOW_FILTER_BAR ? urlParamsSelectedMap[UrlParams.SHOW_FILTER_BAR] : !urlParamsSelectedMap[param]), _urlParamValues);
          setParamValue(urlParamValues);
        };

        return /*#__PURE__*/React.createElement(EuiCheckboxGroup, {
          options: checkboxes,
          idToSelectedMap: urlParamsSelectedMap,
          onChange: handleChange,
          legend: {
            children: i18n.translate('dashboard.embedUrlParamExtension.include', {
              defaultMessage: 'Include'
            })
          },
          "data-test-subj": "embedUrlParamExtension"
        });
      };

      share.toggleShareContextMenu({
        anchorElement: anchorElement,
        allowEmbed: true,
        allowShortUrl: !dashboardConfig.getHideWriteControls() || dashboardCapabilities.createShortUrl,
        shareableUrl: unhashUrl(window.location.href),
        objectId: dash.id,
        objectType: 'dashboard',
        sharingData: {
          title: dash.title
        },
        isDirty: dashboardStateManager.getIsDirty(),
        embedUrlParamExtensions: [{
          paramName: 'embed',
          component: EmbedUrlParamExtension
        }]
      });
    };
  }

  updateViewMode(dashboardStateManager.getViewMode()); // update root source when filters update

  var updateSubscription = queryFilter.getUpdates$().subscribe({
    next: function next() {
      $scope.model.filters = queryFilter.getFilters();
      dashboardStateManager.applyFilters($scope.model.query, $scope.model.filters);

      if (dashboardContainer) {
        dashboardContainer.updateInput({
          filters: $scope.model.filters
        });
      }
    }
  });
  var visibleSubscription = chrome.getIsVisible$().subscribe(function (isVisible) {
    $scope.$evalAsync(function () {
      $scope.isVisible = isVisible;
      updateNavBar();
    });
  });
  dashboardStateManager.registerChangeListener(function () {
    // view mode could have changed, so trigger top nav update
    $scope.topNavMenu = getTopNavConfig(dashboardStateManager.getViewMode(), navActions, dashboardConfig.getHideWriteControls());
    updateNavBar();
  });
  $scope.$watch('indexPatterns', function () {
    updateNavBar();
  });
  $scope.$on('$destroy', function () {
    // we have to unmount nav bar manually to make sure all internal subscriptions are unsubscribed
    unmountNavBar();
    updateSubscription.unsubscribe();
    stopSyncingQueryServiceStateWithUrl();
    stopSyncingAppFilters();
    visibleSubscription.unsubscribe();
    $scope.timefilterSubscriptions$.unsubscribe();
    dashboardStateManager.destroy();

    if (inputSubscription) {
      inputSubscription.unsubscribe();
    }

    if (outputSubscription) {
      outputSubscription.unsubscribe();
    }

    if (dashboardContainer) {
      dashboardContainer.destroy();
    }
  });
};