function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { BasePath } from './base_path';
import { AnonymousPathsService } from './anonymous_paths_service';
import { LoadingCountService } from './loading_count_service';
import { Fetch } from './fetch';

/** @internal */
export var HttpService = /*#__PURE__*/function () {
  function HttpService() {
    _classCallCheck(this, HttpService);

    _defineProperty(this, "anonymousPaths", new AnonymousPathsService());

    _defineProperty(this, "loadingCount", new LoadingCountService());

    _defineProperty(this, "service", void 0);
  }

  _createClass(HttpService, [{
    key: "setup",
    value: function setup(_ref) {
      var injectedMetadata = _ref.injectedMetadata,
          fatalErrors = _ref.fatalErrors;
      var kibanaVersion = injectedMetadata.getKibanaVersion();
      var basePath = new BasePath(injectedMetadata.getBasePath(), injectedMetadata.getServerBasePath());
      var fetchService = new Fetch({
        basePath: basePath,
        kibanaVersion: kibanaVersion
      });
      var loadingCount = this.loadingCount.setup({
        fatalErrors: fatalErrors
      });
      loadingCount.addLoadingCountSource(fetchService.getRequestCount$());
      this.service = _objectSpread({
        basePath: basePath,
        anonymousPaths: this.anonymousPaths.setup({
          basePath: basePath
        }),
        intercept: fetchService.intercept.bind(fetchService),
        fetch: fetchService.fetch.bind(fetchService),
        delete: fetchService.delete.bind(fetchService),
        get: fetchService.get.bind(fetchService),
        head: fetchService.head.bind(fetchService),
        options: fetchService.options.bind(fetchService),
        patch: fetchService.patch.bind(fetchService),
        post: fetchService.post.bind(fetchService),
        put: fetchService.put.bind(fetchService)
      }, loadingCount);
      return this.service;
    }
  }, {
    key: "start",
    value: function start() {
      if (!this.service) {
        throw new Error("HttpService#setup() must be called first!");
      }

      return this.service;
    }
  }, {
    key: "stop",
    value: function stop() {
      this.loadingCount.stop();
    }
  }]);

  return HttpService;
}();