/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiEmptyPrompt, EuiPage, EuiPageBody, EuiPageContent } from '@elastic/eui';
import React from 'react';
import { FormattedMessage } from '@kbn/i18n/react';
export var AppNotFound = function AppNotFound() {
  return /*#__PURE__*/React.createElement(EuiPage, {
    style: {
      minHeight: '100%'
    },
    "data-test-subj": "appNotFoundPageContent"
  }, /*#__PURE__*/React.createElement(EuiPageBody, null, /*#__PURE__*/React.createElement(EuiPageContent, {
    verticalPosition: "center",
    horizontalPosition: "center"
  }, /*#__PURE__*/React.createElement(EuiEmptyPrompt, {
    iconType: "alert",
    iconColor: "danger",
    title: /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "core.application.appNotFound.title",
      defaultMessage: "Application Not Found"
    })),
    body: /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "core.application.appNotFound.pageDescription",
      defaultMessage: "No application was found at this URL. Try going back or choosing an app from the menu."
    }))
  }))));
};