"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorReporter = void 0;

var _chalk = _interopRequireDefault(require("chalk"));

var _utils = require("../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ErrorReporter {
  constructor() {
    _defineProperty(this, "errors", []);
  }

  withContext(context) {
    return {
      report: error => this.report(error, context)
    };
  }

  report(error, context) {
    this.errors.push(`${_chalk.default.white.bgRed(' TELEMETRY ERROR ')} Error in ${(0, _utils.normalizePath)(context.name)}\n${error}`);
  }

}

exports.ErrorReporter = ErrorReporter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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