"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkMatchingMapping = checkMatchingMapping;
exports.checkCompatibleTypeDescriptor = checkCompatibleTypeDescriptor;
exports.checkCollectorIntegrity = checkCollectorIntegrity;

var _lodash = require("lodash");

var _utils = require("./utils");

var _manage_schema = require("./manage_schema");

var _serializer = require("./serializer");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function checkMatchingMapping(UsageCollections, esMapping) {
  const generatedMapping = (0, _manage_schema.generateMapping)(UsageCollections);
  return (0, _utils.difference)(generatedMapping, esMapping);
}

function checkCompatibleTypeDescriptor(usageCollections) {
  const results = usageCollections.map(([collectorPath, collectorDetails]) => {
    const typeDescriptorTypes = (0, _utils.flattenKeys)((0, _utils.pickDeep)(collectorDetails.fetch.typeDescriptor, 'kind'));
    const typeDescriptorKinds = (0, _lodash.reduce)(typeDescriptorTypes, (acc, type, key) => {
      try {
        acc[key] = (0, _serializer.kindToDescriptorName)(type);
      } catch (err) {
        throw Error(`Unrecognized type (${key}: ${type}) in ${collectorPath}`);
      }

      return acc;
    }, {});
    const schemaTypes = (0, _utils.flattenKeys)((0, _utils.pickDeep)(collectorDetails.schema.value, 'type'));
    const transformedMappingKinds = (0, _lodash.reduce)(schemaTypes, (acc, type, key) => {
      try {
        acc[key.replace(/.type$/, '.kind')] = (0, _manage_schema.compatibleSchemaTypes)(type);
      } catch (err) {
        throw Error(`Unrecognized type (${key}: ${type}) in ${collectorPath}`);
      }

      return acc;
    }, {});
    const diff = (0, _utils.difference)(typeDescriptorKinds, transformedMappingKinds);
    const diffEntries = Object.entries(diff);

    if (!diffEntries.length) {
      return false;
    }

    return {
      diff,
      collectorPath,
      message: diffEntries.map(([key]) => {
        const interfaceKey = key.replace('.kind', '');

        try {
          const expectedDescriptorType = JSON.stringify(transformedMappingKinds[key], null, 2);
          const actualDescriptorType = JSON.stringify(typeDescriptorKinds[key], null, 2);
          return `incompatible Type key (${collectorDetails.fetch.typeName}.${interfaceKey}): expected (${expectedDescriptorType}) got (${actualDescriptorType}).`;
        } catch (err) {
          throw Error(`Error converting ${key} in ${collectorPath}.\n${err}`);
        }
      })
    };
  });
  return results.filter(entry => entry !== false);
}

function checkCollectorIntegrity(UsageCollections, esMapping) {
  return UsageCollections;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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