"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runTelemetryExtract = runTelemetryExtract;

var _listr = _interopRequireDefault(require("listr"));

var _devUtils = require("@kbn/dev-utils");

var _tasks = require("../tools/tasks");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function runTelemetryExtract() {
  (0, _devUtils.run)(async ({
    flags: {},
    log
  }) => {
    const list = new _listr.default([{
      title: 'Parsing .telemetryrc.json files',
      task: () => new _listr.default((0, _tasks.parseConfigsTask)(), {
        exitOnError: true
      })
    }, {
      title: 'Extracting Telemetry Collectors',
      task: context => new _listr.default((0, _tasks.extractCollectorsTask)(context), {
        exitOnError: true
      })
    }, {
      title: 'Generating Schema files',
      task: context => new _listr.default((0, _tasks.generateSchemasTask)(context), {
        exitOnError: true
      })
    }, {
      title: 'Writing to file',
      task: context => new _listr.default((0, _tasks.writeToFileTask)(context), {
        exitOnError: true
      })
    }]);

    try {
      const context = (0, _tasks.createTaskContext)();
      await list.run(context);
    } catch (error) {
      process.exitCode = 1;

      if (error instanceof _tasks.ErrorReporter) {
        error.errors.forEach(e => log.error(e));
      } else {
        log.error('Unhandled exception');
        log.error(error);
      }
    }

    process.exit();
  }, {
    flags: {
      allowUnexpected: true,
      guessTypesForUnexpectedFlags: true
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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