"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Query", {
  enumerable: true,
  get: function get() {
    return _query2.Query;
  }
});
Object.defineProperty(exports, "Ast", {
  enumerable: true,
  get: function get() {
    return _query2.AST;
  }
});
exports.EuiSearchBar = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _predicate = require("../../services/predicate");

var _flex = require("../flex");

var _search_box = require("./search_box");

var _search_filters = require("./search_filters");

var _query2 = require("./query");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var parseQuery = function parseQuery(query, props) {
  var schema = undefined;

  if (props.box && props.box.schema && (0, _typeof2.default)(props.box.schema) === 'object') {
    schema = props.box.schema;
  }

  var dateFormat = props.dateFormat;
  var parseOptions = {
    schema: schema,
    dateFormat: dateFormat
  };

  if (!query) {
    return _query2.Query.parse('', parseOptions);
  }

  return (0, _predicate.isString)(query) ? _query2.Query.parse(query, parseOptions) : query;
};

var EuiSearchBar =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiSearchBar, _Component);

  function EuiSearchBar(props) {
    var _this;

    (0, _classCallCheck2.default)(this, EuiSearchBar);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(EuiSearchBar).call(this, props));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSearch", function (queryText) {
      try {
        var query = parseQuery(queryText, _this.props);

        _this.notifyControllingParent({
          query: query,
          queryText: queryText,
          error: null
        });

        _this.setState({
          query: query,
          queryText: queryText,
          error: null
        });
      } catch (e) {
        var error = {
          name: e.name,
          message: e.message
        };

        _this.notifyControllingParent({
          query: null,
          queryText: queryText,
          error: error
        });

        _this.setState({
          queryText: queryText,
          error: error
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFiltersChange", function (query) {
      _this.notifyControllingParent({
        query: query,
        queryText: query.text,
        error: null
      });

      _this.setState({
        query: query,
        queryText: query.text,
        error: null
      });
    });

    var _query = parseQuery(props.defaultQuery || props.query, props);

    _this.state = {
      query: _query,
      queryText: _query.text,
      error: null
    };
    return _this;
  }

  (0, _createClass2.default)(EuiSearchBar, [{
    key: "notifyControllingParent",
    value: function notifyControllingParent(newState) {
      var onChange = this.props.onChange;

      if (!onChange) {
        return;
      }

      var oldState = this.state;
      var query = newState.query,
          queryText = newState.queryText,
          error = newState.error;
      var isQueryDifferent = oldState.queryText !== queryText;
      var oldError = oldState.error ? oldState.error.message : null;
      var newError = error ? error.message : null;
      var isErrorDifferent = oldError !== newError;

      if (isQueryDifferent || isErrorDifferent) {
        if (error == null) {
          onChange({
            query: query,
            queryText: queryText,
            error: error
          });
        } else {
          onChange({
            query: null,
            queryText: queryText,
            error: error
          });
        }
      }
    }
  }, {
    key: "renderTools",
    value: function renderTools(tools) {
      if (!tools) {
        return undefined;
      }

      if (Array.isArray(tools)) {
        return tools.map(function (tool) {
          return _react.default.createElement(_flex.EuiFlexItem, {
            grow: false,
            key: tool.key == null ? undefined : tool.key
          }, tool);
        });
      }

      return _react.default.createElement(_flex.EuiFlexItem, {
        grow: false
      }, tools);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state = this.state,
          query = _this$state.query,
          queryText = _this$state.queryText,
          error = _this$state.error;
      var _this$props = this.props,
          _this$props$box = _this$props.box;
      _this$props$box = _this$props$box === void 0 ? {
        schema: ''
      } : _this$props$box;
      var schema = _this$props$box.schema,
          box = (0, _objectWithoutProperties2.default)(_this$props$box, ["schema"]),
          filters = _this$props.filters,
          toolsLeft = _this$props.toolsLeft,
          toolsRight = _this$props.toolsRight;
      var toolsLeftEl = this.renderTools(toolsLeft);
      var filtersBar = !filters ? undefined : _react.default.createElement(_flex.EuiFlexItem, {
        className: "euiSearchBar__filtersHolder",
        grow: false
      }, _react.default.createElement(_search_filters.EuiSearchFilters, {
        filters: filters,
        query: query,
        onChange: this.onFiltersChange
      }));
      var toolsRightEl = this.renderTools(toolsRight);
      return _react.default.createElement(_flex.EuiFlexGroup, {
        gutterSize: "m",
        alignItems: "center",
        wrap: true
      }, toolsLeftEl, _react.default.createElement(_flex.EuiFlexItem, {
        className: "euiSearchBar__searchHolder",
        grow: true
      }, _react.default.createElement(_search_box.EuiSearchBox, (0, _extends2.default)({}, box, {
        query: queryText,
        onSearch: this.onSearch,
        isInvalid: error != null,
        title: error ? error.message : undefined
      }))), filtersBar, toolsRightEl);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if ((nextProps.query || nextProps.query === '') && (!prevState.query || typeof nextProps.query !== 'string' && nextProps.query.text !== prevState.query.text || typeof nextProps.query === 'string' && nextProps.query !== prevState.query.text)) {
        var query = parseQuery(nextProps.query, nextProps);
        return {
          query: query,
          queryText: query.text,
          error: null
        };
      }

      return null;
    }
  }]);
  return EuiSearchBar;
}(_react.Component);

exports.EuiSearchBar = EuiSearchBar;
(0, _defineProperty2.default)(EuiSearchBar, "Query", _query2.Query);
EuiSearchBar.propTypes = {
  onChange: _propTypes.default.func,

  /**
     The initial query the bar will hold when first mounted
     */
  defaultQuery: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),

  /**
     If you wish to use the search bar as a controlled component, continuously pass the query
     via this prop
     */
  query: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),

  /**
     Configures the search box. Set `placeholder` to change the placeholder text in the box and
     `incremental` to support incremental (as you type) search.
     */
  box: _propTypes.default.shape({
    name: _propTypes.default.string,
    id: _propTypes.default.string,
    placeholder: _propTypes.default.string,
    value: _propTypes.default.string,
    isInvalid: _propTypes.default.bool,
    fullWidth: _propTypes.default.bool,
    isLoading: _propTypes.default.bool,

    /**
       * Called when the user presses [Enter] OR on change if the incremental prop is `true`.
       * If you don't need the on[Enter] functionality, prefer using onChange
       */
    onSearch: _propTypes.default.func,

    /**
       * When `true` the search will be executed (that is, the `onSearch` will be called) as the
       * user types.
       */
    incremental: _propTypes.default.bool,

    /**
       * when `true` creates a shorter height input
       */
    compressed: _propTypes.default.bool,
    inputRef: _propTypes.default.func,

    /**
       * Shows a button that quickly clears any input
       */
    isClearable: _propTypes.default.bool,

    /**
       * Creates an input group with element(s) coming before input
       * `string` | `ReactElement` or an array of these
       */
    prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),

    /**
       * Creates an input group with element(s) coming after input.
       * `string` | `ReactElement` or an array of these
       */
    append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    // Boolean values are not meaningful to this EuiSearchBox, but are allowed so that other
    // components can use e.g. a true value to mean "auto-derive a schema". See EuiInMemoryTable.
    // Admittedly, this is a bit of a hack.
    schema: _propTypes.default.oneOfType([_propTypes.default.shape({
      strict: _propTypes.default.bool,
      fields: _propTypes.default.any,
      flags: _propTypes.default.arrayOf(_propTypes.default.string.isRequired)
    }).isRequired, _propTypes.default.bool.isRequired])
  }),

  /**
     An array of search filters.
     */
  filters: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
    type: _propTypes.default.oneOf(["is"]).isRequired,
    field: _propTypes.default.string.isRequired,
    name: _propTypes.default.string.isRequired,
    negatedName: _propTypes.default.string,
    available: _propTypes.default.func
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_selection"]).isRequired,
    field: _propTypes.default.string,
    name: _propTypes.default.string.isRequired,
    options: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.shape({
      field: _propTypes.default.string,
      value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
        type: _propTypes.default.oneOf(["date"]).isRequired,
        raw: _propTypes.default.any.isRequired,
        granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
          es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
          js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
          isSame: _propTypes.default.func.isRequired,
          start: _propTypes.default.func.isRequired,
          startOfNext: _propTypes.default.func.isRequired,
          iso8601: _propTypes.default.func.isRequired
        }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
        text: _propTypes.default.string.isRequired,
        resolve: _propTypes.default.func.isRequired
      }).isRequired]).isRequired,
      name: _propTypes.default.string,
      view: _propTypes.default.node
    }).isRequired).isRequired, _propTypes.default.func.isRequired]).isRequired,
    filterWith: _propTypes.default.oneOfType([_propTypes.default.oneOf(["prefix", "includes"]), _propTypes.default.func.isRequired]),
    cache: _propTypes.default.number,
    multiSelect: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["and", "or"])]),
    loadingMessage: _propTypes.default.string,
    noOptionsMessage: _propTypes.default.string,
    searchThreshold: _propTypes.default.number,
    available: _propTypes.default.func,
    autoClose: _propTypes.default.bool
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_toggle"]).isRequired,
    field: _propTypes.default.string.isRequired,
    value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
      type: _propTypes.default.oneOf(["date"]).isRequired,
      raw: _propTypes.default.any.isRequired,
      granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
        es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
        js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
        isSame: _propTypes.default.func.isRequired,
        start: _propTypes.default.func.isRequired,
        startOfNext: _propTypes.default.func.isRequired,
        iso8601: _propTypes.default.func.isRequired
      }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
      text: _propTypes.default.string.isRequired,
      resolve: _propTypes.default.func.isRequired
    }).isRequired]).isRequired,
    name: _propTypes.default.string.isRequired,
    negatedName: _propTypes.default.string,
    available: _propTypes.default.func,
    operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_toggle_group"]).isRequired,
    field: _propTypes.default.string.isRequired,
    items: _propTypes.default.arrayOf(_propTypes.default.shape({
      value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired]).isRequired,
      name: _propTypes.default.string.isRequired,
      negatedName: _propTypes.default.string,
      operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
    }).isRequired).isRequired,
    available: _propTypes.default.func
  }).isRequired]).isRequired),

  /**
     * Tools which go to the left of the search bar.
     */
  toolsLeft: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.arrayOf(_propTypes.default.element.isRequired).isRequired]),

  /**
     * Tools which go to the right of the search bar.
     */
  toolsRight: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.arrayOf(_propTypes.default.element.isRequired).isRequired]),

  /**
     * Date formatter to use when parsing date values
     */
  dateFormat: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
EuiSearchBar.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "notifyControllingParent",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "newState",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onSearch",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "queryText",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onFiltersChange",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "query",
      "type": null
    }],
    "returns": null
  }, {
    "name": "renderTools",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "tools",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiSearchBar",
  "props": {
    "onChange": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "defaultQuery": {
      "type": {
        "name": "union",
        "value": [{
          "name": "any"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": "The initial query the bar will hold when first mounted"
    },
    "query": {
      "type": {
        "name": "union",
        "value": [{
          "name": "any"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": "If you wish to use the search bar as a controlled component, continuously pass the query\n     via this prop"
    },
    "box": {
      "type": {
        "name": "shape",
        "value": {
          "name": {
            "name": "string",
            "required": false
          },
          "id": {
            "name": "string",
            "required": false
          },
          "placeholder": {
            "name": "string",
            "required": false
          },
          "value": {
            "name": "string",
            "required": false
          },
          "isInvalid": {
            "name": "bool",
            "required": false
          },
          "fullWidth": {
            "name": "bool",
            "required": false
          },
          "isLoading": {
            "name": "bool",
            "required": false
          },
          "onSearch": {
            "name": "func",
            "description": "Called when the user presses [Enter] OR on change if the incremental prop is `true`.\nIf you don't need the on[Enter] functionality, prefer using onChange",
            "required": false
          },
          "incremental": {
            "name": "bool",
            "description": "When `true` the search will be executed (that is, the `onSearch` will be called) as the\nuser types.",
            "required": false
          },
          "compressed": {
            "name": "bool",
            "description": "when `true` creates a shorter height input",
            "required": false
          },
          "inputRef": {
            "name": "func",
            "required": false
          },
          "isClearable": {
            "name": "bool",
            "description": "Shows a button that quickly clears any input",
            "required": false
          },
          "prepend": {
            "name": "union",
            "value": [{
              "name": "union",
              "value": [{
                "name": "string"
              }, {
                "name": "element"
              }]
            }, {
              "name": "arrayOf",
              "value": {
                "name": "union",
                "value": [{
                  "name": "string"
                }, {
                  "name": "element"
                }]
              }
            }],
            "description": "Creates an input group with element(s) coming before input\n`string` | `ReactElement` or an array of these",
            "required": false
          },
          "append": {
            "name": "union",
            "value": [{
              "name": "union",
              "value": [{
                "name": "string"
              }, {
                "name": "element"
              }]
            }, {
              "name": "arrayOf",
              "value": {
                "name": "union",
                "value": [{
                  "name": "string"
                }, {
                  "name": "element"
                }]
              }
            }],
            "description": "Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these",
            "required": false
          },
          "className": {
            "name": "string",
            "required": false
          },
          "aria-label": {
            "name": "string",
            "required": false
          },
          "data-test-subj": {
            "name": "string",
            "required": false
          },
          "schema": {
            "name": "union",
            "value": [{
              "name": "shape",
              "value": {
                "strict": {
                  "name": "bool",
                  "required": false
                },
                "fields": {
                  "name": "any",
                  "required": false
                },
                "flags": {
                  "name": "arrayOf",
                  "value": {
                    "name": "string"
                  },
                  "required": false
                }
              }
            }, {
              "name": "bool"
            }],
            "required": false
          }
        }
      },
      "required": false,
      "description": "Configures the search box. Set `placeholder` to change the placeholder text in the box and\n     `incremental` to support incremental (as you type) search."
    },
    "filters": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "union",
          "value": [{
            "name": "shape",
            "value": {
              "type": {
                "name": "enum",
                "value": [{
                  "value": "\"is\"",
                  "computed": false
                }],
                "required": true
              },
              "field": {
                "name": "string",
                "required": true
              },
              "name": {
                "name": "string",
                "required": true
              },
              "negatedName": {
                "name": "string",
                "required": false
              },
              "available": {
                "name": "func",
                "required": false
              }
            }
          }, {
            "name": "shape",
            "value": {
              "type": {
                "name": "enum",
                "value": [{
                  "value": "\"field_value_selection\"",
                  "computed": false
                }],
                "required": true
              },
              "field": {
                "name": "string",
                "required": false
              },
              "name": {
                "name": "string",
                "required": true
              },
              "options": {
                "name": "union",
                "value": [{
                  "name": "arrayOf",
                  "value": {
                    "name": "shape",
                    "value": {
                      "field": {
                        "name": "string",
                        "required": false
                      },
                      "value": {
                        "name": "union",
                        "value": [{
                          "name": "string"
                        }, {
                          "name": "number"
                        }, {
                          "name": "bool"
                        }, {
                          "name": "shape",
                          "value": {
                            "type": {
                              "name": "enum",
                              "value": [{
                                "value": "\"date\"",
                                "computed": false
                              }],
                              "required": true
                            },
                            "raw": {
                              "name": "any",
                              "required": true
                            },
                            "granularity": {
                              "name": "union",
                              "value": [{
                                "name": "shape",
                                "value": {
                                  "es": {
                                    "name": "enum",
                                    "value": [{
                                      "value": "\"d\"",
                                      "computed": false
                                    }, {
                                      "value": "\"w\"",
                                      "computed": false
                                    }, {
                                      "value": "\"M\"",
                                      "computed": false
                                    }, {
                                      "value": "\"y\"",
                                      "computed": false
                                    }],
                                    "required": true
                                  },
                                  "js": {
                                    "name": "enum",
                                    "value": [{
                                      "value": "\"day\"",
                                      "computed": false
                                    }, {
                                      "value": "\"week\"",
                                      "computed": false
                                    }, {
                                      "value": "\"month\"",
                                      "computed": false
                                    }, {
                                      "value": "\"year\"",
                                      "computed": false
                                    }],
                                    "required": true
                                  },
                                  "isSame": {
                                    "name": "func",
                                    "required": true
                                  },
                                  "start": {
                                    "name": "func",
                                    "required": true
                                  },
                                  "startOfNext": {
                                    "name": "func",
                                    "required": true
                                  },
                                  "iso8601": {
                                    "name": "func",
                                    "required": true
                                  }
                                }
                              }, {
                                "name": "enum",
                                "value": [{
                                  "value": "undefined",
                                  "computed": true
                                }]
                              }],
                              "required": true
                            },
                            "text": {
                              "name": "string",
                              "required": true
                            },
                            "resolve": {
                              "name": "func",
                              "required": true
                            }
                          }
                        }],
                        "required": true
                      },
                      "name": {
                        "name": "string",
                        "required": false
                      },
                      "view": {
                        "name": "node",
                        "required": false
                      }
                    }
                  }
                }, {
                  "name": "func"
                }],
                "required": true
              },
              "filterWith": {
                "name": "union",
                "value": [{
                  "name": "enum",
                  "value": [{
                    "value": "\"prefix\"",
                    "computed": false
                  }, {
                    "value": "\"includes\"",
                    "computed": false
                  }]
                }, {
                  "name": "func"
                }],
                "required": false
              },
              "cache": {
                "name": "number",
                "required": false
              },
              "multiSelect": {
                "name": "union",
                "value": [{
                  "name": "bool"
                }, {
                  "name": "enum",
                  "value": [{
                    "value": "\"and\"",
                    "computed": false
                  }, {
                    "value": "\"or\"",
                    "computed": false
                  }]
                }],
                "required": false
              },
              "loadingMessage": {
                "name": "string",
                "required": false
              },
              "noOptionsMessage": {
                "name": "string",
                "required": false
              },
              "searchThreshold": {
                "name": "number",
                "required": false
              },
              "available": {
                "name": "func",
                "required": false
              },
              "autoClose": {
                "name": "bool",
                "required": false
              }
            }
          }, {
            "name": "shape",
            "value": {
              "type": {
                "name": "enum",
                "value": [{
                  "value": "\"field_value_toggle\"",
                  "computed": false
                }],
                "required": true
              },
              "field": {
                "name": "string",
                "required": true
              },
              "value": {
                "name": "union",
                "value": [{
                  "name": "string"
                }, {
                  "name": "number"
                }, {
                  "name": "bool"
                }, {
                  "name": "shape",
                  "value": {
                    "type": {
                      "name": "enum",
                      "value": [{
                        "value": "\"date\"",
                        "computed": false
                      }],
                      "required": true
                    },
                    "raw": {
                      "name": "any",
                      "required": true
                    },
                    "granularity": {
                      "name": "union",
                      "value": [{
                        "name": "shape",
                        "value": {
                          "es": {
                            "name": "enum",
                            "value": [{
                              "value": "\"d\"",
                              "computed": false
                            }, {
                              "value": "\"w\"",
                              "computed": false
                            }, {
                              "value": "\"M\"",
                              "computed": false
                            }, {
                              "value": "\"y\"",
                              "computed": false
                            }],
                            "required": true
                          },
                          "js": {
                            "name": "enum",
                            "value": [{
                              "value": "\"day\"",
                              "computed": false
                            }, {
                              "value": "\"week\"",
                              "computed": false
                            }, {
                              "value": "\"month\"",
                              "computed": false
                            }, {
                              "value": "\"year\"",
                              "computed": false
                            }],
                            "required": true
                          },
                          "isSame": {
                            "name": "func",
                            "required": true
                          },
                          "start": {
                            "name": "func",
                            "required": true
                          },
                          "startOfNext": {
                            "name": "func",
                            "required": true
                          },
                          "iso8601": {
                            "name": "func",
                            "required": true
                          }
                        }
                      }, {
                        "name": "enum",
                        "value": [{
                          "value": "undefined",
                          "computed": true
                        }]
                      }],
                      "required": true
                    },
                    "text": {
                      "name": "string",
                      "required": true
                    },
                    "resolve": {
                      "name": "func",
                      "required": true
                    }
                  }
                }],
                "required": true
              },
              "name": {
                "name": "string",
                "required": true
              },
              "negatedName": {
                "name": "string",
                "required": false
              },
              "available": {
                "name": "func",
                "required": false
              },
              "operator": {
                "name": "enum",
                "value": [{
                  "value": "\"eq\"",
                  "computed": false
                }, {
                  "value": "\"exact\"",
                  "computed": false
                }, {
                  "value": "\"gt\"",
                  "computed": false
                }, {
                  "value": "\"gte\"",
                  "computed": false
                }, {
                  "value": "\"lt\"",
                  "computed": false
                }, {
                  "value": "\"lte\"",
                  "computed": false
                }],
                "required": false
              }
            }
          }, {
            "name": "shape",
            "value": {
              "type": {
                "name": "enum",
                "value": [{
                  "value": "\"field_value_toggle_group\"",
                  "computed": false
                }],
                "required": true
              },
              "field": {
                "name": "string",
                "required": true
              },
              "items": {
                "name": "arrayOf",
                "value": {
                  "name": "shape",
                  "value": {
                    "value": {
                      "name": "union",
                      "value": [{
                        "name": "string"
                      }, {
                        "name": "number"
                      }, {
                        "name": "bool"
                      }],
                      "required": true
                    },
                    "name": {
                      "name": "string",
                      "required": true
                    },
                    "negatedName": {
                      "name": "string",
                      "required": false
                    },
                    "operator": {
                      "name": "enum",
                      "value": [{
                        "value": "\"eq\"",
                        "computed": false
                      }, {
                        "value": "\"exact\"",
                        "computed": false
                      }, {
                        "value": "\"gt\"",
                        "computed": false
                      }, {
                        "value": "\"gte\"",
                        "computed": false
                      }, {
                        "value": "\"lt\"",
                        "computed": false
                      }, {
                        "value": "\"lte\"",
                        "computed": false
                      }],
                      "required": false
                    }
                  }
                },
                "required": true
              },
              "available": {
                "name": "func",
                "required": false
              }
            }
          }]
        }
      },
      "required": false,
      "description": "An array of search filters."
    },
    "toolsLeft": {
      "type": {
        "name": "union",
        "value": [{
          "name": "element"
        }, {
          "name": "arrayOf",
          "value": {
            "name": "element"
          }
        }]
      },
      "required": false,
      "description": "Tools which go to the left of the search bar."
    },
    "toolsRight": {
      "type": {
        "name": "union",
        "value": [{
          "name": "element"
        }, {
          "name": "arrayOf",
          "value": {
            "name": "element"
          }
        }]
      },
      "required": false,
      "description": "Tools which go to the right of the search bar."
    },
    "dateFormat": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Date formatter to use when parsing date values"
    },
    "className": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.string"
      },
      "required": false,
      "description": ""
    }
  }
};