"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavGroup = exports.BACKGROUNDS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../../services");

var _accordion = require("../../accordion");

var _icon = require("../../icon");

var _flex = require("../../flex");

var _title = require("../../title");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var backgroundToClassNameMap = {
  none: '',
  light: 'euiCollapsibleNavGroup--light',
  dark: 'euiCollapsibleNavGroup--dark'
};
var BACKGROUNDS = Object.keys(backgroundToClassNameMap);
exports.BACKGROUNDS = BACKGROUNDS;

var EuiCollapsibleNavGroup = function EuiCollapsibleNavGroup(_ref) {
  var className = _ref.className,
      children = _ref.children,
      id = _ref.id,
      title = _ref.title,
      iconType = _ref.iconType,
      _ref$iconSize = _ref.iconSize,
      iconSize = _ref$iconSize === void 0 ? 'l' : _ref$iconSize,
      _ref$background = _ref.background,
      background = _ref$background === void 0 ? 'none' : _ref$background,
      _ref$isCollapsible = _ref.isCollapsible,
      isCollapsible = _ref$isCollapsible === void 0 ? false : _ref$isCollapsible,
      _ref$titleElement = _ref.titleElement,
      titleElement = _ref$titleElement === void 0 ? 'h3' : _ref$titleElement,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'xxs' : _ref$titleSize,
      iconProps = _ref.iconProps,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "children", "id", "title", "iconType", "iconSize", "background", "isCollapsible", "titleElement", "titleSize", "iconProps"]);

  var _useState = (0, _react.useState)(id || (0, _services.htmlIdGenerator)()()),
      _useState2 = (0, _slicedToArray2.default)(_useState, 1),
      groupID = _useState2[0];

  var titleID = "".concat(groupID, "__title");
  var classes = (0, _classnames.default)('euiCollapsibleNavGroup', backgroundToClassNameMap[background], {
    'euiCollapsibleNavGroup--withHeading': title
  }, className); // Warn if consumer passes an iconType without a title

  if (iconType && !title) {
    console.warn('EuiCollapsibleNavGroup will not render an icon without `title`.');
  }

  var content = _react.default.createElement("div", {
    className: "euiCollapsibleNavGroup__children"
  }, children);

  var headingClasses = 'euiCollapsibleNavGroup__heading';
  var TitleElement = titleElement;
  var titleContent = title ? _react.default.createElement(_flex.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, iconType && _react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, _react.default.createElement(_icon.EuiIcon, (0, _extends2.default)({}, iconProps, {
    type: iconType,
    size: iconSize
  }))), _react.default.createElement(_flex.EuiFlexItem, null, _react.default.createElement(_title.EuiTitle, {
    size: titleSize
  }, _react.default.createElement(TitleElement, {
    id: titleID,
    className: "euiCollapsibleNavGroup__title"
  }, title)))) : undefined;

  if (isCollapsible && title) {
    return _react.default.createElement(_accordion.EuiAccordion, (0, _extends2.default)({
      id: groupID,
      className: classes,
      buttonClassName: headingClasses,
      buttonContent: titleContent,
      initialIsOpen: true,
      arrowDisplay: "right"
    }, rest), content);
  } else {
    return _react.default.createElement("div", (0, _extends2.default)({
      id: groupID,
      className: classes
    }, rest), titleContent && _react.default.createElement("div", {
      className: headingClasses
    }, titleContent), content);
  }
};

exports.EuiCollapsibleNavGroup = EuiCollapsibleNavGroup;
EuiCollapsibleNavGroup.propTypes = {
  children: _propTypes.default.node,

  /**
     * Sits left of the `title` and only when `title` is present
     */
  iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

  /**
     * Change the size of the icon in the `title`
     */
  iconSize: _propTypes.default.oneOf(["original", "s", "m", "l", "xl", "xxl"]),

  /**
     * Further extend the props applied to EuiIcon
     */
  iconProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
         * One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.
         * Note that coloring only works if your SVG is removed of fill attributes.
         */
    color: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.oneOf(["default", "primary", "secondary", "success", "accent", "warning", "danger", "text", "subdued", "ghost"]).isRequired]),

    /**
         * Descriptive title for naming the icon based on its use
         */
    title: _propTypes.default.string,

    /**
         * A unique identifier for the title element
         */
    titleId: _propTypes.default.string,

    /**
         * Its value should be one or more element IDs
         */
    "aria-labelledby": _propTypes.default.string,

    /**
         * Callback when the icon has been loaded & rendered
         */
    onIconLoad: _propTypes.default.func
  }),

  /**
     * Optionally provide an id, otherwise one will be created
     */

  /**
     * Optionally provide an id, otherwise one will be created
     */
  id: _propTypes.default.string,

  /**
     * Adds a background color to the entire group,
     * applying the correct text color to the `title` only
     */

  /**
     * Adds a background color to the entire group,
     * applying the correct text color to the `title` only
     */
  background: _propTypes.default.oneOf(["none", "light", "dark"]),

  /**
     * Determines the title's heading element
     */

  /**
     * Determines the title's heading element
     */
  titleElement: _propTypes.default.oneOf(["h2", "h3", "h4", "h5", "h6", "span"]),

  /**
     * Title sizing equivelant to EuiTitle, but only `s` and smaller
     */

  /**
     * Title sizing equivelant to EuiTitle, but only `s` and smaller
     */
  titleSize: _propTypes.default.any,
  className: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]), _propTypes.default.string]),
  "aria-label": _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]), _propTypes.default.string]),
  "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]), _propTypes.default.string]),

  /**
       * Class that will apply to the trigger for the accordion.
       */
  buttonClassName: _propTypes.default.string,

  /**
       * Class that will apply to the trigger content for the accordion.
       */
  buttonContentClassName: _propTypes.default.string,

  /**
       * The content of the clickable trigger
       */
  buttonContent: _propTypes.default.node,

  /**
       * Will appear right aligned against the button. Useful for separate actions like deletions.
       */
  extraAction: _propTypes.default.node,

  /**
       * The accordion will start in the open state.
       */
  initialIsOpen: _propTypes.default.bool,

  /**
       * Optional callback method called on open and close with a single `isOpen` parameter
       */
  onToggle: _propTypes.default.func,

  /**
       * The padding around the exposed accordion content.
       */
  paddingSize: _propTypes.default.oneOf(["none", "xs", "s", "m", "l", "xl"]),

  /**
       * Placement of the arrow indicator, or 'none' to hide it.
       * Placing on the `right` doesn't work with `extraAction` and so it will be ignored
       */
  arrowDisplay: _propTypes.default.oneOf(["left", "right", "none"]),

  /**
       * Control the opening of accordin via prop
       */
  forceState: _propTypes.default.oneOf(["closed", "open"]),

  /**
     * If `true`, wraps children in the body of an accordion,
     * requiring the prop `title` to be used as the button.
     * When `false`, simply renders a div without any accordion functionality.
     */

  /**
       * If `true`, wraps children in the body of an accordion,
       * requiring the prop `title` to be used as the button.
       * When `false`, simply renders a div without any accordion functionality.
       */
  isCollapsible: _propTypes.default.oneOfType([_propTypes.default.oneOf([true]).isRequired, _propTypes.default.oneOf([false])]),

  /**
     * The title gets wrapped in the appropriate heading level
     * with the option to add an iconType
     */

  /**
       * The title gets wrapped in the appropriate heading level
       * with the option to add an iconType
       */
  title: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.node])
};
EuiCollapsibleNavGroup.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiCollapsibleNavGroup",
  "props": {
    "iconSize": {
      "defaultValue": {
        "value": "'l'",
        "computed": false
      },
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.oneOf([\"original\", \"s\", \"m\", \"l\", \"xl\", \"xxl\"])"
      },
      "required": false,
      "description": "Change the size of the icon in the `title`"
    },
    "background": {
      "defaultValue": {
        "value": "'none'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"light\"",
          "computed": false
        }, {
          "value": "\"dark\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Adds a background color to the entire group,\napplying the correct text color to the `title` only"
    },
    "isCollapsible": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "enum",
          "value": [{
            "value": "true",
            "computed": false
          }]
        }, {
          "name": "enum",
          "value": [{
            "value": "false",
            "computed": false
          }]
        }]
      },
      "required": false,
      "description": "If `true`, wraps children in the body of an accordion,\nrequiring the prop `title` to be used as the button.\nWhen `false`, simply renders a div without any accordion functionality."
    },
    "titleElement": {
      "defaultValue": {
        "value": "'h3'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"h2\"",
          "computed": false
        }, {
          "value": "\"h3\"",
          "computed": false
        }, {
          "value": "\"h4\"",
          "computed": false
        }, {
          "value": "\"h5\"",
          "computed": false
        }, {
          "value": "\"h6\"",
          "computed": false
        }, {
          "value": "\"span\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Determines the title's heading element"
    },
    "titleSize": {
      "defaultValue": {
        "value": "'xxs'",
        "computed": false
      },
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Title sizing equivelant to EuiTitle, but only `s` and smaller"
    },
    "children": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": ""
    },
    "iconType": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.oneOfType([_propTypes.default.oneOf([\"accessibility\", \"addDataApp\", \"advancedSettingsApp\", \"aggregate\", \"alert\", \"annotation\", \"apmApp\", \"apmTrace\", \"apps\", \"arrowDown\", \"arrowLeft\", \"arrowRight\", \"arrowUp\", \"asterisk\", \"auditbeatApp\", \"beaker\", \"bell\", \"bellSlash\", \"bolt\", \"boxesHorizontal\", \"boxesVertical\", \"branch\", \"broom\", \"brush\", \"bug\", \"bullseye\", \"calendar\", \"canvasApp\", \"codeApp\", \"check\", \"checkInCircleFilled\", \"cheer\", \"clock\", \"cloudDrizzle\", \"cloudStormy\", \"cloudSunny\", \"compute\", \"console\", \"consoleApp\", \"controlsHorizontal\", \"controlsVertical\", \"copy\", \"copyClipboard\", \"createAdvancedJob\", \"createMultiMetricJob\", \"createPopulationJob\", \"createSingleMetricJob\", \"cross\", \"crossClusterReplicationApp\", \"crosshairs\", \"crossInACircleFilled\", \"currency\", \"cut\", \"dashboardApp\", \"database\", \"dataVisualizer\", \"devToolsApp\", \"discoverApp\", \"document\", \"documentEdit\", \"documents\", \"dot\", \"download\", \"editorAlignCenter\", \"editorAlignLeft\", \"editorAlignRight\", \"editorBold\", \"editorCodeBlock\", \"editorComment\", \"editorDistributeHorizontal\", \"editorDistributeVertical\", \"editorHeading\", \"editorItalic\", \"editorItemAlignLeft\", \"editorItemAlignBottom\", \"editorItemAlignCenter\", \"editorItemAlignMiddle\", \"editorItemAlignRight\", \"editorItemAlignTop\", \"editorLink\", \"editorOrderedList\", \"editorPositionBottomLeft\", \"editorPositionBottomRight\", \"editorPositionTopLeft\", \"editorPositionTopRight\", \"editorRedo\", \"editorStrike\", \"editorTable\", \"editorUnderline\", \"editorUndo\", \"editorUnorderedList\", \"email\", \"empty\", \"emsApp\", \"exit\", \"expand\", \"expandMini\", \"exportAction\", \"eye\", \"eyeClosed\", \"faceHappy\", \"faceNeutral\", \"faceSad\", \"filebeatApp\", \"filter\", \"flag\", \"folderCheck\", \"folderClosed\", \"folderExclamation\", \"folderOpen\", \"fullScreen\", \"gear\", \"gisApp\", \"glasses\", \"globe\", \"grab\", \"grabHorizontal\", \"graphApp\", \"grid\", \"grokApp\", \"heart\", \"heartbeatApp\", \"heatmap\", \"help\", \"home\", \"iInCircle\", \"image\", \"importAction\", \"indexClose\", \"indexEdit\", \"indexFlush\", \"indexManagementApp\", \"indexMapping\", \"indexOpen\", \"indexPatternApp\", \"indexRollupApp\", \"indexSettings\", \"inputOutput\", \"inspect\", \"invert\", \"ip\", \"keyboardShortcut\", \"kqlField\", \"kqlFunction\", \"kqlOperand\", \"kqlSelector\", \"kqlValue\", \"lensApp\", \"link\", \"list\", \"listAdd\", \"lock\", \"lockOpen\", \"logsApp\", \"logoAerospike\", \"logoApache\", \"logoAPM\", \"logoAppSearch\", \"logoAWS\", \"logoAWSMono\", \"logoAzure\", \"logoAzureMono\", \"logoBeats\", \"logoBusinessAnalytics\", \"logoCeph\", \"logoCloud\", \"logoCloudEnterprise\", \"logoCode\", \"logoCodesandbox\", \"logoCouchbase\", \"logoDocker\", \"logoDropwizard\", \"logoElastic\", \"logoElasticsearch\", \"logoElasticStack\", \"logoEnterpriseSearch\", \"logoEtcd\", \"logoGCP\", \"logoGCPMono\", \"logoGithub\", \"logoGmail\", \"logoGolang\", \"logoGoogleG\", \"logoHAproxy\", \"logoIBM\", \"logoIBMMono\", \"logoKafka\", \"logoKibana\", \"logoKubernetes\", \"logoLogging\", \"logoLogstash\", \"logoMaps\", \"logoMemcached\", \"logoMetrics\", \"logoMongodb\", \"logoMySQL\", \"logoNginx\", \"logoObservability\", \"logoOsquery\", \"logoPhp\", \"logoPostgres\", \"logoPrometheus\", \"logoRabbitmq\", \"logoRedis\", \"logoSecurity\", \"logoSiteSearch\", \"logoSketch\", \"logoSlack\", \"logoUptime\", \"logoWebhook\", \"logoWindows\", \"logoWorkplaceSearch\", \"logstashFilter\", \"logstashIf\", \"logstashInput\", \"logstashOutput\", \"logstashQueue\", \"machineLearningApp\", \"magnet\", \"magnifyWithMinus\", \"magnifyWithPlus\", \"managementApp\", \"mapMarker\", \"memory\", \"menu\", \"menuLeft\", \"menuRight\", \"merge\", \"metricbeatApp\", \"metricsApp\", \"minimize\", \"minusInCircle\", \"minusInCircleFilled\", \"monitoringApp\", \"moon\", \"nested\", \"node\", \"notebookApp\", \"number\", \"offline\", \"online\", \"package\", \"packetbeatApp\", \"pageSelect\", \"pagesSelect\", \"partial\", \"paperClip\", \"pause\", \"pencil\", \"pin\", \"pinFilled\", \"pipelineApp\", \"play\", \"plusInCircle\", \"plusInCircleFilled\", \"popout\", \"push\", \"questionInCircle\", \"quote\", \"recentlyViewedApp\", \"refresh\", \"reporter\", \"reportingApp\", \"save\", \"savedObjectsApp\", \"scale\", \"search\", \"searchProfilerApp\", \"securityAnalyticsApp\", \"securityApp\", \"securitySignal\", \"securitySignalDetected\", \"securitySignalResolved\", \"shard\", \"share\", \"snowflake\", \"sortable\", \"sortDown\", \"sortLeft\", \"sortRight\", \"sortUp\", \"spacesApp\", \"sqlApp\", \"starEmpty\", \"starEmptySpace\", \"starFilled\", \"starFilledSpace\", \"starMinusEmpty\", \"starMinusFilled\", \"starPlusEmpty\", \"starPlusFilled\", \"stats\", \"stop\", \"stopFilled\", \"stopSlash\", \"storage\", \"string\", \"submodule\", \"swatchInput\", \"symlink\", \"tableOfContents\", \"tableDensityExpanded\", \"tableDensityCompact\", \"tableDensityNormal\", \"tag\", \"tear\", \"temperature\", \"timeline\", \"timelionApp\", \"training\", \"trash\", \"upgradeAssistantApp\", \"uptimeApp\", \"user\", \"users\", \"usersRolesApp\", \"vector\", \"videoPlayer\", \"visArea\", \"visAreaStacked\", \"visBarHorizontal\", \"visBarHorizontalStacked\", \"visBarVertical\", \"visBarVerticalStacked\", \"visGauge\", \"visGoal\", \"visLine\", \"visMapCoordinate\", \"visMapRegion\", \"visMetric\", \"visPie\", \"visTable\", \"visTagCloud\", \"visText\", \"visTimelion\", \"visualizeApp\", \"visVega\", \"visVisualBuilder\", \"watchesApp\", \"wrench\", \"tokenClass\", \"tokenProperty\", \"tokenEnum\", \"tokenVariable\", \"tokenMethod\", \"tokenAnnotation\", \"tokenException\", \"tokenInterface\", \"tokenParameter\", \"tokenField\", \"tokenElement\", \"tokenFunction\", \"tokenBoolean\", \"tokenString\", \"tokenArray\", \"tokenNumber\", \"tokenConstant\", \"tokenObject\", \"tokenEvent\", \"tokenKey\", \"tokenNull\", \"tokenStruct\", \"tokenPackage\", \"tokenOperator\", \"tokenEnumMember\", \"tokenRepo\", \"tokenSymbol\", \"tokenFile\", \"tokenModule\", \"tokenNamespace\", \"tokenDate\", \"tokenIP\", \"tokenNested\", \"tokenAlias\", \"tokenShape\", \"tokenGeo\", \"tokenRange\", \"tokenBinary\", \"tokenJoin\", \"tokenPercolator\", \"tokenFlattened\", \"tokenRankFeature\", \"tokenRankFeatures\", \"tokenKeyword\", \"tokenCompletionSuggester\", \"tokenDenseVector\", \"tokenText\", \"tokenTokenCount\", \"tokenSearchType\", \"tokenHistogram\"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired])"
      },
      "required": false,
      "description": "Sits left of the `title` and only when `title` is present"
    },
    "iconProps": {
      "type": {
        "name": "shape",
        "value": {
          "className": {
            "name": "string",
            "required": false
          },
          "aria-label": {
            "name": "string",
            "required": false
          },
          "data-test-subj": {
            "name": "string",
            "required": false
          },
          "color": {
            "name": "union",
            "value": [{
              "name": "string"
            }, {
              "name": "enum",
              "value": [{
                "value": "\"default\"",
                "computed": false
              }, {
                "value": "\"primary\"",
                "computed": false
              }, {
                "value": "\"secondary\"",
                "computed": false
              }, {
                "value": "\"success\"",
                "computed": false
              }, {
                "value": "\"accent\"",
                "computed": false
              }, {
                "value": "\"warning\"",
                "computed": false
              }, {
                "value": "\"danger\"",
                "computed": false
              }, {
                "value": "\"text\"",
                "computed": false
              }, {
                "value": "\"subdued\"",
                "computed": false
              }, {
                "value": "\"ghost\"",
                "computed": false
              }]
            }],
            "description": "One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.\nNote that coloring only works if your SVG is removed of fill attributes.",
            "required": false
          },
          "title": {
            "name": "string",
            "description": "Descriptive title for naming the icon based on its use",
            "required": false
          },
          "titleId": {
            "name": "string",
            "description": "A unique identifier for the title element",
            "required": false
          },
          "aria-labelledby": {
            "name": "string",
            "description": "Its value should be one or more element IDs",
            "required": false
          },
          "onIconLoad": {
            "name": "func",
            "description": "Callback when the icon has been loaded & rendered",
            "required": false
          }
        }
      },
      "required": false,
      "description": "Further extend the props applied to EuiIcon"
    },
    "id": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Optionally provide an id, otherwise one will be created"
    },
    "className": {
      "type": {
        "name": "union",
        "value": [{
          "name": "union",
          "value": [{
            "name": "string"
          }, {
            "name": "string"
          }]
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "union",
        "value": [{
          "name": "union",
          "value": [{
            "name": "string"
          }, {
            "name": "string"
          }]
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "union",
        "value": [{
          "name": "union",
          "value": [{
            "name": "string"
          }, {
            "name": "string"
          }]
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": ""
    },
    "buttonClassName": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Class that will apply to the trigger for the accordion."
    },
    "buttonContentClassName": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Class that will apply to the trigger content for the accordion."
    },
    "buttonContent": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "The content of the clickable trigger"
    },
    "extraAction": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Will appear right aligned against the button. Useful for separate actions like deletions."
    },
    "initialIsOpen": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "The accordion will start in the open state."
    },
    "onToggle": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "Optional callback method called on open and close with a single `isOpen` parameter"
    },
    "paddingSize": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"xs\"",
          "computed": false
        }, {
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }, {
          "value": "\"l\"",
          "computed": false
        }, {
          "value": "\"xl\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "The padding around the exposed accordion content."
    },
    "arrowDisplay": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"left\"",
          "computed": false
        }, {
          "value": "\"right\"",
          "computed": false
        }, {
          "value": "\"none\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Placement of the arrow indicator, or 'none' to hide it.\nPlacing on the `right` doesn't work with `extraAction` and so it will be ignored"
    },
    "forceState": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"closed\"",
          "computed": false
        }, {
          "value": "\"open\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Control the opening of accordin via prop"
    },
    "title": {
      "type": {
        "name": "union",
        "value": [{
          "name": "node"
        }, {
          "name": "node"
        }]
      },
      "required": false,
      "description": "The title gets wrapped in the appropriate heading level\nwith the option to add an iconType"
    }
  }
};