/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.ColumnAdapter;
import db.Field;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.Table;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class DbLargeTableModel
implements TableModel {
    ArrayList<TableModelListener> listeners = new ArrayList();
    Table table;
    Schema schema;
    ColumnAdapter keyAdapter;
    ColumnAdapter[] colAdapters;
    RecordIterator recIt;
    Record lastRecord;
    int lastIndex;
    Field minKey;
    Field maxKey;
    Field keyType;

    DbLargeTableModel(Table table) {
        this.table = table;
        this.schema = table.getSchema();
        this.keyAdapter = new ColumnAdapter(this.schema.getKeyFieldClass());
        try {
            this.keyType = (Field)this.schema.getKeyFieldClass().newInstance();
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.recIt = table.iterator();
            this.lastRecord = this.recIt.next();
            this.lastIndex = 0;
            this.findMaxKey();
            this.findMinKey();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        this.colAdapters = new ColumnAdapter[this.schema.getFieldCount()];
        Class[] classes = this.schema.getFieldClasses();
        for (int i = 0; i < this.colAdapters.length; ++i) {
            this.colAdapters[i] = new ColumnAdapter(classes[i]);
        }
    }

    private void findMinKey() throws IOException {
        RecordIterator iter = this.table.iterator();
        Record rec = iter.next();
        this.minKey = rec.getKeyField();
    }

    private void findMaxKey() throws IOException {
        Field max = this.keyType.newField();
        if (this.table.useLongKeys()) {
            max.setLongValue(Long.MAX_VALUE);
        } else {
            byte[] maxBytes = new byte[128];
            Arrays.fill(maxBytes, 0, 128, (byte)127);
            max.setBinaryData(maxBytes);
        }
        RecordIterator iter = this.table.iterator(max);
        Record rec = iter.previous();
        this.maxKey = rec.getKeyField();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return this.keyAdapter.getValueClass();
        }
        return this.colAdapters[columnIndex - 1].getValueClass();
    }

    @Override
    public int getColumnCount() {
        return this.schema.getFieldCount() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return this.schema.getKeyName();
        }
        --columnIndex;
        int[] indexCols = this.table.getIndexedColumns();
        boolean isIndexed = false;
        for (int indexCol : indexCols) {
            if (indexCol != columnIndex) continue;
            isIndexed = true;
            break;
        }
        return this.schema.getFieldNames()[columnIndex] + (isIndexed ? "*" : "");
    }

    @Override
    public int getRowCount() {
        return this.table.getRecordCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Record rec = this.getRecord(rowIndex);
        if (rec == null) {
            return null;
        }
        if (columnIndex == 0) {
            return this.keyAdapter.getKeyValue(rec);
        }
        return this.colAdapters[columnIndex - 1].getValue(rec, columnIndex - 1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private Record getRecord(int index) {
        try {
            if (index == this.lastIndex + 1) {
                if (!this.recIt.hasNext()) {
                    // empty if block
                }
                this.lastRecord = this.recIt.next();
                this.lastIndex = index;
            } else if (index != this.lastIndex) {
                if (index < this.lastIndex && this.lastIndex - index < 200) {
                    int backup = this.lastIndex - index + 1;
                    for (int i = 0; i < backup; ++i) {
                        if (!this.recIt.hasPrevious()) continue;
                        this.recIt.previous();
                    }
                    this.lastRecord = this.recIt.next();
                    this.lastIndex = index;
                } else {
                    this.findRecord(index);
                    this.lastRecord = this.recIt.next();
                    this.lastIndex = index;
                }
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        return this.lastRecord;
    }

    private void findRecord(int index) throws IOException {
        if (index < 1000) {
            this.recIt = this.table.iterator();
            for (int i = 0; i < index; ++i) {
                this.recIt.next();
            }
        } else if (index > this.table.getRecordCount() - 1000) {
            this.recIt = this.table.iterator(this.maxKey);
            if (this.recIt.hasNext()) {
                this.recIt.next();
            }
            for (int i = 0; i < this.table.getRecordCount() - index; ++i) {
                this.recIt.previous();
            }
        } else {
            this.recIt = this.table.iterator(this.approxKey(index));
        }
    }

    private Field approxKey(int index) {
        Field key = this.keyType.newField();
        if (this.table.useLongKeys()) {
            long min = this.minKey.getLongValue();
            long max = this.maxKey.getLongValue();
            long k = min + (max - min) * (long)index / (long)this.table.getRecordCount();
            key.setLongValue(k);
        } else {
            long min = this.getLong(this.minKey.getBinaryData());
            long max = this.getLong(this.maxKey.getBinaryData());
            long k = min + (max - min) * (long)index / (long)this.table.getRecordCount();
            byte[] bytes = new byte[8];
            for (int i = 7; i >= 0; --i) {
                bytes[i] = (byte)k;
                k >>= 8;
            }
            key.setBinaryData(bytes);
        }
        return key;
    }

    private long getLong(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return 0L;
        }
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value <<= 8;
            if (i >= bytes.length) continue;
            value += (long)(bytes[i] & 0xFF);
        }
        return value;
    }
}

