/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class CharEncodedValue
extends EncodedValue {
    public final char value;

    protected CharEncodedValue(Input in, byte valueArg) {
        this.value = (char)EncodedValueUtils.decodeUnsignedIntegralValue(in.readBytes(valueArg + 1));
    }

    public CharEncodedValue(char value) {
        this.value = value;
    }

    @Override
    public void writeValue(AnnotatedOutput out) {
        byte[] bytes = EncodedValueUtils.encodeUnsignedIntegralValue(this.value);
        if (out.annotates()) {
            out.annotate(1, "value_type=" + ValueType.VALUE_CHAR.name() + ",value_arg=" + (bytes.length - 1));
            char[] c = Character.toChars(this.value);
            assert (c.length > 0);
            out.annotate(bytes.length, "value: 0x" + Integer.toHexString(this.value) + " '" + c[0] + "'");
        }
        out.writeByte(ValueType.VALUE_CHAR.value | bytes.length - 1 << 5);
        out.write(bytes);
    }

    @Override
    public int placeValue(int offset) {
        return offset + EncodedValueUtils.getRequiredBytesForUnsignedIntegralValue(this.value) + 1;
    }

    @Override
    protected int compareValue(EncodedValue o) {
        CharEncodedValue other = (CharEncodedValue)o;
        return this.value < other.value ? -1 : (this.value > other.value ? 1 : 0);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_CHAR;
    }

    public int hashCode() {
        return this.value;
    }
}

