/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Format.Instruction31c;
import org.jf.dexlib.Code.Format.Instruction41c;
import org.jf.dexlib.Code.Format.InstructionWithJumboVariant;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;

public class Instruction21c
extends InstructionWithReference
implements SingleRegisterInstruction,
InstructionWithJumboVariant {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;

    public Instruction21c(Opcode opcode, short regA, Item referencedItem) {
        super(opcode, referencedItem);
        if (regA >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        if (opcode == Opcode.NEW_INSTANCE) {
            assert (referencedItem instanceof TypeIdItem);
            if (((TypeIdItem)referencedItem).getTypeDescriptor().charAt(0) != 'L') {
                throw new RuntimeException("Only class references can be used with the new-instance opcode");
            }
        }
        this.regA = (byte)regA;
    }

    private Instruction21c(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        if (opcode == Opcode.NEW_INSTANCE && ((TypeIdItem)this.getReferencedItem()).getTypeDescriptor().charAt(0) != 'L') {
            throw new RuntimeException("Only class references can be used with the new-instance opcode");
        }
        this.regA = buffer[bufferIndex + 1];
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        if (this.getReferencedItem().getIndex() > 65535) {
            if (this.opcode.hasJumboOpcode()) {
                throw new RuntimeException(String.format("%s index is too large. Use the %s instruction instead.", this.opcode.referenceType.name(), this.opcode.getJumboOpcode().name));
            }
            throw new RuntimeException(String.format("%s index is too large", this.opcode.referenceType.name()));
        }
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
        out.writeShort(this.getReferencedItem().getIndex());
    }

    @Override
    public Format getFormat() {
        return Format.Format21c;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public Instruction makeJumbo() {
        Opcode jumboOpcode = this.opcode.getJumboOpcode();
        if (jumboOpcode == null) {
            return null;
        }
        if (jumboOpcode.format == Format.Format31c) {
            return new Instruction31c(jumboOpcode, (short)this.getRegisterA(), this.getReferencedItem());
        }
        return new Instruction41c(jumboOpcode, this.getRegisterA(), this.getReferencedItem());
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction21c(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

