/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.plugin;

import functioncalls.graph.FcgEdge;
import functioncalls.graph.FcgVertex;
import functioncalls.graph.FunctionCallGraph;
import functioncalls.plugin.FcgData;
import functioncalls.plugin.FunctionEdgeCache;
import ghidra.graph.viewer.GraphPerspectiveInfo;
import ghidra.program.model.listing.Function;
import java.util.Objects;

public class ValidFcgData
implements FcgData {
    private Function function;
    private FunctionCallGraph graph;
    private GraphPerspectiveInfo<FcgVertex, FcgEdge> perspectiveInfo;
    private FunctionEdgeCache allEdgesByFunction = new FunctionEdgeCache();

    ValidFcgData(Function function, FunctionCallGraph graph) {
        this.function = Objects.requireNonNull(function);
        this.graph = Objects.requireNonNull(graph);
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public boolean isFunction(Function f) {
        return this.function.equals(f);
    }

    @Override
    public FunctionCallGraph getGraph() {
        return this.graph;
    }

    @Override
    public FunctionEdgeCache getFunctionEdgeCache() {
        return this.allEdgesByFunction;
    }

    @Override
    public boolean hasResults() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return !this.graph.isEmpty();
    }

    @Override
    public void dispose() {
        this.graph.dispose();
    }

    @Override
    public GraphPerspectiveInfo<FcgVertex, FcgEdge> getGraphPerspective() {
        return this.perspectiveInfo;
    }

    @Override
    public void setGraphPerspective(GraphPerspectiveInfo<FcgVertex, FcgEdge> info) {
        this.perspectiveInfo = info;
    }
}

