/*
 * Decompiled with CFR 0.152.
 */
package db.util;

import db.Field;
import db.util.TableColumn;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.LinkedList;

public class TableDescriptor {
    private TableColumn[] columns = this.discoverTableColumns();

    protected TableDescriptor() {
    }

    private TableColumn[] discoverTableColumns() {
        Class<?> clazz = this.getClass();
        java.lang.reflect.Field[] fields = clazz.getFields();
        ArrayList<TableColumn> list = new ArrayList<TableColumn>(fields.length);
        for (java.lang.reflect.Field field : fields) {
            Class<?> type = field.getType();
            if (!TableColumn.class.isAssignableFrom(type)) continue;
            try {
                TableColumn column = (TableColumn)field.get(null);
                column.setName(field.getName());
                column.setOrdinal(list.size());
                list.add(column);
            }
            catch (IllegalArgumentException column) {
            }
            catch (IllegalAccessException e) {
                Msg.showError((Object)this, null, (String)"Class Usage Error", (Object)"You must provide public static members for your TableColumns");
            }
        }
        return list.toArray(new TableColumn[list.size()]);
    }

    public int[] getIndexedColumns() {
        int count = 0;
        for (TableColumn column : this.columns) {
            if (!column.isIndexed()) continue;
            ++count;
        }
        int[] indexedColumns = new int[count];
        count = 0;
        for (TableColumn column : this.columns) {
            if (!column.isIndexed()) continue;
            indexedColumns[count++] = column.column();
        }
        return indexedColumns;
    }

    public String[] getColumnNames() {
        LinkedList<String> list = new LinkedList<String>();
        for (TableColumn column : this.columns) {
            list.add(column.name());
        }
        return list.toArray(new String[this.columns.length]);
    }

    public Class<? extends Field>[] getColumnClasses() {
        LinkedList<Class<? extends Field>> list = new LinkedList<Class<? extends Field>>();
        for (TableColumn column : this.columns) {
            list.add(column.getColumnClass());
        }
        return list.toArray(new Class[this.columns.length]);
    }
}

