/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.ByteField;
import db.Field;
import db.IntField;
import db.LongField;
import db.Record;
import db.Schema;
import db.StringField;
import db.Table;

class TableRecord
implements Comparable<TableRecord> {
    private static final int NAME_COLUMN = 0;
    private static final int VERSION_COLUMN = 1;
    private static final int BUFFER_ID_COLUMN = 2;
    private static final int KEY_TYPE_COLUMN = 3;
    private static final int FIELD_TYPES_COLUMN = 4;
    private static final int FIELD_NAMES_COLUMN = 5;
    private static final int COLUMN_INDEXED_COLUMN = 6;
    private static final int MAX_KEY_COLUMN = 7;
    private static final int RECORD_COUNT_COLUMN = 8;
    private static Class<?>[] fieldClasses = new Class[]{StringField.class, IntField.class, IntField.class, ByteField.class, BinaryField.class, StringField.class, IntField.class, LongField.class, IntField.class};
    private static String[] tableRecordFieldNames = new String[]{"TableName", "SchemaVersion", "RootBufferId", "KeyType", "FieldTypes", "FieldNames", "IndexColumn", "MaxKey", "RecordCount"};
    private static Schema schema = new Schema(0, "TableNum", fieldClasses, tableRecordFieldNames);
    private Record record;
    private Table table;

    TableRecord(long tableNum, String name, Schema tableSchema, int indexedColumn) {
        this.record = schema.createRecord(tableNum);
        this.record.setString(0, name);
        this.record.setByteValue(3, tableSchema.getKeyFieldType().getFieldType());
        this.record.setBinaryData(4, tableSchema.getFieldTypes());
        this.record.setString(5, tableSchema.getPackedFieldNames());
        this.record.setIntValue(1, tableSchema.getVersion());
        this.record.setIntValue(6, indexedColumn);
        this.record.setLongValue(7, Long.MIN_VALUE);
        this.record.setIntValue(8, 0);
        this.record.setIntValue(2, -1);
    }

    TableRecord(Record record) {
        this.record = record;
    }

    Record getRecord() {
        return this.record;
    }

    void setTable(Table table) {
        this.table = table;
    }

    void setRecord(Record record) {
        this.record = record;
        if (this.table != null) {
            this.table.tableRecordChanged();
        }
    }

    void invalidate() {
        if (this.table != null) {
            this.table.invalidate();
            this.table = null;
        }
        this.record = null;
    }

    long getTableNum() {
        return this.record.getKey();
    }

    String getName() {
        return this.record.getString(0);
    }

    void setName(String name) {
        this.record.setString(0, name);
    }

    Schema getSchema() throws Field.UnsupportedFieldException {
        return new Schema(this.record.getIntValue(1), this.record.getByteValue(3), this.record.getBinaryData(4), this.record.getString(5));
    }

    int getRootBufferId() {
        return this.record.getIntValue(2);
    }

    void setRootBufferId(int id) {
        this.record.setIntValue(2, id);
    }

    long getMaxKey() {
        return this.record.getLongValue(7);
    }

    void setMaxKey(long maxKey) {
        this.record.setLongValue(7, maxKey);
    }

    int getRecordCount() {
        return this.record.getIntValue(8);
    }

    void setRecordCount(int count) {
        this.record.setIntValue(8, count);
    }

    int getIndexedColumn() {
        return this.record.getIntValue(6);
    }

    static Schema getTableRecordSchema() {
        return schema;
    }

    @Override
    public int compareTo(TableRecord otherRecord) {
        long otherKey;
        long myKey = this.record.getKey();
        if (myKey == (otherKey = otherRecord.record.getKey())) {
            return 0;
        }
        if (myKey < otherKey) {
            return -1;
        }
        return 1;
    }
}

