/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.TableModelWrapper;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.ProgramTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class GhidraTableFilterPanel<ROW_OBJECT>
extends GTableFilterPanel<ROW_OBJECT> {
    public GhidraTableFilterPanel(JTable table, RowObjectTableModel<ROW_OBJECT> tableModel) {
        super(table, tableModel);
    }

    public GhidraTableFilterPanel(JTable table, RowObjectTableModel<ROW_OBJECT> tableModel, String filterLabel) {
        super(table, tableModel, filterLabel);
    }

    protected RowObjectFilterModel<ROW_OBJECT> createTextFilterModel(RowObjectTableModel<ROW_OBJECT> model) {
        RowObjectFilterModel newModel = super.createTextFilterModel(model);
        if (newModel instanceof ThreadedTableModel) {
            return newModel;
        }
        if (!(model instanceof ProgramTableModel)) {
            return newModel;
        }
        return new ProgramTableModelWrapperWrapper(newModel, newModel);
    }

    private class ProgramTableModelWrapperWrapper
    implements RowObjectFilterModel<ROW_OBJECT>,
    ProgramTableModel {
        private final RowObjectFilterModel<ROW_OBJECT> wrappedFilterModel;
        private final RowObjectFilterModel<ROW_OBJECT> wrappedTableModel;

        private ProgramTableModelWrapperWrapper(RowObjectFilterModel<ROW_OBJECT> tableModel, RowObjectFilterModel<ROW_OBJECT> filterModel) {
            this.wrappedTableModel = tableModel;
            this.wrappedFilterModel = filterModel;
        }

        public String getName() {
            return this.wrappedTableModel.getName();
        }

        public ROW_OBJECT getRowObject(int row) {
            return this.wrappedTableModel.getRowObject(row);
        }

        public List<ROW_OBJECT> getModelData() {
            return this.wrappedTableModel.getModelData();
        }

        public int getModelRow(int viewRow) {
            return this.wrappedFilterModel.getModelRow(viewRow);
        }

        public int getRowIndex(ROW_OBJECT t) {
            return this.wrappedFilterModel.getRowIndex(t);
        }

        public int getViewIndex(ROW_OBJECT t) {
            return this.wrappedFilterModel.getViewIndex(t);
        }

        public int getModelIndex(ROW_OBJECT t) {
            return this.wrappedFilterModel.getModelIndex(t);
        }

        public int getUnfilteredRowCount() {
            return this.wrappedFilterModel.getUnfilteredRowCount();
        }

        public int getViewRow(int modelRow) {
            return this.wrappedFilterModel.getViewRow(modelRow);
        }

        public boolean isFiltered() {
            return this.wrappedFilterModel.isFiltered();
        }

        public void setTableFilter(TableFilter<ROW_OBJECT> tableFilter) {
            this.wrappedFilterModel.setTableFilter(tableFilter);
        }

        public TableFilter<ROW_OBJECT> getTableFilter() {
            return this.wrappedFilterModel.getTableFilter();
        }

        public void fireTableDataChanged() {
            this.wrappedTableModel.fireTableDataChanged();
        }

        public void addTableModelListener(TableModelListener l) {
            this.wrappedTableModel.addTableModelListener(l);
        }

        public void removeTableModelListener(TableModelListener l) {
            this.wrappedTableModel.removeTableModelListener(l);
        }

        public Class<?> getColumnClass(int columnIndex) {
            return this.wrappedTableModel.getColumnClass(columnIndex);
        }

        public int getColumnCount() {
            return this.wrappedTableModel.getColumnCount();
        }

        public String getColumnName(int columnIndex) {
            return this.wrappedTableModel.getColumnName(columnIndex);
        }

        public int getRowCount() {
            return this.wrappedTableModel.getRowCount();
        }

        public List<ROW_OBJECT> getUnfilteredData() {
            ArrayList<Object> list = new ArrayList<Object>();
            int rowCount = this.getUnfilteredRowCount();
            for (int i = 0; i < rowCount; ++i) {
                list.add(this.wrappedTableModel.getRowObject(i));
            }
            return list;
        }

        public Object getColumnValueForRow(ROW_OBJECT t, int columnIndex) {
            return this.wrappedTableModel.getColumnValueForRow(t, columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.wrappedTableModel.getValueAt(rowIndex, columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.wrappedTableModel.isCellEditable(rowIndex, columnIndex);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.wrappedTableModel.setValueAt(value, rowIndex, columnIndex);
        }

        private TableModel getBaseTableModel() {
            if (this.wrappedTableModel instanceof TableModelWrapper) {
                TableModelWrapper tableModelWrapper = (TableModelWrapper)this.wrappedTableModel;
                return tableModelWrapper.getWrappedModel();
            }
            return this.wrappedTableModel;
        }

        private ProgramTableModel getProgramTableModel() {
            TableModel baseTableModel = this.getBaseTableModel();
            if (baseTableModel instanceof ProgramTableModel) {
                return (ProgramTableModel)((Object)baseTableModel);
            }
            return null;
        }

        @Override
        public Program getProgram() {
            ProgramTableModel programTableModel = this.getProgramTableModel();
            if (programTableModel != null) {
                return programTableModel.getProgram();
            }
            return null;
        }

        @Override
        public ProgramLocation getProgramLocation(int row, int column) {
            ProgramTableModel programTableModel = this.getProgramTableModel();
            if (programTableModel != null) {
                return programTableModel.getProgramLocation(row, column);
            }
            return null;
        }

        @Override
        public ProgramSelection getProgramSelection(int[] rows) {
            ProgramTableModel programTableModel = this.getProgramTableModel();
            if (programTableModel != null) {
                return programTableModel.getProgramSelection(rows);
            }
            return null;
        }
    }
}

