/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.services.FileImporterService;
import ghidra.app.util.FileOpenDataFlavorHandler;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeFlavorHandler;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class LinuxFileUrlHandler
implements DataTreeFlavorHandler,
FileOpenDataFlavorHandler {
    public void handle(PluginTool tool, DataTree dataTree, GTreeNode destinationNode, Object transferData, int dropAction) {
        DomainFolder folder = this.getDomainFolder(destinationNode);
        this.doImport((Component)dataTree, transferData, (ServiceProvider)tool, folder);
    }

    public void handle(PluginTool tool, Object transferData, DropTargetDropEvent e, DataFlavor f) {
        DomainFolder folder = tool.getProject().getProjectData().getRootFolder();
        this.doImport(tool.getToolFrame(), transferData, (ServiceProvider)tool, folder);
    }

    private void doImport(Component component, Object transferData, ServiceProvider sp, DomainFolder folder) {
        FileImporterService im = (FileImporterService)sp.getService(FileImporterService.class);
        if (im == null) {
            Msg.showError((Object)this, (Component)component, (String)"Could Not Import", (Object)"Could not find importer service.");
            return;
        }
        List<File> files = this.toFiles(transferData);
        if (files.isEmpty()) {
            return;
        }
        if (files.size() == 1 && files.get(0).isFile()) {
            im.importFile(folder, files.get(0));
        } else {
            im.importFiles(folder, files);
        }
    }

    private List<File> toFiles(Object transferData) {
        return this.toUrls(transferData, s -> {
            try {
                return new File(new URL((String)s).toURI());
            }
            catch (Exception ex) {
                Msg.error((Object)this, (Object)("Unable to open dropped URL: '" + s + "'"), (Throwable)ex);
                return null;
            }
        });
    }

    private List<File> toUrls(Object transferData, Function<String, File> converter) {
        String[] urls;
        ArrayList<File> files = new ArrayList<File>();
        String string = (String)transferData;
        for (String url : urls = string.split("\\n")) {
            File file = converter.apply(url);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    private DomainFolder getDomainFolder(GTreeNode destinationNode) {
        if (destinationNode instanceof DomainFolderNode) {
            return ((DomainFolderNode)destinationNode).getDomainFolder();
        }
        if (destinationNode instanceof DomainFileNode) {
            DomainFolderNode parent = (DomainFolderNode)destinationNode.getParent();
            return parent.getDomainFolder();
        }
        return null;
    }
}

