/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis;

import ghidra.app.services.Analyzer;
import ghidra.framework.analysis.AnalysisManager;
import ghidra.framework.analysis.AnalysisPhase;
import ghidra.framework.analysis.AnalyzerScheduler;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.task.GTask;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class AnalysisTask
implements GTask {
    private AnalyzerScheduler analyzerScheduler;
    private AnalysisPhase executionPhase;
    private AnalysisManager analysisManager;

    public AnalysisTask(AnalysisPhase executionPhase, AnalyzerScheduler analyzerScheduler) {
        this.executionPhase = executionPhase;
        this.analyzerScheduler = analyzerScheduler;
        this.analysisManager = analyzerScheduler.getAnalysisManager();
    }

    public String getName() {
        return this.analyzerScheduler.getAnalyzer().getName();
    }

    public void run(UndoableDomainObject domainObject, TaskMonitor monitor) throws CancelledException {
        Program program = (Program)domainObject;
        Analyzer analyzer = this.analyzerScheduler.getAnalyzer();
        AddressSetView addressSet = this.analyzerScheduler.getAddressSet();
        analyzer.added(program, addressSet, monitor, this.analysisManager.getMessageLog());
    }

    public int getPriority() {
        return this.analyzerScheduler.getPriority();
    }

    public AnalysisPhase getPhase() {
        return this.executionPhase;
    }
}

