/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis;

import ghidra.app.services.Analyzer;
import ghidra.framework.analysis.AnalysisRecipe;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AnalysisRecipeBuilder {
    private static List<Class<? extends Analyzer>> classes;

    public static AnalysisRecipe getRecipe(Program program) {
        AnalysisRecipe recipe = AnalysisRecipeBuilder.findRecipe(program);
        if (recipe == null) {
            recipe = AnalysisRecipeBuilder.buildDefaultRecipe(program);
        }
        return recipe;
    }

    private static AnalysisRecipe buildDefaultRecipe(Program program) {
        ArrayList<Analyzer> analyzerList = new ArrayList<Analyzer>();
        Set anayzers = ClassSearcher.getInstances(Analyzer.class);
        for (Analyzer analyzer : anayzers) {
            if (!analyzer.canAnalyze(program)) continue;
            analyzerList.add(analyzer);
        }
        return new AnalysisRecipe("Default", analyzerList, program);
    }

    private static AnalysisRecipe findRecipe(Program program) {
        return new AnalysisRecipe("Default", ClassSearcher.getInstances(Analyzer.class), program);
    }
}

