/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.math.BigInteger;

public class BytesFieldFactory
extends FieldFactory {
    private static final int CHARS_IN_BYTE = 2;
    public static final String FIELD_NAME = "Bytes";
    public static final Color DEFAULT_COLOR = Color.BLUE;
    public static final Color ALIGNMENT_BYTES_COLOR = Color.gray;
    public static final String GROUP_TITLE = "Bytes Field";
    public static final String MAX_DISPLAY_LINES_MSG = "Bytes Field.Maximum Lines To Display";
    public static final String DELIMITER_MSG = "Bytes Field.Delimiter";
    public static final String BYTE_GROUP_SIZE_MSG = "Bytes Field.Byte Group Size";
    public static final String DISPLAY_UCASE_MSG = "Bytes Field.Display in Upper Case";
    public static final String REVERSE_INSTRUCTION_BYTE_ORDERING = "Bytes Field.Reverse Instruction Byte Ordering";
    public static final String DISPLAY_STRUCTURE_ALIGNMENT_BYTES_MSG = "Bytes Field.Display Structure Alignment Bytes";
    private String delim = " ";
    private int maxDisplayLines;
    private int byteGroupSize;
    private boolean displayUpperCase;
    private boolean reverseInstByteOrdering;
    private boolean displayStructureAlignmentBytes;

    public BytesFieldFactory() {
        super(FIELD_NAME);
    }

    private BytesFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "Bytes_Field");
        fieldOptions.getOptions(GROUP_TITLE).setOptionsHelpLocation(hl);
        fieldOptions.registerOption(DELIMITER_MSG, (Object)" ", hl, "String used to separate groups of bytes in the bytes field.");
        fieldOptions.registerOption(MAX_DISPLAY_LINES_MSG, (Object)3, hl, "The maximum number of lines used to display bytes.");
        fieldOptions.registerOption(BYTE_GROUP_SIZE_MSG, (Object)1, hl, "The number of bytes to group together without delimeters in the bytes field.");
        fieldOptions.registerOption(DISPLAY_UCASE_MSG, (Object)false, hl, "Displays the hex digits in upper case in the bytes field");
        fieldOptions.registerOption(REVERSE_INSTRUCTION_BYTE_ORDERING, (Object)false, hl, "Reverses the normal order of the bytes in the bytes field.  Only used for instructions in Little Endian format");
        fieldOptions.registerOption(DISPLAY_STRUCTURE_ALIGNMENT_BYTES_MSG, (Object)true, hl, "Display trailing alignment bytes in structures.");
        this.delim = fieldOptions.getString(DELIMITER_MSG, " ");
        this.maxDisplayLines = fieldOptions.getInt(MAX_DISPLAY_LINES_MSG, 3);
        this.byteGroupSize = fieldOptions.getInt(BYTE_GROUP_SIZE_MSG, 1);
        this.displayUpperCase = fieldOptions.getBoolean(DISPLAY_UCASE_MSG, false);
        this.reverseInstByteOrdering = fieldOptions.getBoolean(REVERSE_INSTRUCTION_BYTE_ORDERING, false);
        this.displayStructureAlignmentBytes = fieldOptions.getBoolean(DISPLAY_STRUCTURE_ALIGNMENT_BYTES_MSG, false);
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(MAX_DISPLAY_LINES_MSG)) {
            this.setDisplayLines((Integer)newValue, options);
            this.model.update();
        } else if (optionName.equals(DELIMITER_MSG)) {
            this.setDelim((String)newValue, options);
            this.model.update();
        } else if (optionName.equals(BYTE_GROUP_SIZE_MSG)) {
            this.setGroupSize((Integer)newValue, options);
            this.model.update();
        } else if (optionName.equals(DISPLAY_UCASE_MSG)) {
            this.displayUpperCase = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(REVERSE_INSTRUCTION_BYTE_ORDERING)) {
            this.reverseInstByteOrdering = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(DISPLAY_STRUCTURE_ALIGNMENT_BYTES_MSG)) {
            this.displayStructureAlignmentBytes = (Boolean)newValue;
            this.model.update();
        }
    }

    private void setGroupSize(int n, Options options) {
        if (n < 1) {
            n = 1;
            options.setInt(BYTE_GROUP_SIZE_MSG, 1);
        }
        this.byteGroupSize = n;
    }

    private void setDisplayLines(int n, Options options) {
        if (n < 1) {
            n = 1;
            options.setInt(MAX_DISPLAY_LINES_MSG, 1);
        }
        this.maxDisplayLines = n;
    }

    private void setDelim(String s, Options options) {
        if (s == null) {
            s = " ";
            options.setString(DELIMITER_MSG, s);
        }
        this.delim = s;
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        int length = Math.min(cu.getLength(), 100);
        byte[] bytes = new byte[length];
        try {
            length = cu.getProgram().getMemory().getBytes(cu.getAddress(), bytes);
        }
        catch (MemoryAccessException e) {
            return null;
        }
        if (length == 0) {
            return null;
        }
        if (cu instanceof Instruction && this.reverseInstByteOrdering && !cu.getProgram().getMemory().isBigEndian()) {
            int i = 0;
            int j = length - 1;
            while (j > i) {
                byte b = bytes[i];
                bytes[i++] = bytes[j];
                bytes[j--] = b;
            }
        }
        int fieldElementLength = length / this.byteGroupSize;
        int residual = length % this.byteGroupSize;
        if (residual != 0) {
            ++fieldElementLength;
        }
        boolean wasTruncated = length != cu.getLength();
        byte[] alignmentBytes = this.getAlignmentBytes(cu, wasTruncated);
        int extraLen = this.getLengthForAlignmentBytes(alignmentBytes, residual);
        FieldElement[] aStrings = new FieldElement[fieldElementLength + extraLen];
        this.buildAttributedByteValues(aStrings, 0, bytes, length, 0, this.color, extraLen != 0);
        if (extraLen != 0) {
            this.buildAttributedByteValues(aStrings, fieldElementLength, alignmentBytes, alignmentBytes.length, residual, ALIGNMENT_BYTES_COLOR, false);
        }
        return ListingTextField.createPackedTextField(this, proxy, aStrings, this.startX + varWidth, this.width, this.maxDisplayLines, this.hlProvider);
    }

    private int getLengthForAlignmentBytes(byte[] alignmentBytes, int residual) {
        if (alignmentBytes == null) {
            return 0;
        }
        int firstGroup = this.byteGroupSize - residual;
        int extraBytes = alignmentBytes.length - firstGroup;
        if (extraBytes < 0) {
            return 1;
        }
        int alignmentLength = extraBytes / this.byteGroupSize + 1;
        if (extraBytes % this.byteGroupSize != 0) {
            ++alignmentLength;
        }
        return alignmentLength;
    }

    private byte[] getAlignmentBytes(CodeUnit cu, boolean wasTruncated) {
        if (cu instanceof Data && this.displayStructureAlignmentBytes && !wasTruncated) {
            return this.getStructureComponentAlignmentBytes((Data)cu);
        }
        return null;
    }

    private int buildAttributedByteValues(FieldElement[] aStrings, int pos, byte[] bytes, int size, int residual, Color c, boolean addDelimToLastGroup) {
        StringBuffer buffer = new StringBuffer();
        int groupSize = this.byteGroupSize - residual;
        int tempGroupSize = 0;
        for (int i = 0; i < size; ++i) {
            String bStr;
            if (bytes[i] >= 0 && bytes[i] <= 15) {
                buffer.append("0");
            }
            if ((bStr = Integer.toHexString(bytes[i] & 0xFF)).length() > 2) {
                bStr = bStr.substring(bStr.length() - 2);
            }
            if (this.displayUpperCase) {
                bStr = bStr.toUpperCase();
            }
            buffer.append(bStr);
            if (++tempGroupSize != groupSize) continue;
            tempGroupSize = 0;
            groupSize = this.byteGroupSize;
            if (i < size - 1 || addDelimToLastGroup) {
                buffer.append(this.delim);
            }
            AttributedString as = new AttributedString(buffer.toString(), c, this.getMetrics());
            aStrings[pos] = new TextFieldElement(as, pos, 0);
            ++pos;
            buffer = new StringBuffer();
        }
        if (tempGroupSize > 0) {
            AttributedString as = new AttributedString(buffer.toString(), c, this.getMetrics());
            aStrings[pos] = new TextFieldElement(as, pos, 0);
        }
        return tempGroupSize;
    }

    private byte[] getStructureComponentAlignmentBytes(Data data) {
        Data parent = data.getParent();
        if (parent == null) {
            return null;
        }
        DataType baseDataType = parent.getBaseDataType();
        if (!(baseDataType instanceof Structure)) {
            return null;
        }
        Structure struct = (Structure)baseDataType;
        if (!struct.isInternallyAligned()) {
            return null;
        }
        int alignSize = 0;
        int ordinal = data.getComponentIndex();
        if (ordinal == struct.getNumComponents() - 1) {
            alignSize = (int)parent.getMaxAddress().subtract(data.getMaxAddress());
        } else {
            Data nextComponent = parent.getComponent(ordinal + 1);
            if (nextComponent == null) {
                return null;
            }
            alignSize = (int)nextComponent.getMinAddress().subtract(data.getMaxAddress()) - 1;
        }
        if (alignSize <= 0) {
            return null;
        }
        int alignmentOffset = data.getParentOffset() + data.getLength();
        byte[] bytes = new byte[alignSize];
        parent.getBytes(bytes, alignmentOffset);
        return bytes;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit) || row < 0 || col < 0) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        ListingTextField btf = (ListingTextField)bf;
        RowColLocation fieldLoc = btf.screenToDataLocation(row, col);
        int tokenIndex = fieldLoc.row();
        int tokenCharPos = fieldLoc.col();
        int size = cu.getLength();
        int len = size / this.byteGroupSize;
        int residual = size % this.byteGroupSize;
        if (residual != 0) {
            ++len;
        }
        if (tokenIndex >= len && residual != 0) {
            if (tokenIndex == len) {
                tokenCharPos += residual * 2;
            }
            --tokenIndex;
        }
        int byteIndex = tokenIndex * this.byteGroupSize + this.getByteIndexInToken(tokenCharPos);
        int charOffset = this.computeCharOffset(tokenCharPos);
        return new BytesFieldLocation(cu.getProgram(), cu.getMinAddress(), cu.getMinAddress().add((long)byteIndex), cpath, charOffset);
    }

    private int getByteIndexInToken(int col) {
        if (col >= this.byteGroupSize * 2) {
            return this.byteGroupSize - 1;
        }
        return col / 2;
    }

    private int computeCharOffset(int col) {
        if (col >= this.byteGroupSize * 2) {
            return col - (this.byteGroupSize - 1) * 2;
        }
        return col % 2;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (!(loc instanceof BytesFieldLocation)) {
            return null;
        }
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        BytesFieldLocation bytesLoc = (BytesFieldLocation)loc;
        int byteIndex = bytesLoc.getByteIndex();
        int columnInByte = bytesLoc.getColumnInByte();
        int size = cu.getLength();
        int residual = size % this.byteGroupSize;
        if (!this.displayStructureAlignmentBytes && byteIndex >= size) {
            byteIndex = size - 1;
            columnInByte = 2;
        }
        int tokenIndex = byteIndex / this.byteGroupSize;
        int tokenOffset = byteIndex % this.byteGroupSize * 2 + columnInByte;
        if (byteIndex >= size && residual != 0) {
            if (byteIndex - size < this.byteGroupSize - residual) {
                tokenOffset -= residual * 2;
            }
            ++tokenIndex;
        }
        ListingTextField btf = (ListingTextField)bf;
        RowColLocation rcl = btf.dataToScreenLocation(tokenIndex, tokenOffset);
        if (this.hasSamePath(bf, loc)) {
            return new FieldLocation(index, fieldNum, rcl.row(), rcl.col());
        }
        return null;
    }

    @Override
    public Color getDefaultColor() {
        return DEFAULT_COLOR;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new BytesFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }
}

