/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;

public class BitFieldDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    public BitFieldDataTypeHTMLRepresentation(BitFieldDataType bitFieldDt) {
        super(BitFieldDataTypeHTMLRepresentation.buildHTMLText(bitFieldDt));
    }

    private static String buildHTMLText(BitFieldDataType bitFieldDt) {
        StringBuffer buffer = new StringBuffer();
        String description = bitFieldDt.getDescription();
        if (description == null || description.length() == 0) {
            description = bitFieldDt.getDisplayName();
        }
        description = HTMLUtilities.friendlyEncodeHTML((String)description);
        buffer.append(description);
        DataType baseDataType = bitFieldDt.getBaseDataType();
        buffer.append("<BR>").append("<BR>");
        buffer.append("Bitfield Base Data Type: ").append("<BR>");
        buffer.append("<P STYLE='margin-left: 10px;'>");
        HTMLDataTypeRepresentation representation = ToolTipUtils.getHTMLRepresentation(baseDataType);
        String baseHTML = representation.getHTMLContentString();
        buffer.append(baseHTML);
        if (baseHTML.indexOf("Length: ") < 0) {
            BitFieldDataTypeHTMLRepresentation.addDataTypeLength(baseDataType, buffer);
        }
        buffer.append("</P>");
        return buffer.toString();
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        throw new AssertException("Bitfield types are not diffable at this time");
    }
}

