/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.headless;

import ghidra.util.ErrorLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

class HeadlessErrorLogger
implements ErrorLogger {
    private PrintWriter logWriter;

    HeadlessErrorLogger(File logFile) {
        if (logFile != null) {
            this.setLogFile(logFile);
        }
    }

    synchronized void setLogFile(File logFile) {
        try {
            if (logFile == null) {
                if (this.logWriter != null) {
                    this.writeLog("INFO", "File logging disabled");
                    this.logWriter.close();
                    this.logWriter = null;
                }
                return;
            }
            PrintWriter w = new PrintWriter(new FileWriter(logFile));
            if (this.logWriter != null) {
                this.writeLog("INFO ", "Switching log file to: " + logFile);
                this.logWriter.close();
            }
            this.logWriter = w;
        }
        catch (IOException e) {
            System.err.println("Failed to open log file " + logFile + ": " + e.getMessage());
        }
    }

    private synchronized void writeLog(String line) {
        if (this.logWriter == null) {
            return;
        }
        this.logWriter.println(line);
    }

    private synchronized void writeLog(String level, String[] lines) {
        if (this.logWriter == null) {
            return;
        }
        for (String line : lines) {
            this.writeLog(level + " " + line);
        }
        this.logWriter.flush();
    }

    private synchronized void writeLog(String level, String text) {
        if (this.logWriter == null) {
            return;
        }
        this.writeLog(level, this.chopLines(text));
    }

    private synchronized void writeLog(String level, String text, Throwable throwable) {
        if (this.logWriter == null) {
            return;
        }
        this.writeLog(level, this.chopLines(text));
        for (StackTraceElement element : throwable.getStackTrace()) {
            this.writeLog(level + " " + element.toString());
        }
        this.logWriter.flush();
    }

    private String[] chopLines(String text) {
        text = text.replace("\r", "");
        return text.split("\n");
    }

    public void debug(Object originator, Object message) {
    }

    public void debug(Object originator, Object message, Throwable throwable) {
    }

    public void error(Object originator, Object message) {
        this.writeLog("ERROR", message.toString());
    }

    public void error(Object originator, Object message, Throwable throwable) {
        this.writeLog("ERROR", message.toString(), throwable);
    }

    public void info(Object originator, Object message) {
        this.writeLog("INFO ", message.toString());
    }

    public void info(Object originator, Object message, Throwable throwable) {
    }

    public void trace(Object originator, Object message) {
    }

    public void trace(Object originator, Object message, Throwable throwable) {
    }

    public void warn(Object originator, Object message) {
        this.writeLog("WARN ", message.toString());
    }

    public void warn(Object originator, Object message, Throwable throwable) {
        this.writeLog("WARN ", message.toString(), throwable);
    }
}

