/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class RoutinesCommand
extends LoadCommand {
    private long init_address;
    private long init_module;
    private long reserved1;
    private long reserved2;
    private long reserved3;
    private long reserved4;
    private long reserved5;
    private long reserved6;
    private boolean is32bit;

    static RoutinesCommand createRoutinesCommand(FactoryBundledWithBinaryReader reader, boolean is32bit) throws IOException {
        RoutinesCommand command = (RoutinesCommand)reader.getFactory().create(RoutinesCommand.class, new Object[0]);
        command.initRoutinesCommand(reader, is32bit);
        return command;
    }

    private void initRoutinesCommand(FactoryBundledWithBinaryReader reader, boolean is32bit) throws IOException {
        this.initLoadCommand(reader);
        this.is32bit = is32bit;
        if (is32bit) {
            this.init_address = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.init_module = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.reserved1 = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.reserved2 = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.reserved3 = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.reserved4 = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.reserved5 = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.reserved6 = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else {
            this.init_address = reader.readNextLong();
            this.init_module = reader.readNextLong();
            this.reserved1 = reader.readNextLong();
            this.reserved2 = reader.readNextLong();
            this.reserved3 = reader.readNextLong();
            this.reserved4 = reader.readNextLong();
            this.reserved5 = reader.readNextLong();
            this.reserved6 = reader.readNextLong();
        }
    }

    public long getInitializationRoutineAddress() {
        return this.init_address;
    }

    public long getInitializationRoutineModuleIndex() {
        return this.init_module;
    }

    public long getReserved1() {
        return this.reserved1;
    }

    public long getReserved2() {
        return this.reserved2;
    }

    public long getReserved3() {
        return this.reserved3;
    }

    public long getReserved4() {
        return this.reserved4;
    }

    public long getReserved5() {
        return this.reserved5;
    }

    public long getReserved6() {
        return this.reserved6;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        if (this.is32bit) {
            struct.add(DWORD, "init_address", null);
            struct.add(DWORD, "init_module", null);
            struct.add(DWORD, "reserved1", null);
            struct.add(DWORD, "reserved2", null);
            struct.add(DWORD, "reserved3", null);
            struct.add(DWORD, "reserved4", null);
            struct.add(DWORD, "reserved5", null);
            struct.add(DWORD, "reserved6", null);
        } else {
            struct.add(QWORD, "init_address", null);
            struct.add(QWORD, "init_module", null);
            struct.add(QWORD, "reserved1", null);
            struct.add(QWORD, "reserved2", null);
            struct.add(QWORD, "reserved3", null);
            struct.add(QWORD, "reserved4", null);
            struct.add(QWORD, "reserved5", null);
            struct.add(QWORD, "reserved6", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "routines_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address addr = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(addr, this.toDataType());
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }
}

