/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import ghidra.app.plugin.core.stackeditor.BiDirectionStructure;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.AssertException;
import java.util.Collections;
import java.util.Comparator;

public abstract class BiDirectionDataType
extends StructureDataType
implements BiDirectionStructure {
    protected static Comparator<Object> ordinalComparator = new Structure.OrdinalComparator();
    protected static Comparator<Object> offsetComparator = new Structure.OffsetComparator();
    protected int negativeLength;
    protected int positiveLength;
    protected int splitOffset;

    protected BiDirectionDataType(String name, int negativeLength, int positiveLength, int splitOffset, DataTypeManager dtm) {
        super(CategoryPath.ROOT, name, negativeLength + positiveLength, dtm);
        this.negativeLength = negativeLength;
        this.positiveLength = positiveLength;
        this.splitOffset = splitOffset;
    }

    protected BiDirectionDataType(CategoryPath catPath, String name, int negativeLength, int positiveLength, int splitOffset, DataTypeManager dtm) {
        super(catPath, name, negativeLength + positiveLength, dtm);
        this.negativeLength = negativeLength;
        this.positiveLength = positiveLength;
        this.splitOffset = splitOffset;
    }

    protected DataTypeComponent getDefinedComponentAt(int offset) {
        if (offset < this.splitOffset - this.negativeLength || offset >= this.splitOffset + this.positiveLength) {
            return null;
        }
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        if (index >= 0) {
            return (DataTypeComponent)this.components.get(index);
        }
        return null;
    }

    public DataTypeComponent getComponentAt(int offset) {
        if (offset < this.splitOffset - this.negativeLength || offset >= this.splitOffset + this.positiveLength) {
            return null;
        }
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        if (index >= 0) {
            return (DataTypeComponent)this.components.get(index);
        }
        int ordinal = 0;
        int prevIndex = (index = -index - 1) - 1;
        if (prevIndex < 0) {
            ordinal = offset + this.negativeLength - this.splitOffset;
        } else {
            DataTypeComponent prevComp = (DataTypeComponent)this.components.get(prevIndex);
            int prevOrdinal = prevComp.getOrdinal();
            int prevOffset = prevComp.getOffset();
            int endOffset = prevComp.getEndOffset();
            if (offset > prevOffset && offset <= endOffset) {
                return null;
            }
            ordinal = prevOrdinal + offset - endOffset;
        }
        return new DataTypeComponentImpl(DataType.DEFAULT, (CompositeDataTypeImpl)this, 1, ordinal, offset);
    }

    @Override
    public int getSplitOffset() {
        return this.splitOffset;
    }

    @Override
    public int getNegativeLength() {
        return this.negativeLength;
    }

    @Override
    public int getPositiveLength() {
        return this.positiveLength;
    }

    public int getLength() {
        return this.structLength;
    }

    public void delete(int index) {
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        DataTypeComponent comp = this.getComponent(index);
        int offset = comp.getOffset();
        int length = comp.getLength();
        int idx = Collections.binarySearch(this.components, new Integer(index), ordinalComparator);
        if (idx >= 0) {
            DataTypeComponent dtc = (DataTypeComponent)this.components.remove(idx);
            dtc.getDataType().removeParent((DataType)this);
            length = dtc.getLength();
        } else {
            idx = -idx - 1;
            length = 1;
        }
        this.adjustOffsets(idx, offset, -1, -length);
        --this.numComponents;
        this.notifySizeChanged();
    }

    public void delete(int[] ordinals) {
        for (int ordinal : ordinals) {
            this.delete(ordinal);
        }
    }

    protected void adjustOffsets(int idx, int offset, int deltaOrdinal, int deltaLength) {
        if (offset >= this.splitOffset) {
            this.shiftOffsets(idx, deltaOrdinal, deltaLength);
            this.positiveLength += deltaLength;
        } else if (offset - deltaLength > this.splitOffset) {
            this.shiftOffsets(0, idx - 1, 0, offset);
            this.shiftOffsets(idx, deltaOrdinal, offset - deltaLength);
            this.negativeLength += offset;
            this.positiveLength -= offset - deltaLength;
        } else {
            this.shiftOffsets(0, idx - 1, 0, -deltaLength);
            this.shiftOffsets(idx, deltaOrdinal, 0);
            this.negativeLength += deltaLength;
        }
        this.structLength += deltaLength;
    }

    private void shiftOffsets(int index, int deltaOrdinal, int deltaOffset) {
        this.shiftOffsets(index, this.components.size() - 1, deltaOrdinal, deltaOffset);
    }

    protected void shiftOffsets(int startIndex, int endIndex, int deltaOrdinal, int deltaOffset) {
        for (int i = startIndex; i <= endIndex && i < this.components.size(); ++i) {
            DataTypeComponentImpl dtc = (DataTypeComponentImpl)this.components.get(i);
            this.shiftOffset(dtc, deltaOrdinal, deltaOffset);
        }
    }

    protected DataTypeComponent getDefinedComponent(int ordinal) {
        if (ordinal < 0 || ordinal >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(ordinal);
        }
        int idx = Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
        if (idx >= 0) {
            return (DataTypeComponent)this.components.get(idx);
        }
        return null;
    }

    public DataTypeComponent getComponent(int ordinal) {
        if (ordinal < 0 || ordinal >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(ordinal);
        }
        int idx = Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
        if (idx >= 0) {
            return (DataTypeComponent)this.components.get(idx);
        }
        idx = -idx - 1;
        int prevIndex = idx - 1;
        int offset = this.computeOffset(ordinal, prevIndex);
        return new DataTypeComponentImpl(DataType.DEFAULT, (CompositeDataTypeImpl)this, 1, ordinal, offset);
    }

    protected int computeOffset(int ordinal, int prevIndex) {
        int offset;
        if (prevIndex < 0) {
            offset = this.splitOffset - this.negativeLength + ordinal;
        } else {
            DataTypeComponent prevElement = (DataTypeComponent)this.components.get(prevIndex);
            int prevOrdinal = prevElement.getOrdinal();
            int endOffset = prevElement.getEndOffset();
            offset = endOffset + ordinal - prevOrdinal;
        }
        return offset;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public DataTypeComponentImpl insertAtOffset(int offset, DataType dataType, int length, String newName, String comment) {
        DataTypeComponent dtc;
        int deltaLength;
        if (offset < this.splitOffset - this.negativeLength || offset >= this.splitOffset + this.positiveLength) {
            throw new IllegalArgumentException("Offset " + offset + " is not in " + this.getDisplayName() + ".");
        }
        this.validateDataType(dataType);
        int nextOffset = offset + length;
        if (offset > this.positiveLength) {
            deltaLength = offset - this.positiveLength;
            this.numComponents += deltaLength;
            this.positiveLength += deltaLength;
            this.structLength += deltaLength;
        }
        if (nextOffset < this.splitOffset - this.negativeLength) {
            deltaLength = this.splitOffset - nextOffset - this.negativeLength;
            this.numComponents += deltaLength;
            this.negativeLength += deltaLength;
            this.structLength += deltaLength;
        }
        this.checkAncestry(dataType);
        dataType = dataType.clone(this.getDataTypeManager());
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        int additionalShift = 0;
        if (index >= 0) {
            DataTypeComponent dtc2 = (DataTypeComponent)this.components.get(index);
            additionalShift = offset < 0 ? offset - dtc2.getEndOffset() : offset - dtc2.getOffset();
        } else {
            index = -index - 1;
        }
        int ordinal = this.negativeLength + offset;
        if (index > 0) {
            dtc = (DataTypeComponent)this.components.get(index - 1);
            ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
        }
        dtc = new DataTypeComponentImpl(dataType, (CompositeDataTypeImpl)this, length, ordinal, offset, newName, comment);
        dataType.addParent((DataType)this);
        this.adjustOffsets(index, offset, 1 + additionalShift, dtc.getLength() + additionalShift);
        this.components.add(index, dtc);
        ++this.numComponents;
        this.notifySizeChanged();
        return dtc;
    }

    public DataTypeComponent add(DataType dataType, int length, String newName, String comment) {
        return this.addPositive(dataType, length, newName, comment);
    }

    @Override
    public DataTypeComponent addPositive(DataType dataType, int length, String newName, String comment) {
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        dataType = dataType.clone(this.getDataTypeManager());
        int offset = this.positiveLength;
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, (CompositeDataTypeImpl)this, length, this.numComponents, offset, newName, comment);
        dataType.addParent((DataType)this);
        this.components.add(dtc);
        ++this.numComponents;
        this.positiveLength += length;
        this.structLength += length;
        this.notifySizeChanged();
        return dtc;
    }

    @Override
    public DataTypeComponent addNegative(DataType dataType, int length, String newName, String comment) {
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        dataType = dataType.clone(this.getDataTypeManager());
        this.shiftOffsets(0, this.numComponents - 1, 1, 0);
        int offset = this.splitOffset - this.negativeLength - length;
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, (CompositeDataTypeImpl)this, length, 0, offset, newName, comment);
        dataType.addParent((DataType)this);
        this.components.add(dtc);
        ++this.numComponents;
        this.negativeLength += length;
        this.structLength += length;
        this.notifySizeChanged();
        return dtc;
    }

    public void growStructure(int amount) {
        int absAmount;
        if (amount < 0) {
            absAmount = -amount;
            this.negativeLength -= amount;
            this.adjustOffsets(0, this.negativeLength, absAmount, 0);
        } else {
            absAmount = amount;
            this.positiveLength += amount;
        }
        this.numComponents += absAmount;
        this.structLength += absAmount;
        this.notifySizeChanged();
    }

    public DataTypeComponent insert(int index, DataType dataType, int length, String newName, String comment) {
        throw new AssertException("BiDirectionDataType.insert() not implemented.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void insertAtOffset(int offset, int numBytes) {
        if (offset < this.splitOffset - this.negativeLength || offset > this.splitOffset + this.positiveLength) {
            throw new IllegalArgumentException("Offset " + offset + " is not a valid insertion point in " + this.getDisplayName() + ".");
        }
        DataTypeComponent dtc = this.getComponentAt(offset);
        int numDefinedComponents = this.components.size();
        int definedIndex = 0;
        if (dtc == null) {
            if (offset != this.positiveLength) throw new IllegalArgumentException("Offset " + offset + " is not a valid insertion point in " + this.getDisplayName() + ".");
            definedIndex = numDefinedComponents;
        } else {
            if (dtc.getOffset() != offset) {
                throw new IllegalArgumentException("Cannot insert at offset " + offset + " within a defined component in " + this.getDisplayName() + ".");
            }
            definedIndex = Collections.binarySearch(this.components, new Integer(dtc.getOrdinal()), ordinalComparator);
            if (definedIndex < 0) {
                definedIndex = -definedIndex - 1;
            }
        }
        if (offset <= 0) {
            this.shiftOffsets(0, definedIndex - 1, 0, -numBytes);
            this.shiftOffsets(definedIndex, numDefinedComponents - 1, numBytes, 0);
            this.negativeLength += numBytes;
        } else {
            this.shiftOffsets(definedIndex, numDefinedComponents - 1, numBytes, numBytes);
            this.positiveLength += numBytes;
        }
        this.numComponents += numBytes;
        this.structLength += numBytes;
        this.notifySizeChanged();
    }

    public void deleteAtOffset(int offset) {
        if (offset < this.splitOffset - this.negativeLength || offset >= this.splitOffset + this.positiveLength) {
            throw new IllegalArgumentException("Offset " + offset + " is not in " + this.getDisplayName() + ".");
        }
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        int length = 1;
        if (index < 0) {
            index = -index - 1;
        } else {
            DataTypeComponent dtc = (DataTypeComponent)this.components.remove(index);
            dtc.getDataType().removeParent((DataType)this);
            length = dtc.getLength();
        }
        this.adjustOffsets(index, offset, -1, -length);
        --this.numComponents;
    }

    public boolean isEquivalent(DataType dataType) {
        if (dataType == this) {
            return true;
        }
        if (dataType == null) {
            return false;
        }
        if (dataType instanceof BiDirectionStructure) {
            DataTypeComponent[] otherComps;
            BiDirectionStructure biDir = (BiDirectionStructure)dataType;
            if (this.splitOffset != biDir.getSplitOffset() || this.negativeLength != biDir.getNegativeLength() || this.positiveLength != biDir.getPositiveLength() || this.structLength != biDir.getLength()) {
                return false;
            }
            DataTypeComponent[] myComps = this.getDefinedComponents();
            if (myComps.length != (otherComps = biDir.getDefinedComponents()).length) {
                return false;
            }
            for (int i = 0; i < myComps.length; ++i) {
                if (myComps[i].isEquivalent(otherComps[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void dataTypeSizeChanged(DataType dt) {
        throw new AssertException("BiDirectionDataType.dataTypeSizeChanged() not implemented.");
    }

    public abstract DataType clone(DataTypeManager var1);

    public void clearComponent(int index) {
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int idx = Collections.binarySearch(this.components, new Integer(index), ordinalComparator);
        if (idx >= 0) {
            DataTypeComponent dtc = (DataTypeComponent)this.components.remove(idx);
            dtc.getDataType().removeParent((DataType)this);
            int len = dtc.getLength();
            int deltaLength = len - 1;
            if (len > 1) {
                this.shiftOffsets(idx, deltaLength, 0);
                this.numComponents += deltaLength;
            }
        }
    }

    public void replaceWith(Structure struct) {
        throw new AssertException("BiDirectionDataType.replaceWith() not implemented.");
    }

    public void dataTypeDeleted(DataType dt) {
        throw new AssertException("BiDirectionDataType.dataTypeDeleted() not implemented.");
    }

    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        throw new AssertException("BiDirectionDataType.dataTypeReplaced() not implemented.");
    }

    public DataTypeComponent[] getDefinedComponents() {
        return this.components.toArray(new DataTypeComponent[this.components.size()]);
    }

    public DataTypeComponent[] getComponents() {
        DataTypeComponent[] comps = new DataTypeComponent[this.numComponents];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = this.getComponent(i);
        }
        return comps;
    }

    public DataTypeComponent replace(int index, DataType dataType, int length, String newName, String comment) {
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        dataType = dataType.clone(this.getDataTypeManager());
        DataTypeComponent origDtc = this.getComponent(index);
        return this.replace(origDtc, dataType, length, newName, comment);
    }

    public DataTypeComponent replaceAtOffset(int offset, DataType dataType, int length, String newName, String comment) {
        if (offset < this.splitOffset - this.negativeLength || offset >= this.splitOffset + this.positiveLength) {
            throw new IllegalArgumentException("Offset " + offset + " is not in " + this.getDisplayName() + ".");
        }
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        dataType = dataType.clone(this.getDataTypeManager());
        DataTypeComponent origDtc = this.getComponentAt(offset);
        DataTypeComponent newDtc = this.replace(origDtc, dataType, length, newName, comment);
        return newDtc;
    }

    private DataTypeComponent replace(DataTypeComponent origDtc, DataType dataType, int length, String newName, String comment) {
        int bytesAvailable;
        int ordinal = origDtc.getOrdinal();
        int newOffset = origDtc.getOffset();
        int dtcLength = origDtc.getLength();
        int bytesNeeded = length - dtcLength;
        int deltaOrdinal = -bytesNeeded;
        if (bytesNeeded > 0 && (bytesAvailable = this.getNumUndefinedBytes(ordinal + 1)) < bytesNeeded) {
            deltaOrdinal = -bytesAvailable;
            length -= bytesNeeded - bytesAvailable;
        }
        origDtc.getDataType().removeParent((DataType)this);
        DataTypeComponentImpl newDtc = new DataTypeComponentImpl(dataType, (CompositeDataTypeImpl)this, length, ordinal, newOffset, newName, comment);
        dataType.addParent((DataType)this);
        int index = Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
        if (index < 0) {
            index = -index - 1;
        } else {
            this.components.remove(index);
        }
        if (deltaOrdinal != 0) {
            this.adjustOffsets(index, newOffset, deltaOrdinal, 0);
        }
        this.components.add(index, newDtc);
        if (deltaOrdinal != 0) {
            this.numComponents += deltaOrdinal;
        }
        return newDtc;
    }
}

